/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _PROCESSING_OPTIONS_H_
#define _PROCESSING_OPTIONS_H_

#include <QVariant>

class QDomDocument;
class QDomElement;
class QString;
class QVariant;

class ProcessingOptions {
  public:
    ProcessingOptions();
    ProcessingOptions(const ProcessingOptions& );
    ProcessingOptions& operator=(const ProcessingOptions& _rhs );
    ~ProcessingOptions();
    void setOption( const QString& _key, const QVariant& _value );
    bool asBool( const QString& _key ) const;
    qint32 asInteger( const QString& _key ) const;
    double asDouble( const QString& _key ) const;
    QList<QPointF> asPointFList( const QString& _key ) const;
    QString asString( const QString& _key, const QString& _defaultValue = "" ) const;
    const QVariant& option( const QString& _key ) const;
    QString toXml() const;
    void toXml(QDomDocument& doc, QDomElement& root) const;
    void fromXml( const QString& );
    void fromXml(const QDomElement&);
  private:
    struct Private;
    Private* const d;
};

Q_DECLARE_METATYPE ( ProcessingOptions )

#endif
