# Extra Configs and Features

## DROP-IN FILES

The systemd service descriptors do already have the feature
of drop-in configurations. So when there is a docker container
with these files:

    /usr/lib/systemd/system/some.service
    /usr/lib/systemd/system/some.service.d/extra.conf
    /etc/systemd/system/some.service.d/override.conf

then ALL these files will be parsed. Therefore some `*.rpm`
program may install the `some.service` file but you can always
override the settings with your `override.conf`.

In general the new lines will be added to the existing config
entries. So when you have

    # some.service
    [Service]
    Environment=A=1 B=2
    ExecStartPre=/usr/bin/somecheck
    
    # some.service.d/extra.conf
    [Service]
    Environment=C=2
    ExecStartPre=/usr/bin/morechecks

then both of these commands are being executed and the environment
contains A, B and C variables for all commands.

There is a feature where you can also replace the original settings
completely by giving an option with an empty argument:

    # some.service
    [Service]
    Environment=A=1 B=2
    ExecStart=/usr/bin/startup $A $B
    
    # some.service.d/override.conf
    [Service]
    Environment=C=2
    ExecStart=
    ExecStart=/usr/bin/startup $A $B $C

In the latter case, only one ExecStart command will be executed
having three arguments.

All these are standard features of systemd. In general they are
meant to be used by configuration programs that can add or change
some environment variables materializing the extra settings as
an extra.conf instead of changing the original service descriptor
file. However the way to append/replace a setting is completely 
generic - it is part of the parser and not of the interpreter for 
the service definitions. Thus it works also for the Exec-parts.

## STANDARD DEFINITION

https://www.freedesktop.org/software/systemd/man/systemd.unit.html

> Along with a unit file `foo.service`, a "drop-in" directory 
> `foo.service.d/` may exist. All files with the suffix `".conf"` 
> from this directory will be parsed after the unit file itself 
> is parsed. This is useful to alter or add configuration settings 
> for a unit, without having to modify unit files. Drop-in files 
> must contain appropriate section headers. For instantiated units, 
> this logic will first look for the instance `".d/"` subdirectory 
> (e.g. `"foo@bar.service.d/"`) and read its `".conf"` files, 
> followed by the template `".d/"` subdirectory (e.g. 
> `"foo@.service.d/"`) and the `".conf"` files there. Moreover for 
> units names containing dashes (`"-"`), the set of directories 
> generated by truncating the unit name after all dashes is searched 
> too. Specifically, for a unit name `foo-bar-baz.service` not only 
> the regular drop-in directory `foo-bar-baz.service.d/` is searched 
> but also both `foo-bar-.service.d/` and `foo-.service.d/`. This is 
> useful for defining common drop-ins for a set of related units, 
> whose names begin with a common prefix. This scheme is particularly 
> useful for mount, automount and slice units, whose systematic 
> naming structure is built around dashes as component separators. 
> Note that equally named drop-in files further down the prefix 
> hierarchy override those further up, i.e. 
> `foo-bar-.service.d/10-override.conf` overrides 
> `foo-.service.d/10-override.conf`.

> In addition to `/etc/systemd/system`, the drop-in `".d/"` directories 
> for system services can be placed in `/usr/lib/systemd/system` or 
> `/run/systemd/system` directories. Drop-in files in `/etc` take 
> precedence over those in `/run` which in turn take precedence over 
> those in `/usr/lib`. Drop-in files under any of these directories 
> take precedence over unit files wherever located. Multiple drop-in 
> files with different names are applied in lexicographic order, 
> regardless of which of the directories they reside in.

Note that the last paragraph is a bit misleading as "predence" is
defined for `*.conf` files of the same name. An `"extra.conf"` in
the `/etc` area will mask an `"extra.conf"` in `/usr/lib`. Otherwise
the order of conf-files is just lexicographic irrespective of the
location, so that administrators will often choose to prefix the
conf-files by number to ensure proper inclusion order, i.e. using
some `"01-extra.conf"` to `"99-override.conf"` file names.

As for the systemctl replacement script the feature of a shortened
`foo-.service.d` is not implemented. (The systemctl script does
also ignore many of the standard definitions about template service
files). Therefore overrides must be specific for each service and
not a group of them.

## EXAMPLE

    /etc/systemd/system/some.service
    /etc/systemd/system/some.service.d/extra.conf
    /etc/systemd/system/some.service.d/zen.conf
    /usr/lib/system/some.service.d/addon.conf
    /usr/lib/system/some.service.d/override.conf

The parsing order is this

    some.service
    addon.conf
    extra.conf
    override.conf
    zen.conf
