// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Data.Common;

namespace Microsoft.Data.Sqlite;

/// <summary>
///     Creates instances of various Microsoft.Data.Sqlite classes.
/// </summary>
public class SqliteFactory : DbProviderFactory
{
    private SqliteFactory()
    {
    }

    /// <summary>
    ///     The singleton instance.
    /// </summary>
    public static readonly SqliteFactory Instance = new();

    /// <summary>
    ///     Creates a new command.
    /// </summary>
    /// <returns>The new command.</returns>
    public override DbCommand CreateCommand()
        => new SqliteCommand();

    /// <summary>
    ///     Creates a new connection.
    /// </summary>
    /// <returns>The new connection.</returns>
    public override DbConnection CreateConnection()
        => new SqliteConnection();

    /// <summary>
    ///     Creates a new connection string builder.
    /// </summary>
    /// <returns>The new connection string builder.</returns>
    public override DbConnectionStringBuilder CreateConnectionStringBuilder()
        => new SqliteConnectionStringBuilder();

    /// <summary>
    ///     Creates a new parameter.
    /// </summary>
    /// <returns>The new parameter.</returns>
    public override DbParameter CreateParameter()
        => new SqliteParameter();
}
