// #Conformance #UnitsOfMeasure 
#light

[<Measure>] type kg   // kilogram 
[<Measure>] type m    // metre 
[<Measure>] type s    // second 
[<Measure>] type A    // ampere 
[<Measure>] type mol  // mole 
[<Measure>] type K    // kelvin 
[<Measure>] type cd   // candela 

[<Measure>] type rad = m/m       // radian 
[<Measure>] type sr = m^2/m^2    // steradian 
[<Measure>] type Hz = s^-1       // hertz 
[<Measure>] type N = kg m / s^2  // newton 
[<Measure>] type Pa = N / m^2    // pascal 
[<Measure>] type J = N m         // joule 
[<Measure>] type W = J / s       // watt 
[<Measure>] type C = s A         // coulomb 
[<Measure>] type V = W/A         // watt 
[<Measure>] type F = C/V         // farad 
[<Measure>] type ohm = V/A       // ohm 
[<Measure>] type S = A/V         // siemens 
[<Measure>] type Wb = V s        // weber 
[<Measure>] type T = Wb/m^2      // tesla 
[<Measure>] type H = Wb/A        // henry 
[<Measure>] type lm = cd sr      // lumen 
[<Measure>] type lx = lm/m^2     // lux 
[<Measure>] type Bq = s^-1       // becquerel 
[<Measure>] type Gy = J/kg       // gray 
[<Measure>] type Sv = J/kg       // sievert 
[<Measure>] type kat = mol/s     // katal 
