/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins;

import info.dolezel.fatrat.plugins.TransferPlugin;
import info.dolezel.fatrat.plugins.extra.DownloadUrl;
import info.dolezel.fatrat.plugins.listeners.CaptchaListener;
import info.dolezel.fatrat.plugins.listeners.PageFetchListener;
import info.dolezel.fatrat.plugins.listeners.ReCaptchaListener;
import info.dolezel.fatrat.plugins.listeners.WaitListener;
import info.dolezel.fatrat.plugins.util.FormatUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public abstract class DownloadPlugin
extends TransferPlugin {
    private static final Pattern reImageCode = Pattern.compile("challenge : '([^']+)");

    public abstract void processLink(String var1);

    public void onFailed() {
    }

    protected final native void startDownload(DownloadUrl var1);

    protected final void startDownload(String string, String string2, String string3, String string4) {
        this.startDownload(new DownloadUrl(string).setReferrer(string2).setUserAgent(string3).setFileName(string4));
    }

    protected final void startDownload(String string) {
        this.startDownload(new DownloadUrl(string));
    }

    protected final void startDownload(String string, String string2) {
        this.startDownload(new DownloadUrl(string).setReferrer(string2));
    }

    protected final void startDownload(String string, String string2, String string3) {
        this.startDownload(new DownloadUrl(string).setReferrer(string2).setUserAgent(string3));
    }

    protected final native void startWait(int var1, WaitListener var2);

    protected final native void solveCaptcha(String var1, CaptchaListener var2);

    protected void solveCaptchaLoadLocally(String string, final CaptchaListener captchaListener) {
        this.fetchPage(string, new PageFetchListener(){

            @Override
            public void onCompleted(ByteBuffer byteBuffer, Map<String, String> map) {
                String string = map.containsKey("content-type") ? map.get("content-type") : "";
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                String string2 = "data:" + string + ";base64," + Base64.encodeBase64String((byte[])byArray);
                DownloadPlugin.this.solveCaptcha(string2, captchaListener);
            }

            @Override
            public void onFailed(String string) {
                captchaListener.onFailed();
            }
        });
    }

    protected void solveReCaptcha(String string, final ReCaptchaListener reCaptchaListener) {
        this.fetchPage("http://www.google.com/recaptcha/api/challenge?k=" + string + "&ajax=1", new PageFetchListener(){

            @Override
            public void onCompleted(ByteBuffer byteBuffer, Map<String, String> map) {
                CharBuffer charBuffer = DownloadPlugin.this.charsetUtf8.decode(byteBuffer);
                final Matcher matcher = reImageCode.matcher(charBuffer);
                if (!matcher.find()) {
                    DownloadPlugin.this.setFailed("Failed to find the captcha image code");
                    return;
                }
                DownloadPlugin.this.solveCaptcha("http://www.google.com/recaptcha/api/image?c=" + matcher.group(1), new CaptchaListener(){

                    @Override
                    public void onFailed() {
                        reCaptchaListener.onFailed();
                    }

                    @Override
                    public void onSolved(String string) {
                        reCaptchaListener.onSolved(string, matcher.group(1));
                    }
                });
            }

            @Override
            public void onFailed(String string) {
                DownloadPlugin.this.setFailed(string);
            }
        });
    }

    protected final native void reportFileName(String var1);

    public void finalCheck(String string) {
    }

    public static String formatTime(int n) {
        return FormatUtils.formatTime(n);
    }
}

