/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.servlet.BadURLException;
import opendap.util.EscapeStrings;

public class ReqState {
    private String defaultDDXcache;
    private String defaultDDScache;
    private String defaultDAScache;
    private String defaultINFOcache;
    private final String defaultSchemaName = "opendap-0.0.0.xsd";
    private String defaultSchemaLocation;
    private String dataSetName;
    private String requestSuffix;
    private String CE;
    private Object obj = null;
    private String serverClassName;
    private String requestURL;
    private ServletConfig myServletConfig;
    private HttpServletRequest myHttpRequest;
    private HttpServletResponse response;

    public ReqState(HttpServletRequest myRequest, HttpServletResponse response, ServletConfig sc, String serverClassName) throws BadURLException {
        this.myServletConfig = sc;
        this.myHttpRequest = myRequest;
        this.response = response;
        this.serverClassName = serverClassName;
        String query = this.myHttpRequest.getQueryString();
        String string = this.CE = query == null ? "" : EscapeStrings.www2ce(query);
        if (this.CE == null) {
            this.CE = "";
        }
        this.processDodsURL();
        String servletPath = this.myHttpRequest.getServletPath();
        this.defaultDDXcache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/ddx") + "/";
        this.defaultDDScache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/dds") + "/";
        this.defaultDAScache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/das") + "/";
        this.defaultINFOcache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/info") + "/";
        int index = this.myHttpRequest.getRequestURL().lastIndexOf(this.myHttpRequest.getServletPath());
        this.defaultSchemaLocation = this.myHttpRequest.getRequestURL().substring(0, index) + "/schema/" + "opendap-0.0.0.xsd";
        this.requestURL = this.myHttpRequest.getRequestURL().toString();
    }

    public String getDataSet() {
        return this.dataSetName;
    }

    public String getServerClassName() {
        return this.serverClassName;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public String getConstraintExpression() {
        return this.CE;
    }

    public HttpServletRequest getRequest() {
        return this.myHttpRequest;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getDDXCache() {
        String cacheDir = this.getInitParameter("DDXcache");
        if (cacheDir == null) {
            cacheDir = this.defaultDDXcache;
        }
        return cacheDir;
    }

    public void setDefaultDDXCache(String cachedir) {
        this.defaultDDXcache = cachedir;
    }

    public String getDDSCache() {
        String cacheDir = this.getInitParameter("DDScache");
        if (cacheDir == null) {
            cacheDir = this.defaultDDScache;
        }
        return cacheDir;
    }

    public void setDefaultDDSCache(String cachedir) {
        this.defaultDDScache = cachedir;
    }

    public String getDASCache() {
        String cacheDir = this.getInitParameter("DAScache");
        if (cacheDir == null) {
            cacheDir = this.defaultDAScache;
        }
        return cacheDir;
    }

    public void setDefaultDASCache(String cachedir) {
        this.defaultDAScache = cachedir;
    }

    public String getINFOCache() {
        String cacheDir = this.getInitParameter("INFOcache");
        if (cacheDir == null) {
            cacheDir = this.defaultINFOcache;
        }
        return cacheDir;
    }

    public void setDefaultINFOCache(String cachedir) {
        this.defaultINFOcache = cachedir;
    }

    public String getSchemaLocation() {
        String cacheDir = this.getInitParameter("SchemaLocation");
        if (cacheDir == null) {
            cacheDir = this.defaultSchemaLocation;
        }
        return cacheDir;
    }

    public void setDefaultSchemaLocation(String location) {
        this.defaultSchemaLocation = location;
    }

    private String prepCE(String ce) {
        if (ce == null) {
            ce = "";
        } else if (!ce.equals("")) {
            int index = ce.indexOf("%");
            if (index == -1) {
                return ce;
            }
            if (index > ce.length() - 3) {
                return null;
            }
            while (index >= 0) {
                String specChar = ce.substring(index + 1, index + 3);
                char val = (char)Byte.parseByte(specChar, 16);
                if ((index = (ce = ce.substring(0, index) + String.valueOf(val) + ce.substring(index + 3, ce.length())).indexOf("%")) <= ce.length() - 3) continue;
                return null;
            }
        }
        return ce;
    }

    protected void processDodsURL() {
        this.dataSetName = this.myHttpRequest.getPathInfo();
        this.requestSuffix = null;
        if (this.dataSetName != null) {
            StringTokenizer st = new StringTokenizer(this.dataSetName, "/");
            String endOPath = "";
            while (st.hasMoreTokens()) {
                endOPath = st.nextToken();
            }
            int index = endOPath.lastIndexOf(46);
            if (index >= 0) {
                this.requestSuffix = endOPath.substring(index + 1);
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.lastIndexOf(46));
            } else {
                this.requestSuffix = "";
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.length());
            }
        }
    }

    public boolean getAcceptsCompressed() {
        boolean isTiny = false;
        String encoding = this.myHttpRequest.getHeader("Accept-Encoding");
        isTiny = encoding != null ? encoding.contains("deflate") : false;
        return isTiny;
    }

    public Enumeration getInitParameterNames() {
        return this.myServletConfig.getInitParameterNames();
    }

    public String getInitParameter(String name) {
        return this.myServletConfig.getInitParameter(name);
    }

    public String getDodsBlobURL_OLDANDBUSTED() {
        int lastDot = this.requestURL.lastIndexOf(46);
        String blobURL = this.requestURL.substring(0, lastDot) + ".blob";
        if (!this.CE.equals("")) {
            blobURL = blobURL + "?" + this.CE;
        }
        return blobURL;
    }

    public Object getUserObject() {
        return this.obj;
    }

    public void setUserObject(Object userObj) {
        this.obj = userObj;
    }

    public String toString() {
        String ts = "ReqState:\n";
        ts = ts + "  serverClassName:    '" + this.serverClassName + "'\n";
        ts = ts + "  dataSet:            '" + this.dataSetName + "'\n";
        ts = ts + "  requestSuffix:      '" + this.requestSuffix + "'\n";
        ts = ts + "  CE:                 '" + this.CE + "'\n";
        ts = ts + "  compressOK:          " + this.getAcceptsCompressed() + "\n";
        ts = ts + "  InitParameters:\n";
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getInitParameter(name);
            ts = ts + "    " + name + ": '" + value + "'\n";
        }
        return ts;
    }
}

