/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.ui.BAMutil;
import thredds.ui.FileManager;
import thredds.ui.IndependentWindow;
import thredds.ui.PopupMenu;
import thredds.ui.TextHistoryPane;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1WriteIndex;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.ui.StructureTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted gridRecordTable;
    private BeanTableSorted gdsTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoPopup;
    private IndependentWindow infoWindow;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private FileManager fileChooser;
    private String location;
    private GridTableLookup lookup;
    private GridIndex index = null;
    private NetcdfFile ncfile;

    public GribTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.gridRecordTable = new BeanTableSorted(GridRecordBean.class, (PreferencesExt)prefs.node("GridRecordBean"), false);
        this.gridRecordTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GridRecordBean mb = (GridRecordBean)GribTable.this.gridRecordTable.getSelectedBean();
                GribTable.this.infoTA.setText(mb.gr.toString());
            }
        });
        PopupMenu varPopup = new PopupMenu(this.gridRecordTable.getJTable(), "Options");
        this.gdsTable = new BeanTableSorted(GdsBean.class, (PreferencesExt)prefs.node("GdsBean"), false);
        this.gdsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GdsBean bean = (GdsBean)GribTable.this.gdsTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                GridDefRecord gds = bean.horizCoordSys.getGds();
                Formatter f = new Formatter();
                f.format("GDS keys%n", new Object[0]);
                ArrayList<String> attKeys = new ArrayList<String>(gds.getKeys());
                Collections.sort(attKeys);
                for (String key : attKeys) {
                    f.format(" %s == %s %n", key, gds.getParam(key));
                }
                GribTable.this.infoTA.setText(f.toString());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split2 = new JSplitPane(0, false, this.gdsTable, this.infoTA);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.gridRecordTable, this.split2);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    private void makeDataTable() {
        this.dataTable = new StructureTable((PreferencesExt)this.prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)this.prefs.getBean("dataWindow", new Rectangle(50, 300, 1000, 600)));
    }

    public void save() {
        this.gridRecordTable.saveState(false);
        this.gdsTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
    }

    public void setGribFile(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
        if (this.location.endsWith(".gbx")) {
            this.setGribFileIndex(raf);
        }
        GribGridServiceProvider iosp = new GribGridServiceProvider();
        this.ncfile = new GribNetcdfFile(iosp, raf);
        this.lookup = iosp.getLookup();
        raf.seek(0L);
        Grib2Input g2i = new Grib2Input(raf);
        int edition = g2i.getEdition();
        File gribFile = new File(raf.getLocation());
        File indexFile = File.createTempFile("GribTable", "gbx");
        if (edition == 1) {
            this.index = new Grib1WriteIndex().writeGribIndex(gribFile, indexFile.getPath(), raf, true);
        } else if (edition == 2) {
            this.index = new Grib2WriteIndex().writeGribIndex(gribFile, indexFile.getPath(), raf, true);
        }
        ArrayList<GridRecordBean> grList = new ArrayList<GridRecordBean>();
        for (GridRecord gr : this.index.getGridRecords()) {
            grList.add(new GridRecordBean((GribGridRecord)gr));
        }
        HashMap<String, GridHorizCoordSys> hcsMap = new HashMap<String, GridHorizCoordSys>();
        List<GridDefRecord> hcsList = this.index.getHorizCoordSys();
        for (GridDefRecord gds : hcsList) {
            GridHorizCoordSys hcs = new GridHorizCoordSys(gds, this.lookup, null);
            hcsMap.put(gds.getParam("GDSkey"), hcs);
        }
        ArrayList<GdsBean> gdsList = new ArrayList<GdsBean>();
        for (String key : hcsMap.keySet()) {
            GridHorizCoordSys hcs = (GridHorizCoordSys)hcsMap.get(key);
            gdsList.add(new GdsBean(key, hcs));
        }
        this.gridRecordTable.setBeans(grList);
        this.gdsTable.setBeans(gdsList);
    }

    public void showInfo(Formatter f) {
        Map<String, String> atts = this.index.getGlobalAttributes();
        ArrayList<String> attKeys = new ArrayList<String>(atts.keySet());
        Collections.sort(attKeys);
        f.format("Grib Index Global Attributes %n", new Object[0]);
        for (String key : attKeys) {
            f.format(" %s == %s %n", key, atts.get(key));
        }
        f.format("%nFile Global Attributes %n", new Object[0]);
        for (Attribute att : this.ncfile.getGlobalAttributes()) {
            f.format(" %s %n", att);
        }
    }

    private void setGribFileIndex(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
    }

    public class GdsBean {
        GridHorizCoordSys horizCoordSys;
        String key;

        public GdsBean() {
        }

        public GdsBean(String key, GridHorizCoordSys m) {
            this.key = key;
            this.horizCoordSys = m;
        }

        public String getKey() {
            return this.key;
        }

        public String getGridName() {
            return this.horizCoordSys.getGridName();
        }

        public String getID() {
            return this.horizCoordSys.getID();
        }

        public boolean isLatLon() {
            return this.horizCoordSys.isLatLon();
        }

        public int getNx() {
            return this.horizCoordSys.getNx();
        }

        public int getNy() {
            return this.horizCoordSys.getNy();
        }

        public double getDxInKm() {
            return this.horizCoordSys.getDxInKm();
        }

        public double getDyInKm() {
            return this.horizCoordSys.getDyInKm();
        }
    }

    public class GridRecordBean {
        GribGridRecord gr;
        GridParameter param;

        public GridRecordBean() {
        }

        public GridRecordBean(GribGridRecord m) {
            this.gr = m;
            this.param = GribTable.this.lookup.getParameter(this.gr);
        }

        public String getLevel() {
            return this.gr.getLevel1() + "/" + this.gr.getLevel2();
        }

        public String getLevelType() {
            return this.gr.getLevelType1() + "/" + this.gr.getLevelType2();
        }

        public String getLevelName() {
            return GribTable.this.lookup.getLevelName(this.gr);
        }

        public String getLevelDescription() {
            return GribTable.this.lookup.getLevelDescription(this.gr);
        }

        public String getLevelUnit() {
            return GribTable.this.lookup.getLevelUnit(this.gr);
        }

        public Date getReferenceTime() {
            return this.gr.getReferenceTime();
        }

        public Date getValidTime() {
            return this.gr.getValidTime();
        }

        public int getOffsetHour() {
            return this.gr.getValidTimeOffset();
        }

        public String getName() {
            return this.param.getName();
        }

        public String getDesc() {
            return this.param.getDescription();
        }

        public String getUnit() {
            return this.param.getUnit();
        }

        public String getGdsId() {
            return this.gr.getGridDefRecordId();
        }

        public int getDecimalScale() {
            return this.gr.getDecimalScale();
        }

        public String getTable() {
            return this.gr.center + "-" + this.gr.subCenter + "-" + this.gr.table;
        }

        public String getParamNo() {
            return this.gr.discipline + "-" + this.gr.category + "-" + this.gr.paramNumber;
        }
    }

    private class GribNetcdfFile
    extends NetcdfFile {
        GribNetcdfFile(IOServiceProvider iosp, RandomAccessFile raf) throws IOException {
            super(iosp, raf, raf.getLocation(), null);
        }
    }
}

