/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressMonitor
extends JFrame {
    private Font labelFont;
    private JLabel phaseLabel;
    private DetailLabel detailLabel;
    private JCheckBox detailBox;

    public ProgressMonitor() {
        this(true);
    }

    public ProgressMonitor(boolean showDetails) {
        this(new Font("sansserif", 0, 12), showDetails);
    }

    public ProgressMonitor(Font labelFont) {
        this(labelFont, true);
    }

    public ProgressMonitor(Font labelFont, boolean showDetails) {
        super("Installation Progress Monitor");
        String w40 = "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW";
        String longStr = "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW";
        FontMetrics fm = this.getFontMetrics(labelFont);
        int width = fm.stringWidth("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
        int height = fm.getHeight();
        Dimension d = new Dimension(width, height);
        this.phaseLabel = new JLabel("Phase");
        this.phaseLabel.setFont(labelFont);
        this.phaseLabel.setMinimumSize(d);
        this.phaseLabel.setPreferredSize(d);
        this.phaseLabel.setMaximumSize(d);
        this.detailLabel = new DetailLabel("", showDetails);
        this.detailLabel.setFont(labelFont);
        this.detailLabel.setMinimumSize(d);
        this.detailLabel.setPreferredSize(d);
        this.detailLabel.setMaximumSize(d);
        this.detailBox = new JCheckBox("Show details", showDetails);
        this.detailBox.setFont(labelFont);
        this.detailBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ProgressMonitor.this.detailLabel.toggleShown();
                if (ProgressMonitor.this.detailLabel.isShown()) {
                    ProgressMonitor.this.pack();
                }
            }
        });
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add(Box.createHorizontalStrut(10));
        pane.add(this.phaseLabel);
        pane.add(Box.createHorizontalStrut(10));
        pane.add(this.detailLabel);
        pane.add(Box.createHorizontalStrut(10));
        pane.add(this.detailBox);
        pane.add(Box.createHorizontalStrut(10));
        this.setContentPane(pane);
        this.pack();
    }

    public final boolean isDetailShown() {
        return this.detailLabel.isShown();
    }

    public final void setDetail(String detail) {
        this.detailLabel.setText(detail);
    }

    public final void setPhase(String phase) {
        this.phaseLabel.setText(phase);
        this.detailLabel.setText("");
    }

    class DetailLabel
    extends JLabel {
        private String text;
        private boolean show;

        DetailLabel(String text, boolean show) {
            super(text);
            this.text = text;
            this.show = show;
        }

        final boolean isShown() {
            return this.show;
        }

        public final void setText(String text) {
            this.text = text;
            if (this.show) {
                super.setText(text);
            }
        }

        final void toggleShown() {
            boolean bl = this.show = !this.show;
            if (this.show) {
                super.setText(this.text);
            } else {
                super.setText("");
                this.invalidate();
            }
        }
    }
}

