{
    Getting list of DOS volumes and assigns
    Free Pascal for MorphOS example

    Copyright (C) 2005 by Karoly Balogh

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{ * 2005.01.10 * }

program getvolumes;

uses amigados;


{ * this function converts a BCPL-style string pointer to * }
{ * normal PChar type. * }
function BStr2PChar(bstr: DWord): PChar;
begin
  BStr2PChar:=Pointer((bstr shl 2)+1);
end;


procedure dosList(flags: DWord);
var
  dosList: PDosList;
begin
  { * fetch a list of volumes * }
  dosList:=LockDosList(flags or LDF_READ);
  { * parse the volumes * }
  repeat
    dosList:=NextDosEntry(dosList,flags);
    if dosList<>NIL then
      writeln(BStr2PChar(dosList^.dol_Name));
  until dosList=NIL;
  UnLockDosList(flags or LDF_READ);
end;


begin
  { * dos.library is opened by the RTL startup code, * }
  { * so we don't need to open it by ourselves. * }

  writeln('Current Volumes: ==========');
  dosList(LDF_VOLUMES);
  writeln('Current Assigns: ==========');
  dosList(LDF_ASSIGNS);
end.
