/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#ifndef _H_CONFIG_
#define _H_CONFIG_

#define SHARED_FILE ".mplayer/mplayer-af_export" /**< default file name, relative to ~/ */

#ifndef DEBUG
#define DEBUG 0
#endif

#include <SDL.h> 

/*
#define ARCH_X86 1
#define USE_MMX 1
#define MMX 1
#define HAVE_MMX2 1
#define HAVE_MMX1 1
#define HAVE_SSE2 1
#define HAVE_SSE 1
*/

#ifdef USE_MMX
#   define USE_FASTMEMCPY 1
#endif

#ifndef MAX_FRAMERATE
#   define MAX_FRAMERATE 24 /* But depends on audio rate, it's common to be between 12-20 frames */
#endif

#define INTERVAL (1000000/MAX_FRAMERATE)  /**< interval in seconds */

#ifndef DEF_FS
#   define DEF_FS     0   /* Default Full Screen Mode */
#endif

#ifndef DEF_RPLUGIN 
#   define DEF_RPLUGIN "libmpav_goom.so" /* Default render plugin */
#endif


#define COLOR2SDL( SDLCOLOR, RGB ) { SDLCOLOR.b = RGB & 0xff; SDLCOLOR.g = (RGB >> 8) & 0xff; SDLCOLOR.r = (RGB >> 16) & 0xff; } 

#endif // _H_CONFIG_
