static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1996 Federico Mena Quintero                                      \n"
" * Copyright 1997 Scott Goehring                                              \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2013 Carlos Zubieta <czubieta.dev@gmail.com>                     \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE stretch-contrast-hsv.c                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  gfloat slo;                                                                 \n"
"  gfloat sdiff;                                                               \n"
"  gfloat vlo;                                                                 \n"
"  gfloat vdiff;                                                               \n"
"} AutostretchData;                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"buffer_get_auto_strech_data (GeglBuffer      *buffer,                         \n"
"                             AutostretchData *data)                           \n"
"{                                                                             \n"
"  gfloat smin =  G_MAXFLOAT;                                                  \n"
"  gfloat smax = -G_MAXFLOAT;                                                  \n"
"  gfloat vmin =  G_MAXFLOAT;                                                  \n"
"  gfloat vmax = -G_MAXFLOAT;                                                  \n"
"                                                                              \n"
"  GeglBufferIterator *gi;                                                     \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (buffer, NULL, 0, babl_format (\"HSVA float\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gfloat *buf = gi->data[0];                                              \n"
"      gint    i;                                                              \n"
"                                                                              \n"
"      for (i = 0; i < gi->length; i++)                                        \n"
"        {                                                                     \n"
"          gfloat sval = buf[1];                                               \n"
"          gfloat vval = buf[2];                                               \n"
"                                                                              \n"
"          smin = MIN (sval, smin);                                            \n"
"          smax = MAX (sval, smax);                                            \n"
"          vmin = MIN (vval, vmin);                                            \n"
"          vmax = MAX (vval, vmax);                                            \n"
"                                                                              \n"
"          buf += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (data)                                                                   \n"
"    {                                                                         \n"
"      data->slo   = smin;                                                     \n"
"      data->sdiff = smax - smin;                                              \n"
"      data->vlo   = vmin;                                                     \n"
"      data->vdiff = vmax - vmin;                                              \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"clean_autostretch_data (AutostretchData *data)                                \n"
"{                                                                             \n"
"  if (data->sdiff < GEGL_FLOAT_EPSILON)                                       \n"
"    {                                                                         \n"
"      data->sdiff = 1.0;                                                      \n"
"      data->slo   = 0.0;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (data->vdiff < GEGL_FLOAT_EPSILON)                                       \n"
"    {                                                                         \n"
"      data->vdiff = 1.0;                                                      \n"
"      data->vlo   = 0.0;                                                      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"HSVA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"HSVA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  /* Don't request an infinite plane */                                       \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  AutostretchData     data;                                                   \n"
"  GeglBufferIterator *gi;                                                     \n"
"                                                                              \n"
"  buffer_get_auto_strech_data (input, &data);                                 \n"
"  clean_autostretch_data (&data);                                             \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (input, result, 0, babl_format (\"HSVA float\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (gi, output, result, 0, babl_format (\"HSVA float\"),\n"
"                            GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gfloat *in  = gi->data[0];                                              \n"
"      gfloat *out = gi->data[1];                                              \n"
"      gint    i;                                                              \n"
"                                                                              \n"
"      for (i = 0; i < gi->length; i++)                                        \n"
"        {                                                                     \n"
"          out[0] = in[0]; /* Keep hue */                                      \n"
"          out[1] = (in[1] - data.slo) / data.sdiff;                           \n"
"          out[2] = (in[2] - data.vlo) / data.vdiff;                           \n"
"          out[3] = in[3]; /* Keep alpha */                                    \n"
"                                                                              \n"
"          in  += 4;                                                           \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"/* Pass-through when trying to perform a reduction on an infinite plane       \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"                                                                              \n"
"  const GeglRectangle *in_rect =                                              \n"
"    gegl_operation_source_get_bounding_box (operation, \"input\");            \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  if (in_rect && gegl_rectangle_is_infinite_plane (in_rect))                  \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* chain up, which will create the needed buffers for our actual            \n"
"   * process function                                                         \n"
"   */                                                                         \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                   gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->process                 = operation_process;               \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:stretch-contrast-hsv\",                           \n"
"    \"title\",       _(\"Stretch Contrast HSV\"),                             \n"
"    \"categories\" , \"color:enhance\",                                       \n"
"    \"description\",                                                          \n"
"        _(\"Scales the components of the buffer to be in the 0.0-1.0 range. \"\n"
"          \"This improves images that make poor use of the available contrast \"\n"
"          \"(little contrast, very dark, or very bright images). \"           \n"
"          \"This version differs from Contrast Autostretch in that it works \"\n"
"          \"in HSV scpace, and preserves hue.\"),                             \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
