// Code generated by smithy-go-codegen DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpApplyArchiveRule struct {
}

func (*validateOpApplyArchiveRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpApplyArchiveRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ApplyArchiveRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpApplyArchiveRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelPolicyGeneration struct {
}

func (*validateOpCancelPolicyGeneration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelPolicyGeneration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelPolicyGenerationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelPolicyGenerationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCheckAccessNotGranted struct {
}

func (*validateOpCheckAccessNotGranted) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCheckAccessNotGranted) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CheckAccessNotGrantedInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCheckAccessNotGrantedInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCheckNoNewAccess struct {
}

func (*validateOpCheckNoNewAccess) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCheckNoNewAccess) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CheckNoNewAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCheckNoNewAccessInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAccessPreview struct {
}

func (*validateOpCreateAccessPreview) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAccessPreview) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAccessPreviewInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAccessPreviewInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAnalyzer struct {
}

func (*validateOpCreateAnalyzer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAnalyzer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAnalyzerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAnalyzerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateArchiveRule struct {
}

func (*validateOpCreateArchiveRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateArchiveRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateArchiveRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateArchiveRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAnalyzer struct {
}

func (*validateOpDeleteAnalyzer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAnalyzer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAnalyzerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAnalyzerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteArchiveRule struct {
}

func (*validateOpDeleteArchiveRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteArchiveRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteArchiveRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteArchiveRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAccessPreview struct {
}

func (*validateOpGetAccessPreview) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAccessPreview) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAccessPreviewInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAccessPreviewInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAnalyzedResource struct {
}

func (*validateOpGetAnalyzedResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAnalyzedResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAnalyzedResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAnalyzedResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAnalyzer struct {
}

func (*validateOpGetAnalyzer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAnalyzer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAnalyzerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAnalyzerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetArchiveRule struct {
}

func (*validateOpGetArchiveRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetArchiveRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetArchiveRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetArchiveRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetFinding struct {
}

func (*validateOpGetFinding) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetFinding) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetFindingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetFindingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetFindingV2 struct {
}

func (*validateOpGetFindingV2) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetFindingV2) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetFindingV2Input)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetFindingV2Input(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetGeneratedPolicy struct {
}

func (*validateOpGetGeneratedPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetGeneratedPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetGeneratedPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetGeneratedPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAccessPreviewFindings struct {
}

func (*validateOpListAccessPreviewFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAccessPreviewFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAccessPreviewFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAccessPreviewFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAccessPreviews struct {
}

func (*validateOpListAccessPreviews) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAccessPreviews) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAccessPreviewsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAccessPreviewsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAnalyzedResources struct {
}

func (*validateOpListAnalyzedResources) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAnalyzedResources) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAnalyzedResourcesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAnalyzedResourcesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListArchiveRules struct {
}

func (*validateOpListArchiveRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListArchiveRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListArchiveRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListArchiveRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindings struct {
}

func (*validateOpListFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindingsV2 struct {
}

func (*validateOpListFindingsV2) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindingsV2) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingsV2Input)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingsV2Input(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartPolicyGeneration struct {
}

func (*validateOpStartPolicyGeneration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartPolicyGeneration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartPolicyGenerationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartPolicyGenerationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartResourceScan struct {
}

func (*validateOpStartResourceScan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartResourceScan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartResourceScanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartResourceScanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateArchiveRule struct {
}

func (*validateOpUpdateArchiveRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateArchiveRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateArchiveRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateArchiveRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFindings struct {
}

func (*validateOpUpdateFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpValidatePolicy struct {
}

func (*validateOpValidatePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpValidatePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ValidatePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpValidatePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpApplyArchiveRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpApplyArchiveRule{}, middleware.After)
}

func addOpCancelPolicyGenerationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelPolicyGeneration{}, middleware.After)
}

func addOpCheckAccessNotGrantedValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCheckAccessNotGranted{}, middleware.After)
}

func addOpCheckNoNewAccessValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCheckNoNewAccess{}, middleware.After)
}

func addOpCreateAccessPreviewValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAccessPreview{}, middleware.After)
}

func addOpCreateAnalyzerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAnalyzer{}, middleware.After)
}

func addOpCreateArchiveRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateArchiveRule{}, middleware.After)
}

func addOpDeleteAnalyzerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAnalyzer{}, middleware.After)
}

func addOpDeleteArchiveRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteArchiveRule{}, middleware.After)
}

func addOpGetAccessPreviewValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAccessPreview{}, middleware.After)
}

func addOpGetAnalyzedResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAnalyzedResource{}, middleware.After)
}

func addOpGetAnalyzerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAnalyzer{}, middleware.After)
}

func addOpGetArchiveRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetArchiveRule{}, middleware.After)
}

func addOpGetFindingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetFinding{}, middleware.After)
}

func addOpGetFindingV2ValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetFindingV2{}, middleware.After)
}

func addOpGetGeneratedPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetGeneratedPolicy{}, middleware.After)
}

func addOpListAccessPreviewFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAccessPreviewFindings{}, middleware.After)
}

func addOpListAccessPreviewsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAccessPreviews{}, middleware.After)
}

func addOpListAnalyzedResourcesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAnalyzedResources{}, middleware.After)
}

func addOpListArchiveRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListArchiveRules{}, middleware.After)
}

func addOpListFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindings{}, middleware.After)
}

func addOpListFindingsV2ValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindingsV2{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartPolicyGenerationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartPolicyGeneration{}, middleware.After)
}

func addOpStartResourceScanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartResourceScan{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateArchiveRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateArchiveRule{}, middleware.After)
}

func addOpUpdateFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFindings{}, middleware.After)
}

func addOpValidatePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpValidatePolicy{}, middleware.After)
}

func validateAccess(v *types.Access) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Access"}
	if v.Actions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Actions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAccessList(v []types.Access) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccessList"}
	for i := range v {
		if err := validateAccess(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudTrailDetails(v *types.CloudTrailDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudTrailDetails"}
	if v.Trails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Trails"))
	} else if v.Trails != nil {
		if err := validateTrailList(v.Trails); err != nil {
			invalidParams.AddNested("Trails", err.(smithy.InvalidParamsError))
		}
	}
	if v.AccessRole == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccessRole"))
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfiguration(v types.Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Configuration"}
	switch uv := v.(type) {
	case *types.ConfigurationMemberKmsKey:
		if err := validateKmsKeyConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[kmsKey]", err.(smithy.InvalidParamsError))
		}

	case *types.ConfigurationMemberS3Bucket:
		if err := validateS3BucketConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[s3Bucket]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfigurationsMap(v map[string]types.Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConfigurationsMap"}
	for key := range v {
		if err := validateConfiguration(v[key]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInlineArchiveRule(v *types.InlineArchiveRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InlineArchiveRule"}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if v.Filter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInlineArchiveRulesList(v []types.InlineArchiveRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InlineArchiveRulesList"}
	for i := range v {
		if err := validateInlineArchiveRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKmsGrantConfiguration(v *types.KmsGrantConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KmsGrantConfiguration"}
	if v.Operations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Operations"))
	}
	if v.GranteePrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GranteePrincipal"))
	}
	if v.IssuingAccount == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IssuingAccount"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKmsGrantConfigurationsList(v []types.KmsGrantConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KmsGrantConfigurationsList"}
	for i := range v {
		if err := validateKmsGrantConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKmsKeyConfiguration(v *types.KmsKeyConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KmsKeyConfiguration"}
	if v.Grants != nil {
		if err := validateKmsGrantConfigurationsList(v.Grants); err != nil {
			invalidParams.AddNested("Grants", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNetworkOriginConfiguration(v types.NetworkOriginConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NetworkOriginConfiguration"}
	switch uv := v.(type) {
	case *types.NetworkOriginConfigurationMemberVpcConfiguration:
		if err := validateVpcConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[vpcConfiguration]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePolicyGenerationDetails(v *types.PolicyGenerationDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PolicyGenerationDetails"}
	if v.PrincipalArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrincipalArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3AccessPointConfiguration(v *types.S3AccessPointConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3AccessPointConfiguration"}
	if v.PublicAccessBlock != nil {
		if err := validateS3PublicAccessBlockConfiguration(v.PublicAccessBlock); err != nil {
			invalidParams.AddNested("PublicAccessBlock", err.(smithy.InvalidParamsError))
		}
	}
	if v.NetworkOrigin != nil {
		if err := validateNetworkOriginConfiguration(v.NetworkOrigin); err != nil {
			invalidParams.AddNested("NetworkOrigin", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3AccessPointConfigurationsMap(v map[string]types.S3AccessPointConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3AccessPointConfigurationsMap"}
	for key := range v {
		value := v[key]
		if err := validateS3AccessPointConfiguration(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3BucketAclGrantConfiguration(v *types.S3BucketAclGrantConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3BucketAclGrantConfiguration"}
	if len(v.Permission) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Permission"))
	}
	if v.Grantee == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Grantee"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3BucketAclGrantConfigurationsList(v []types.S3BucketAclGrantConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3BucketAclGrantConfigurationsList"}
	for i := range v {
		if err := validateS3BucketAclGrantConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3BucketConfiguration(v *types.S3BucketConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3BucketConfiguration"}
	if v.BucketAclGrants != nil {
		if err := validateS3BucketAclGrantConfigurationsList(v.BucketAclGrants); err != nil {
			invalidParams.AddNested("BucketAclGrants", err.(smithy.InvalidParamsError))
		}
	}
	if v.BucketPublicAccessBlock != nil {
		if err := validateS3PublicAccessBlockConfiguration(v.BucketPublicAccessBlock); err != nil {
			invalidParams.AddNested("BucketPublicAccessBlock", err.(smithy.InvalidParamsError))
		}
	}
	if v.AccessPoints != nil {
		if err := validateS3AccessPointConfigurationsMap(v.AccessPoints); err != nil {
			invalidParams.AddNested("AccessPoints", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3PublicAccessBlockConfiguration(v *types.S3PublicAccessBlockConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3PublicAccessBlockConfiguration"}
	if v.IgnorePublicAcls == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IgnorePublicAcls"))
	}
	if v.RestrictPublicBuckets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RestrictPublicBuckets"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTrail(v *types.Trail) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Trail"}
	if v.CloudTrailArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudTrailArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTrailList(v []types.Trail) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TrailList"}
	for i := range v {
		if err := validateTrail(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVpcConfiguration(v *types.VpcConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VpcConfiguration"}
	if v.VpcId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpApplyArchiveRuleInput(v *ApplyArchiveRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApplyArchiveRuleInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelPolicyGenerationInput(v *CancelPolicyGenerationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelPolicyGenerationInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCheckAccessNotGrantedInput(v *CheckAccessNotGrantedInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CheckAccessNotGrantedInput"}
	if v.PolicyDocument == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyDocument"))
	}
	if v.Access == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Access"))
	} else if v.Access != nil {
		if err := validateAccessList(v.Access); err != nil {
			invalidParams.AddNested("Access", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCheckNoNewAccessInput(v *CheckNoNewAccessInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CheckNoNewAccessInput"}
	if v.NewPolicyDocument == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NewPolicyDocument"))
	}
	if v.ExistingPolicyDocument == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExistingPolicyDocument"))
	}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAccessPreviewInput(v *CreateAccessPreviewInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAccessPreviewInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if v.Configurations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Configurations"))
	} else if v.Configurations != nil {
		if err := validateConfigurationsMap(v.Configurations); err != nil {
			invalidParams.AddNested("Configurations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAnalyzerInput(v *CreateAnalyzerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAnalyzerInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.ArchiveRules != nil {
		if err := validateInlineArchiveRulesList(v.ArchiveRules); err != nil {
			invalidParams.AddNested("ArchiveRules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateArchiveRuleInput(v *CreateArchiveRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateArchiveRuleInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if v.Filter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAnalyzerInput(v *DeleteAnalyzerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAnalyzerInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteArchiveRuleInput(v *DeleteArchiveRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteArchiveRuleInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAccessPreviewInput(v *GetAccessPreviewInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAccessPreviewInput"}
	if v.AccessPreviewId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccessPreviewId"))
	}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAnalyzedResourceInput(v *GetAnalyzedResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAnalyzedResourceInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAnalyzerInput(v *GetAnalyzerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAnalyzerInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetArchiveRuleInput(v *GetArchiveRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetArchiveRuleInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetFindingInput(v *GetFindingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetFindingInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetFindingV2Input(v *GetFindingV2Input) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetFindingV2Input"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetGeneratedPolicyInput(v *GetGeneratedPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetGeneratedPolicyInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAccessPreviewFindingsInput(v *ListAccessPreviewFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAccessPreviewFindingsInput"}
	if v.AccessPreviewId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccessPreviewId"))
	}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAccessPreviewsInput(v *ListAccessPreviewsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAccessPreviewsInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAnalyzedResourcesInput(v *ListAnalyzedResourcesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAnalyzedResourcesInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListArchiveRulesInput(v *ListArchiveRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListArchiveRulesInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingsInput(v *ListFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingsInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingsV2Input(v *ListFindingsV2Input) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingsV2Input"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartPolicyGenerationInput(v *StartPolicyGenerationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartPolicyGenerationInput"}
	if v.PolicyGenerationDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyGenerationDetails"))
	} else if v.PolicyGenerationDetails != nil {
		if err := validatePolicyGenerationDetails(v.PolicyGenerationDetails); err != nil {
			invalidParams.AddNested("PolicyGenerationDetails", err.(smithy.InvalidParamsError))
		}
	}
	if v.CloudTrailDetails != nil {
		if err := validateCloudTrailDetails(v.CloudTrailDetails); err != nil {
			invalidParams.AddNested("CloudTrailDetails", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartResourceScanInput(v *StartResourceScanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartResourceScanInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateArchiveRuleInput(v *UpdateArchiveRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateArchiveRuleInput"}
	if v.AnalyzerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerName"))
	}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if v.Filter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFindingsInput(v *UpdateFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFindingsInput"}
	if v.AnalyzerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalyzerArn"))
	}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpValidatePolicyInput(v *ValidatePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ValidatePolicyInput"}
	if v.PolicyDocument == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyDocument"))
	}
	if len(v.PolicyType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
