// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit
// schedule consists of one or more bandwidth rate limit intervals. A bandwidth
// rate limit interval defines a period of time on one or more days of the week,
// during which bandwidth rate limits are specified for uploading, downloading, or
// both.
type BandwidthRateLimitInterval struct {

	// The days of the week component of the bandwidth rate limit interval,
	// represented as ordinal numbers from 0 to 6, where 0 represents Sunday and 6
	// represents Saturday.
	//
	// This member is required.
	DaysOfWeek []int32

	// The hour of the day to end the bandwidth rate limit interval.
	//
	// This member is required.
	EndHourOfDay *int32

	// The minute of the hour to end the bandwidth rate limit interval. The bandwidth
	// rate limit interval ends at the end of the minute. To end an interval at the end
	// of an hour, use the value 59 .
	//
	// This member is required.
	EndMinuteOfHour *int32

	// The hour of the day to start the bandwidth rate limit interval.
	//
	// This member is required.
	StartHourOfDay *int32

	// The minute of the hour to start the bandwidth rate limit interval. The interval
	// begins at the start of that minute. To begin an interval exactly at the start of
	// the hour, use the value 0 .
	//
	// This member is required.
	StartMinuteOfHour *int32

	// The average upload rate limit component of the bandwidth rate limit interval,
	// in bits per second. This field does not appear in the response if the upload
	// rate limit is not set. For Backup Gateway, the minimum value is (Value) .
	AverageUploadRateLimitInBitsPerSec *int64

	noSmithyDocumentSerde
}

// A gateway is an Backup Gateway appliance that runs on the customer's network to
// provide seamless connectivity to backup storage in the Amazon Web Services
// Cloud.
type Gateway struct {

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and Amazon Web Services Region.
	GatewayArn *string

	// The display name of the gateway.
	GatewayDisplayName *string

	// The type of the gateway.
	GatewayType GatewayType

	// The hypervisor ID of the gateway.
	HypervisorId *string

	// The last time Backup gateway communicated with the gateway, in Unix format and
	// UTC time.
	LastSeenTime *time.Time

	noSmithyDocumentSerde
}

// The details of gateway.
type GatewayDetails struct {

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and Amazon Web Services Region.
	GatewayArn *string

	// The display name of the gateway.
	GatewayDisplayName *string

	// The type of the gateway type.
	GatewayType GatewayType

	// The hypervisor ID of the gateway.
	HypervisorId *string

	// Details showing the last time Backup gateway communicated with the cloud, in
	// Unix format and UTC time.
	LastSeenTime *time.Time

	// Returns your gateway's weekly maintenance start time including the day and time
	// of the week. Note that values are in terms of the gateway's time zone. Can be
	// weekly or monthly.
	MaintenanceStartTime *MaintenanceStartTime

	// Details showing the next update availability time of the gateway.
	NextUpdateAvailabilityTime *time.Time

	// The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to
	// connect to the cloud for backup gateway.
	VpcEndpoint *string

	noSmithyDocumentSerde
}

// Represents the hypervisor's permissions to which the gateway will connect. A
// hypervisor is hardware, software, or firmware that creates and manages virtual
// machines, and allocates resources to them.
type Hypervisor struct {

	// The server host of the hypervisor. This can be either an IP address or a
	// fully-qualified domain name (FQDN).
	Host *string

	// The Amazon Resource Name (ARN) of the hypervisor.
	HypervisorArn *string

	// The Amazon Resource Name (ARN) of the Key Management Service used to encrypt
	// the hypervisor.
	KmsKeyArn *string

	// The name of the hypervisor.
	Name *string

	// The state of the hypervisor.
	State HypervisorState

	noSmithyDocumentSerde
}

// These are the details of the specified hypervisor. A hypervisor is hardware,
// software, or firmware that creates and manages virtual machines, and allocates
// resources to them.
type HypervisorDetails struct {

	// The server host of the hypervisor. This can be either an IP address or a
	// fully-qualified domain name (FQDN).
	Host *string

	// The Amazon Resource Name (ARN) of the hypervisor.
	HypervisorArn *string

	// The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
	KmsKeyArn *string

	// This is the time when the most recent successful sync of metadata occurred.
	LastSuccessfulMetadataSyncTime *time.Time

	// This is the most recent status for the indicated metadata sync.
	LatestMetadataSyncStatus SyncMetadataStatus

	// This is the most recent status for the indicated metadata sync.
	LatestMetadataSyncStatusMessage *string

	// The Amazon Resource Name (ARN) of the group of gateways within the requested
	// log.
	LogGroupArn *string

	// This is the name of the specified hypervisor.
	Name *string

	// This is the current state of the specified hypervisor. The possible states are
	// PENDING , ONLINE , OFFLINE , or ERROR .
	State HypervisorState

	noSmithyDocumentSerde
}

// This is your gateway's weekly maintenance start time including the day and time
// of the week. Note that values are in terms of the gateway's time zone. Can be
// weekly or monthly.
type MaintenanceStartTime struct {

	// The hour component of the maintenance start time represented as hh, where hh is
	// the hour (0 to 23). The hour of the day is in the time zone of the gateway.
	//
	// This member is required.
	HourOfDay *int32

	// The minute component of the maintenance start time represented as mm, where mm
	// is the minute (0 to 59). The minute of the hour is in the time zone of the
	// gateway.
	//
	// This member is required.
	MinuteOfHour *int32

	// The day of the month component of the maintenance start time represented as an
	// ordinal number from 1 to 28, where 1 represents the first day of the month and
	// 28 represents the last day of the month.
	DayOfMonth *int32

	// An ordinal number between 0 and 6 that represents the day of the week, where 0
	// represents Sunday and 6 represents Saturday. The day of week is in the time zone
	// of the gateway.
	DayOfWeek *int32

	noSmithyDocumentSerde
}

// A key-value pair you can use to manage, filter, and search for your resources.
// Allowed characters include UTF-8 letters, numbers, spaces, and the following
// characters: + - = . _ : /.
type Tag struct {

	// The key part of a tag's key-value pair. The key can't start with aws: .
	//
	// This member is required.
	Key *string

	// The value part of a tag's key-value pair.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A virtual machine that is on a hypervisor.
type VirtualMachine struct {

	// The host name of the virtual machine.
	HostName *string

	// The ID of the virtual machine's hypervisor.
	HypervisorId *string

	// The most recent date a virtual machine was backed up, in Unix format and UTC
	// time.
	LastBackupDate *time.Time

	// The name of the virtual machine.
	Name *string

	// The path of the virtual machine.
	Path *string

	// The Amazon Resource Name (ARN) of the virtual machine. For example,
	// arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL .
	ResourceArn *string

	noSmithyDocumentSerde
}

// Your VirtualMachine objects, ordered by their Amazon Resource Names (ARNs).
type VirtualMachineDetails struct {

	// The host name of the virtual machine.
	HostName *string

	// The ID of the virtual machine's hypervisor.
	HypervisorId *string

	// The most recent date a virtual machine was backed up, in Unix format and UTC
	// time.
	LastBackupDate *time.Time

	// The name of the virtual machine.
	Name *string

	// The path of the virtual machine.
	Path *string

	// The Amazon Resource Name (ARN) of the virtual machine. For example,
	// arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL .
	ResourceArn *string

	// These are the details of the VMware tags associated with the specified virtual
	// machine.
	VmwareTags []VmwareTag

	noSmithyDocumentSerde
}

// A VMware tag is a tag attached to a specific virtual machine. A tag (https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_Tag.html)
// is a key-value pair you can use to manage, filter, and search for your
// resources. The content of VMware tags can be matched to Amazon Web Services
// tags.
type VmwareTag struct {

	// The is the category of VMware.
	VmwareCategory *string

	// This is a user-defined description of a VMware tag.
	VmwareTagDescription *string

	// This is the user-defined name of a VMware tag.
	VmwareTagName *string

	noSmithyDocumentSerde
}

// This displays the mapping of on-premises VMware tags to the corresponding
// Amazon Web Services tags.
type VmwareToAwsTagMapping struct {

	// The key part of the Amazon Web Services tag's key-value pair.
	//
	// This member is required.
	AwsTagKey *string

	// The value part of the Amazon Web Services tag's key-value pair.
	//
	// This member is required.
	AwsTagValue *string

	// The is the category of VMware.
	//
	// This member is required.
	VmwareCategory *string

	// This is the user-defined name of a VMware tag.
	//
	// This member is required.
	VmwareTagName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
