// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Type of Executors for an Action Group
//
// The following types satisfy this interface:
//
//	ActionGroupExecutorMemberLambda
type ActionGroupExecutor interface {
	isActionGroupExecutor()
}

// ARN of a Lambda.
type ActionGroupExecutorMemberLambda struct {
	Value string

	noSmithyDocumentSerde
}

func (*ActionGroupExecutorMemberLambda) isActionGroupExecutor() {}

// ActionGroup Summary
type ActionGroupSummary struct {

	// Identifier for a resource.
	//
	// This member is required.
	ActionGroupId *string

	// Name for a resource.
	//
	// This member is required.
	ActionGroupName *string

	// State of the action group
	//
	// This member is required.
	ActionGroupState ActionGroupState

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	noSmithyDocumentSerde
}

// Contains the information of an agent
type Agent struct {

	// Arn representation of the Agent.
	//
	// This member is required.
	AgentArn *string

	// Identifier for a resource.
	//
	// This member is required.
	AgentId *string

	// Name for a resource.
	//
	// This member is required.
	AgentName *string

	// ARN of a IAM role.
	//
	// This member is required.
	AgentResourceRoleArn *string

	// Schema Type for Action APIs.
	//
	// This member is required.
	AgentStatus AgentStatus

	// Draft Agent Version.
	//
	// This member is required.
	AgentVersion *string

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Max Session Time.
	//
	// This member is required.
	IdleSessionTTLInSeconds *int32

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Client specified token used for idempotency checks
	ClientToken *string

	// A KMS key ARN
	CustomerEncryptionKeyArn *string

	// Description of the Resource.
	Description *string

	// Failure Reasons for Error.
	FailureReasons []string

	// ARN or name of a Bedrock model.
	FoundationModel *string

	// Instruction for the agent.
	Instruction *string

	// Time Stamp.
	PreparedAt *time.Time

	// Configuration for prompt override.
	PromptOverrideConfiguration *PromptOverrideConfiguration

	// The recommended actions users can take to resolve an error in failureReasons.
	RecommendedActions []string

	noSmithyDocumentSerde
}

// Contains the information of an Agent Action Group
type AgentActionGroup struct {

	// Identifier for a resource.
	//
	// This member is required.
	ActionGroupId *string

	// Name for a resource.
	//
	// This member is required.
	ActionGroupName *string

	// State of the action group
	//
	// This member is required.
	ActionGroupState ActionGroupState

	// Identifier for a resource.
	//
	// This member is required.
	AgentId *string

	// Agent Version.
	//
	// This member is required.
	AgentVersion *string

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Type of Executors for an Action Group
	ActionGroupExecutor ActionGroupExecutor

	// Contains information about the API Schema for the Action Group
	ApiSchema APISchema

	// Client specified token used for idempotency checks
	ClientToken *string

	// Description of the Resource.
	Description *string

	// Action Group Signature for a BuiltIn Action
	ParentActionSignature ActionGroupSignature

	noSmithyDocumentSerde
}

// Contains the information of an agent alias
type AgentAlias struct {

	// Arn representation of the Agent Alias.
	//
	// This member is required.
	AgentAliasArn *string

	// Id for an Agent Alias generated at the server side.
	//
	// This member is required.
	AgentAliasId *string

	// Name for a resource.
	//
	// This member is required.
	AgentAliasName *string

	// The statuses an Agent Alias can be in.
	//
	// This member is required.
	AgentAliasStatus AgentAliasStatus

	// Identifier for a resource.
	//
	// This member is required.
	AgentId *string

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Routing configuration for an Agent alias.
	//
	// This member is required.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The list of history events for an alias for an Agent.
	AgentAliasHistoryEvents []AgentAliasHistoryEvent

	// Client specified token used for idempotency checks
	ClientToken *string

	// Description of the Resource.
	Description *string

	noSmithyDocumentSerde
}

// History event for an alias for an Agent.
type AgentAliasHistoryEvent struct {

	// Time Stamp.
	EndDate *time.Time

	// Routing configuration for an Agent alias.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	// Time Stamp.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// Details about the routing configuration for an Agent alias.
type AgentAliasRoutingConfigurationListItem struct {

	// Agent Version.
	//
	// This member is required.
	AgentVersion *string

	noSmithyDocumentSerde
}

// Summary of an alias for an Agent.
type AgentAliasSummary struct {

	// Id for an Agent Alias generated at the server side.
	//
	// This member is required.
	AgentAliasId *string

	// Name for a resource.
	//
	// This member is required.
	AgentAliasName *string

	// The statuses an Agent Alias can be in.
	//
	// This member is required.
	AgentAliasStatus AgentAliasStatus

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	// Routing configuration for an Agent alias.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	noSmithyDocumentSerde
}

// Contains the information of an Agent Knowledge Base.
type AgentKnowledgeBase struct {

	// Identifier for a resource.
	//
	// This member is required.
	AgentId *string

	// Agent Version.
	//
	// This member is required.
	AgentVersion *string

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Description of the Resource.
	//
	// This member is required.
	Description *string

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// State of the knowledge base; whether it is enabled or disabled
	//
	// This member is required.
	KnowledgeBaseState KnowledgeBaseState

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Agent Knowledge Base Summary
type AgentKnowledgeBaseSummary struct {

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// State of the knowledge base; whether it is enabled or disabled
	//
	// This member is required.
	KnowledgeBaseState KnowledgeBaseState

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	noSmithyDocumentSerde
}

// Summary of Agent.
type AgentSummary struct {

	// Identifier for a resource.
	//
	// This member is required.
	AgentId *string

	// Name for a resource.
	//
	// This member is required.
	AgentName *string

	// Schema Type for Action APIs.
	//
	// This member is required.
	AgentStatus AgentStatus

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	// Agent Version.
	LatestAgentVersion *string

	noSmithyDocumentSerde
}

// Contains the information of an agent version.
type AgentVersion struct {

	// Arn representation of the Agent.
	//
	// This member is required.
	AgentArn *string

	// Identifier for a resource.
	//
	// This member is required.
	AgentId *string

	// Name for a resource.
	//
	// This member is required.
	AgentName *string

	// ARN of a IAM role.
	//
	// This member is required.
	AgentResourceRoleArn *string

	// Schema Type for Action APIs.
	//
	// This member is required.
	AgentStatus AgentStatus

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Max Session Time.
	//
	// This member is required.
	IdleSessionTTLInSeconds *int32

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Numerical Agent Version.
	//
	// This member is required.
	Version *string

	// A KMS key ARN
	CustomerEncryptionKeyArn *string

	// Description of the Resource.
	Description *string

	// Failure Reasons for Error.
	FailureReasons []string

	// ARN or name of a Bedrock model.
	FoundationModel *string

	// Instruction for the agent.
	Instruction *string

	// Configuration for prompt override.
	PromptOverrideConfiguration *PromptOverrideConfiguration

	// The recommended actions users can take to resolve an error in failureReasons.
	RecommendedActions []string

	noSmithyDocumentSerde
}

// Summary of agent version.
type AgentVersionSummary struct {

	// Name for a resource.
	//
	// This member is required.
	AgentName *string

	// Schema Type for Action APIs.
	//
	// This member is required.
	AgentStatus AgentStatus

	// Agent Version.
	//
	// This member is required.
	AgentVersion *string

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about the API Schema for the Action Group
//
// The following types satisfy this interface:
//
//	APISchemaMemberPayload
//	APISchemaMemberS3
type APISchema interface {
	isAPISchema()
}

// String OpenAPI Payload
type APISchemaMemberPayload struct {
	Value string

	noSmithyDocumentSerde
}

func (*APISchemaMemberPayload) isAPISchema() {}

// The identifier for the S3 resource.
type APISchemaMemberS3 struct {
	Value S3Identifier

	noSmithyDocumentSerde
}

func (*APISchemaMemberS3) isAPISchema() {}

// Configures chunking strategy
type ChunkingConfiguration struct {

	// The type of chunking strategy
	//
	// This member is required.
	ChunkingStrategy ChunkingStrategy

	// Configures fixed size chunking strategy
	FixedSizeChunkingConfiguration *FixedSizeChunkingConfiguration

	noSmithyDocumentSerde
}

// Contains the information of a data source.
type DataSource struct {

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// Specifies a raw data source location to ingest.
	//
	// This member is required.
	DataSourceConfiguration *DataSourceConfiguration

	// Identifier for a resource.
	//
	// This member is required.
	DataSourceId *string

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Name for a resource.
	//
	// This member is required.
	Name *string

	// The status of a data source.
	//
	// This member is required.
	Status DataSourceStatus

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	// Server-side encryption configuration.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration

	// Configures ingestion for a vector knowledge base
	VectorIngestionConfiguration *VectorIngestionConfiguration

	noSmithyDocumentSerde
}

// Specifies a raw data source location to ingest.
type DataSourceConfiguration struct {

	// The type of the data source location.
	//
	// This member is required.
	Type DataSourceType

	// Configures an S3 data source location.
	S3Configuration *S3DataSourceConfiguration

	noSmithyDocumentSerde
}

// Summary information of a data source.
type DataSourceSummary struct {

	// Identifier for a resource.
	//
	// This member is required.
	DataSourceId *string

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Name for a resource.
	//
	// This member is required.
	Name *string

	// The status of a data source.
	//
	// This member is required.
	Status DataSourceStatus

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	noSmithyDocumentSerde
}

// Configures fixed size chunking strategy
type FixedSizeChunkingConfiguration struct {

	// The maximum number of tokens per chunk.
	//
	// This member is required.
	MaxTokens *int32

	// The overlap percentage between adjacent chunks.
	//
	// This member is required.
	OverlapPercentage *int32

	noSmithyDocumentSerde
}

// Configuration for inference in prompt configuration
type InferenceConfiguration struct {

	// Maximum length of output
	MaximumLength *int32

	// List of stop sequences
	StopSequences []string

	// Controls randomness, higher values increase diversity
	Temperature *float32

	// Sample from the k most likely next tokens
	TopK *int32

	// Cumulative probability cutoff for token selection
	TopP *float32

	noSmithyDocumentSerde
}

// Contains the information of an ingestion job.
type IngestionJob struct {

	// Identifier for a resource.
	//
	// This member is required.
	DataSourceId *string

	// Identifier for a resource.
	//
	// This member is required.
	IngestionJobId *string

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Time Stamp.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of an ingestion job.
	//
	// This member is required.
	Status IngestionJobStatus

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	// Failure Reasons for Error.
	FailureReasons []string

	// The document level statistics of an ingestion job
	Statistics *IngestionJobStatistics

	noSmithyDocumentSerde
}

// Filters the response returned by ListIngestionJobs operation.
type IngestionJobFilter struct {

	// The name of the field to filter ingestion jobs.
	//
	// This member is required.
	Attribute IngestionJobFilterAttribute

	// The operator used to filter ingestion jobs.
	//
	// This member is required.
	Operator IngestionJobFilterOperator

	// The list of values used to filter ingestion jobs.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Sorts the response returned by ListIngestionJobs operation.
type IngestionJobSortBy struct {

	// The name of the field to sort ingestion jobs.
	//
	// This member is required.
	Attribute IngestionJobSortByAttribute

	// Order to sort results by.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// The document level statistics of an ingestion job
type IngestionJobStatistics struct {

	// Number of deleted documents
	NumberOfDocumentsDeleted int64

	// Number of failed documents
	NumberOfDocumentsFailed int64

	// Number of scanned documents
	NumberOfDocumentsScanned int64

	// Number of modified documents indexed
	NumberOfModifiedDocumentsIndexed int64

	// Number of indexed documents
	NumberOfNewDocumentsIndexed int64

	noSmithyDocumentSerde
}

// Summary information of an ingestion job.
type IngestionJobSummary struct {

	// Identifier for a resource.
	//
	// This member is required.
	DataSourceId *string

	// Identifier for a resource.
	//
	// This member is required.
	IngestionJobId *string

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Time Stamp.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of an ingestion job.
	//
	// This member is required.
	Status IngestionJobStatus

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	// The document level statistics of an ingestion job
	Statistics *IngestionJobStatistics

	noSmithyDocumentSerde
}

// Contains the information of a knowledge base.
type KnowledgeBase struct {

	// Time Stamp.
	//
	// This member is required.
	CreatedAt *time.Time

	// ARN of a KnowledgeBase
	//
	// This member is required.
	KnowledgeBaseArn *string

	// Configures a bedrock knowledge base.
	//
	// This member is required.
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Name for a resource.
	//
	// This member is required.
	Name *string

	// ARN of a IAM role.
	//
	// This member is required.
	RoleArn *string

	// The status of a knowledge base.
	//
	// This member is required.
	Status KnowledgeBaseStatus

	// Configures the physical storage of ingested data in a knowledge base.
	//
	// This member is required.
	StorageConfiguration *StorageConfiguration

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	// Failure Reasons for Error.
	FailureReasons []string

	noSmithyDocumentSerde
}

// Configures a bedrock knowledge base.
type KnowledgeBaseConfiguration struct {

	// The type of a knowledge base.
	//
	// This member is required.
	Type KnowledgeBaseType

	// Configurations for a vector knowledge base.
	VectorKnowledgeBaseConfiguration *VectorKnowledgeBaseConfiguration

	noSmithyDocumentSerde
}

// Summary information of a knowledge base.
type KnowledgeBaseSummary struct {

	// Identifier for a resource.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Name for a resource.
	//
	// This member is required.
	Name *string

	// The status of a knowledge base.
	//
	// This member is required.
	Status KnowledgeBaseStatus

	// Time Stamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Description of the Resource.
	Description *string

	noSmithyDocumentSerde
}

// Contains the configurations to use OpenSearch Serverless to store knowledge
// base data.
type OpenSearchServerlessConfiguration struct {

	// Arn of an OpenSearch Serverless collection.
	//
	// This member is required.
	CollectionArn *string

	// A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
	//
	// This member is required.
	FieldMapping *OpenSearchServerlessFieldMapping

	// Arn of an OpenSearch Serverless index.
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
type OpenSearchServerlessFieldMapping struct {

	// Name of the field
	//
	// This member is required.
	MetadataField *string

	// Name of the field
	//
	// This member is required.
	TextField *string

	// Name of the field
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains the configurations to use Pinecone to store knowledge base data.
type PineconeConfiguration struct {

	// Pinecone connection string
	//
	// This member is required.
	ConnectionString *string

	// Arn of a SecretsManager Secret.
	//
	// This member is required.
	CredentialsSecretArn *string

	// A mapping of Bedrock Knowledge Base fields to Pinecone field names
	//
	// This member is required.
	FieldMapping *PineconeFieldMapping

	// Pinecone namespace
	Namespace *string

	noSmithyDocumentSerde
}

// A mapping of Bedrock Knowledge Base fields to Pinecone field names
type PineconeFieldMapping struct {

	// Name of the field
	//
	// This member is required.
	MetadataField *string

	// Name of the field
	//
	// This member is required.
	TextField *string

	noSmithyDocumentSerde
}

// BasePromptConfiguration per Prompt Type.
type PromptConfiguration struct {

	// Base Prompt Template.
	BasePromptTemplate *string

	// Configuration for inference in prompt configuration
	InferenceConfiguration *InferenceConfiguration

	// Creation Mode for Prompt Configuration.
	ParserMode CreationMode

	// Creation Mode for Prompt Configuration.
	PromptCreationMode CreationMode

	// Prompt State.
	PromptState PromptState

	// Prompt Type.
	PromptType PromptType

	noSmithyDocumentSerde
}

// Configuration for prompt override.
type PromptOverrideConfiguration struct {

	// List of BasePromptConfiguration
	//
	// This member is required.
	PromptConfigurations []PromptConfiguration

	// ARN of a Lambda.
	OverrideLambda *string

	noSmithyDocumentSerde
}

// Contains the configurations to use RDS to store knowledge base data.
type RdsConfiguration struct {

	// Arn of a SecretsManager Secret.
	//
	// This member is required.
	CredentialsSecretArn *string

	// Name of the database within RDS
	//
	// This member is required.
	DatabaseName *string

	// A mapping of Bedrock Knowledge Base fields to RDS column names
	//
	// This member is required.
	FieldMapping *RdsFieldMapping

	// Arn of a RDS Resource.
	//
	// This member is required.
	ResourceArn *string

	// Name of the table within RDS
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// A mapping of Bedrock Knowledge Base fields to RDS column names
type RdsFieldMapping struct {

	// Name of the column
	//
	// This member is required.
	MetadataField *string

	// Name of the column
	//
	// This member is required.
	PrimaryKeyField *string

	// Name of the column
	//
	// This member is required.
	TextField *string

	// Name of the column
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains the configurations to use Redis Enterprise Cloud to store knowledge
// base data.
type RedisEnterpriseCloudConfiguration struct {

	// Arn of a SecretsManager Secret.
	//
	// This member is required.
	CredentialsSecretArn *string

	// Redis enterprise cloud endpoint
	//
	// This member is required.
	Endpoint *string

	// A mapping of Bedrock Knowledge Base fields to Redis Cloud field names
	//
	// This member is required.
	FieldMapping *RedisEnterpriseCloudFieldMapping

	// Name of a redis enterprise cloud index
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// A mapping of Bedrock Knowledge Base fields to Redis Cloud field names
type RedisEnterpriseCloudFieldMapping struct {

	// Name of the field
	//
	// This member is required.
	MetadataField *string

	// Name of the field
	//
	// This member is required.
	TextField *string

	// Name of the field
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Configures an S3 data source location.
type S3DataSourceConfiguration struct {

	// A S3 bucket ARN
	//
	// This member is required.
	BucketArn *string

	// A list of S3 prefixes.
	InclusionPrefixes []string

	noSmithyDocumentSerde
}

// The identifier for the S3 resource.
type S3Identifier struct {

	// A bucket in S3.
	S3BucketName *string

	// A object key in S3.
	S3ObjectKey *string

	noSmithyDocumentSerde
}

// Server-side encryption configuration.
type ServerSideEncryptionConfiguration struct {

	// A KMS key ARN
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Configures the physical storage of ingested data in a knowledge base.
type StorageConfiguration struct {

	// The storage type of a knowledge base.
	//
	// This member is required.
	Type KnowledgeBaseStorageType

	// Contains the configurations to use OpenSearch Serverless to store knowledge
	// base data.
	OpensearchServerlessConfiguration *OpenSearchServerlessConfiguration

	// Contains the configurations to use Pinecone to store knowledge base data.
	PineconeConfiguration *PineconeConfiguration

	// Contains the configurations to use RDS to store knowledge base data.
	RdsConfiguration *RdsConfiguration

	// Contains the configurations to use Redis Enterprise Cloud to store knowledge
	// base data.
	RedisEnterpriseCloudConfiguration *RedisEnterpriseCloudConfiguration

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// exception
type ValidationExceptionField struct {

	// Non Blank String
	//
	// This member is required.
	Message *string

	// Non Blank String
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Configures ingestion for a vector knowledge base
type VectorIngestionConfiguration struct {

	// Configures chunking strategy
	ChunkingConfiguration *ChunkingConfiguration

	noSmithyDocumentSerde
}

// Configurations for a vector knowledge base.
type VectorKnowledgeBaseConfiguration struct {

	// Arn of a Bedrock model.
	//
	// This member is required.
	EmbeddingModelArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isActionGroupExecutor() {}
func (*UnknownUnionMember) isAPISchema()           {}
