// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An Amazon Web Services account that is the administrator account of or a member
// of a behavior graph.
type Account struct {

	// The account identifier of the Amazon Web Services account.
	//
	// This member is required.
	AccountId *string

	// The Amazon Web Services account root user email address for the Amazon Web
	// Services account.
	//
	// This member is required.
	EmailAddress *string

	noSmithyDocumentSerde
}

// Information about the Detective administrator account for an organization.
type Administrator struct {

	// The Amazon Web Services account identifier of the Detective administrator
	// account for the organization.
	AccountId *string

	// The date and time when the Detective administrator account was enabled. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z .
	DelegationTime *time.Time

	// The ARN of the organization behavior graph.
	GraphArn *string

	noSmithyDocumentSerde
}

// Details about the data source packages ingested by your behavior graph.
type DatasourcePackageIngestDetail struct {

	// Details on which data source packages are ingested for a member account.
	DatasourcePackageIngestState DatasourcePackageIngestState

	// The date a data source package was enabled for this account
	LastIngestStateChange map[string]TimestampForCollection

	noSmithyDocumentSerde
}

// Information on the usage of a data source package in the behavior graph.
type DatasourcePackageUsageInfo struct {

	// Total volume of data in bytes per day ingested for a given data source package.
	VolumeUsageInBytes *int64

	// The data and time when the member account data volume was last updated. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z .
	VolumeUsageUpdateTime *time.Time

	noSmithyDocumentSerde
}

// Contains details on the time range used to filter data.
type DateFilter struct {

	// A timestamp representing the end date of the time period until when data is
	// filtered , including the end date.
	//
	// This member is required.
	EndInclusive *time.Time

	// A timestamp representing the start of the time period from when data is
	// filtered, including the start date.
	//
	// This member is required.
	StartInclusive *time.Time

	noSmithyDocumentSerde
}

// Details on the criteria used to define the filter for investigation results.
type FilterCriteria struct {

	// Filter the investigation results based on when the investigation was created.
	CreatedTime *DateFilter

	// Filter the investigation results based on the Amazon Resource Name (ARN) of the
	// entity.
	EntityArn *StringFilter

	// Filter the investigation results based on the severity.
	Severity *StringFilter

	// Filter the investigation results based on the state.
	State *StringFilter

	// Filter the investigation results based on the status.
	Status *StringFilter

	noSmithyDocumentSerde
}

// Contains information on suspicious IP addresses identified as indicators of
// compromise. This indicator is derived from Amazon Web Services threat
// intelligence.
type FlaggedIpAddressDetail struct {

	// IP address of the suspicious entity.
	IpAddress *string

	// Details the reason the IP address was flagged as suspicious.
	Reason Reason

	noSmithyDocumentSerde
}

// A behavior graph in Detective.
type Graph struct {

	// The ARN of the behavior graph.
	Arn *string

	// The date and time that the behavior graph was created. The value is an ISO8601
	// formatted string. For example, 2021-08-18T16:35:56.284Z .
	CreatedTime *time.Time

	noSmithyDocumentSerde
}

// Contains information on unusual and impossible travel in an account.
type ImpossibleTravelDetail struct {

	// IP address where the resource was last used in the impossible travel.
	EndingIpAddress *string

	// Location where the resource was last used in the impossible travel.
	EndingLocation *string

	// Returns the time difference between the first and last timestamp the resource
	// was used.
	HourlyTimeDelta *int32

	// IP address where the resource was first used in the impossible travel
	StartingIpAddress *string

	// Location where the resource was first used in the impossible travel
	StartingLocation *string

	noSmithyDocumentSerde
}

// Investigations triages indicators of compromises such as a finding and surfaces
// only the most critical and suspicious issues, so you can focus on high-level
// investigations.
type Indicator struct {

	// Details about the indicator of compromise.
	IndicatorDetail *IndicatorDetail

	// The type of indicator.
	IndicatorType IndicatorType

	noSmithyDocumentSerde
}

// Details about the indicators of compromise which are used to determine if a
// resource is involved in a security incident.
type IndicatorDetail struct {

	// Suspicious IP addresses that are flagged, which indicates critical or severe
	// threats based on threat intelligence by Detective. This indicator is derived
	// from AWS threat intelligence.
	FlaggedIpAddressDetail *FlaggedIpAddressDetail

	// Identifies unusual and impossible user activity for an account.
	ImpossibleTravelDetail *ImpossibleTravelDetail

	// Contains details about the new Autonomous System Organization (ASO).
	NewAsoDetail *NewAsoDetail

	// Contains details about the new geographic location.
	NewGeolocationDetail *NewGeolocationDetail

	// Contains details about the new user agent.
	NewUserAgentDetail *NewUserAgentDetail

	// Contains details about related findings.
	RelatedFindingDetail *RelatedFindingDetail

	// Contains details about related finding groups.
	RelatedFindingGroupDetail *RelatedFindingGroupDetail

	// Details about the indicator of compromise.
	TTPsObservedDetail *TTPsObservedDetail

	noSmithyDocumentSerde
}

// Details about the investigation related to a potential security event
// identified by Detective
type InvestigationDetail struct {

	// The UTC time stamp of the creation time of the investigation report.
	CreatedTime *time.Time

	// The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
	EntityArn *string

	// Type of entity. For example, Amazon Web Services accounts, such as IAM user and
	// role.
	EntityType EntityType

	// The investigation ID of the investigation report.
	InvestigationId *string

	// Severity based on the likelihood and impact of the indicators of compromise
	// discovered in the investigation.
	Severity Severity

	// The current state of the investigation. An archived investigation indicates you
	// have completed reviewing the investigation.
	State State

	// Status based on the completion status of the investigation.
	Status Status

	noSmithyDocumentSerde
}

// Details about a member account in a behavior graph.
type MemberDetail struct {

	// The Amazon Web Services account identifier for the member account.
	AccountId *string

	// The Amazon Web Services account identifier of the administrator account for the
	// behavior graph.
	AdministratorId *string

	// The state of a data source package for the behavior graph.
	DatasourcePackageIngestStates map[string]DatasourcePackageIngestState

	// For member accounts with a status of ACCEPTED_BUT_DISABLED , the reason that the
	// member account is not enabled. The reason can have one of the following values:
	//   - VOLUME_TOO_HIGH - Indicates that adding the member account would cause the
	//   data volume for the behavior graph to be too high.
	//   - VOLUME_UNKNOWN - Indicates that Detective is unable to verify the data
	//   volume for the member account. This is usually because the member account is not
	//   enrolled in Amazon GuardDuty.
	DisabledReason MemberDisabledReason

	// The Amazon Web Services account root user email address for the member account.
	EmailAddress *string

	// The ARN of the behavior graph.
	GraphArn *string

	// The type of behavior graph membership. For an organization account in the
	// organization behavior graph, the type is ORGANIZATION . For an account that was
	// invited to a behavior graph, the type is INVITATION .
	InvitationType InvitationType

	// For invited accounts, the date and time that Detective sent the invitation to
	// the account. The value is an ISO8601 formatted string. For example,
	// 2021-08-18T16:35:56.284Z .
	InvitedTime *time.Time

	// The Amazon Web Services account identifier of the administrator account for the
	// behavior graph.
	//
	// Deprecated: This property is deprecated. Use AdministratorId instead.
	MasterId *string

	// The member account data volume as a percentage of the maximum allowed data
	// volume. 0 indicates 0 percent, and 100 indicates 100 percent. Note that this is
	// not the percentage of the behavior graph data volume. For example, the data
	// volume for the behavior graph is 80 GB per day. The maximum data volume is 160
	// GB per day. If the data volume for the member account is 40 GB per day, then
	// PercentOfGraphUtilization is 25. It represents 25% of the maximum allowed data
	// volume.
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage
	// instead.
	PercentOfGraphUtilization *float64

	// The date and time when the graph utilization percentage was last updated. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z .
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage
	// instead.
	PercentOfGraphUtilizationUpdatedTime *time.Time

	// The current membership status of the member account. The status can have one of
	// the following values:
	//   - INVITED - For invited accounts only. Indicates that the member was sent an
	//   invitation but has not yet responded.
	//   - VERIFICATION_IN_PROGRESS - For invited accounts only, indicates that
	//   Detective is verifying that the account identifier and email address provided
	//   for the member account match. If they do match, then Detective sends the
	//   invitation. If the email address and account identifier don't match, then the
	//   member cannot be added to the behavior graph. For organization accounts in the
	//   organization behavior graph, indicates that Detective is verifying that the
	//   account belongs to the organization.
	//   - VERIFICATION_FAILED - For invited accounts only. Indicates that the account
	//   and email address provided for the member account do not match, and Detective
	//   did not send an invitation to the account.
	//   - ENABLED - Indicates that the member account currently contributes data to
	//   the behavior graph. For invited accounts, the member account accepted the
	//   invitation. For organization accounts in the organization behavior graph, the
	//   Detective administrator account enabled the organization account as a member
	//   account.
	//   - ACCEPTED_BUT_DISABLED - The account accepted the invitation, or was enabled
	//   by the Detective administrator account, but is prevented from contributing data
	//   to the behavior graph. DisabledReason provides the reason why the member
	//   account is not enabled.
	// Invited accounts that declined an invitation or that were removed from the
	// behavior graph are not included. In the organization behavior graph,
	// organization accounts that the Detective administrator account did not enable
	// are not included.
	Status MemberStatus

	// The date and time that the member account was last updated. The value is an
	// ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z .
	UpdatedTime *time.Time

	// Details on the volume of usage for each data source package in a behavior graph.
	VolumeUsageByDatasourcePackage map[string]DatasourcePackageUsageInfo

	// The data volume in bytes per day for the member account.
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage
	// instead.
	VolumeUsageInBytes *int64

	// The data and time when the member account data volume was last updated. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z .
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage
	// instead.
	VolumeUsageUpdatedTime *time.Time

	noSmithyDocumentSerde
}

// Details on data source packages for members of the behavior graph.
type MembershipDatasources struct {

	// The account identifier of the Amazon Web Services account.
	AccountId *string

	// Details on when a data source package was added to a behavior graph.
	DatasourcePackageIngestHistory map[string]map[string]TimestampForCollection

	// The ARN of the organization behavior graph.
	GraphArn *string

	noSmithyDocumentSerde
}

// Details new Autonomous System Organizations (ASOs) used either at the resource
// or account level.
type NewAsoDetail struct {

	// Details about the new Autonomous System Organization (ASO).
	Aso *string

	// Checks if the ASO is for new for the entire account.
	IsNewForEntireAccount bool

	noSmithyDocumentSerde
}

// Details new geolocations used either at the resource or account level. For
// example, lists an observed geolocation that is an infrequent or unused location
// based on previous user activity.
type NewGeolocationDetail struct {

	// IP address using which the resource was accessed.
	IpAddress *string

	// Checks if the gelocation is new for the entire account.
	IsNewForEntireAccount bool

	// Location where the resource was accessed.
	Location *string

	noSmithyDocumentSerde
}

// Details new user agents used either at the resource or account level.
type NewUserAgentDetail struct {

	// Checks if the user agent is new for the entire account.
	IsNewForEntireAccount bool

	// New user agent which accessed the resource.
	UserAgent *string

	noSmithyDocumentSerde
}

// Details related activities associated with a potential security event. Lists
// all distinct categories of evidence that are connected to the resource or the
// finding group.
type RelatedFindingDetail struct {

	// The ARN of the related finding.
	Arn *string

	// The IP address of the finding.
	IpAddress *string

	// The type of finding.
	Type *string

	noSmithyDocumentSerde
}

// Details multiple activities as they related to a potential security event.
// Detective uses graph analysis technique that infers relationships between
// findings and entities, and groups them together as a finding group.
type RelatedFindingGroupDetail struct {

	// The unique identifier for the finding group.
	Id *string

	noSmithyDocumentSerde
}

// Details about the criteria used for sorting investigations.
type SortCriteria struct {

	// Represents the Field attribute to sort investigations.
	Field Field

	// The order by which the sorted findings are displayed.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// A string for filtering Detective investigations.
type StringFilter struct {

	// The string filter value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Details on when data collection began for a source package.
type TimestampForCollection struct {

	// The data and time when data collection began for a source package. The value is
	// an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z .
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Details tactics, techniques, and procedures (TTPs) used in a potential security
// event. Tactics are based on MITRE ATT&CK Matrix for Enterprise (https://attack.mitre.org/matrices/enterprise/)
// .
type TTPsObservedDetail struct {

	// The total number of failed API requests.
	APIFailureCount int64

	// The name of the API where the TTP was observed.
	APIName *string

	// The total number of successful API requests.
	APISuccessCount int64

	// The IP address where the TTP was observed.
	IpAddress *string

	// The procedure used, identified by the investigation.
	Procedure *string

	// The tactic used, identified by the investigation.
	Tactic *string

	// The technique used, identified by the investigation.
	Technique *string

	noSmithyDocumentSerde
}

// A member account that was included in a request but for which the request could
// not be processed.
type UnprocessedAccount struct {

	// The Amazon Web Services account identifier of the member account that was not
	// processed.
	AccountId *string

	// The reason that the member account request could not be processed.
	Reason *string

	noSmithyDocumentSerde
}

// Behavior graphs that could not be processed in the request.
type UnprocessedGraph struct {

	// The ARN of the organization behavior graph.
	GraphArn *string

	// The reason data source package information could not be processed for a
	// behavior graph.
	Reason *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
