// Code generated by smithy-go-codegen DO NOT EDIT.

package kafkaconnect

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kafkaconnect/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateConnector struct {
}

func (*awsRestjson1_serializeOpCreateConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/connectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConnectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConnectorInput(v *CreateConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConnectorInput(v *CreateConnectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capacity != nil {
		ok := object.Key("capacity")
		if err := awsRestjson1_serializeDocumentCapacity(v.Capacity, ok); err != nil {
			return err
		}
	}

	if v.ConnectorConfiguration != nil {
		ok := object.Key("connectorConfiguration")
		if err := awsRestjson1_serializeDocument__sensitive__mapOf__string(v.ConnectorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ConnectorDescription != nil {
		ok := object.Key("connectorDescription")
		ok.String(*v.ConnectorDescription)
	}

	if v.ConnectorName != nil {
		ok := object.Key("connectorName")
		ok.String(*v.ConnectorName)
	}

	if v.KafkaCluster != nil {
		ok := object.Key("kafkaCluster")
		if err := awsRestjson1_serializeDocumentKafkaCluster(v.KafkaCluster, ok); err != nil {
			return err
		}
	}

	if v.KafkaClusterClientAuthentication != nil {
		ok := object.Key("kafkaClusterClientAuthentication")
		if err := awsRestjson1_serializeDocumentKafkaClusterClientAuthentication(v.KafkaClusterClientAuthentication, ok); err != nil {
			return err
		}
	}

	if v.KafkaClusterEncryptionInTransit != nil {
		ok := object.Key("kafkaClusterEncryptionInTransit")
		if err := awsRestjson1_serializeDocumentKafkaClusterEncryptionInTransit(v.KafkaClusterEncryptionInTransit, ok); err != nil {
			return err
		}
	}

	if v.KafkaConnectVersion != nil {
		ok := object.Key("kafkaConnectVersion")
		ok.String(*v.KafkaConnectVersion)
	}

	if v.LogDelivery != nil {
		ok := object.Key("logDelivery")
		if err := awsRestjson1_serializeDocumentLogDelivery(v.LogDelivery, ok); err != nil {
			return err
		}
	}

	if v.Plugins != nil {
		ok := object.Key("plugins")
		if err := awsRestjson1_serializeDocument__listOfPlugin(v.Plugins, ok); err != nil {
			return err
		}
	}

	if v.ServiceExecutionRoleArn != nil {
		ok := object.Key("serviceExecutionRoleArn")
		ok.String(*v.ServiceExecutionRoleArn)
	}

	if v.WorkerConfiguration != nil {
		ok := object.Key("workerConfiguration")
		if err := awsRestjson1_serializeDocumentWorkerConfiguration(v.WorkerConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateCustomPlugin struct {
}

func (*awsRestjson1_serializeOpCreateCustomPlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCustomPlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomPluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/custom-plugins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateCustomPluginInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCustomPluginInput(v *CreateCustomPluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateCustomPluginInput(v *CreateCustomPluginInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentType) > 0 {
		ok := object.Key("contentType")
		ok.String(string(v.ContentType))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Location != nil {
		ok := object.Key("location")
		if err := awsRestjson1_serializeDocumentCustomPluginLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkerConfiguration struct {
}

func (*awsRestjson1_serializeOpCreateWorkerConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkerConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkerConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/worker-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkerConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkerConfigurationInput(v *CreateWorkerConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkerConfigurationInput(v *CreateWorkerConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.PropertiesFileContent != nil {
		ok := object.Key("propertiesFileContent")
		ok.String(*v.PropertiesFileContent)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConnector struct {
}

func (*awsRestjson1_serializeOpDeleteConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/connectors/{connectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConnectorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConnectorInput(v *DeleteConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member connectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("connectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		encoder.SetQuery("currentVersion").String(*v.CurrentVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCustomPlugin struct {
}

func (*awsRestjson1_serializeOpDeleteCustomPlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCustomPlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomPluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/custom-plugins/{customPluginArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCustomPluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCustomPluginInput(v *DeleteCustomPluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CustomPluginArn == nil || len(*v.CustomPluginArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member customPluginArn must not be empty")}
	}
	if v.CustomPluginArn != nil {
		if err := encoder.SetURI("customPluginArn").String(*v.CustomPluginArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConnector struct {
}

func (*awsRestjson1_serializeOpDescribeConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/connectors/{connectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeConnectorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConnectorInput(v *DescribeConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member connectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("connectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCustomPlugin struct {
}

func (*awsRestjson1_serializeOpDescribeCustomPlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCustomPlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCustomPluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/custom-plugins/{customPluginArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCustomPluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCustomPluginInput(v *DescribeCustomPluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CustomPluginArn == nil || len(*v.CustomPluginArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member customPluginArn must not be empty")}
	}
	if v.CustomPluginArn != nil {
		if err := encoder.SetURI("customPluginArn").String(*v.CustomPluginArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeWorkerConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribeWorkerConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeWorkerConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeWorkerConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/worker-configurations/{workerConfigurationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeWorkerConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeWorkerConfigurationInput(v *DescribeWorkerConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkerConfigurationArn == nil || len(*v.WorkerConfigurationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerConfigurationArn must not be empty")}
	}
	if v.WorkerConfigurationArn != nil {
		if err := encoder.SetURI("workerConfigurationArn").String(*v.WorkerConfigurationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListConnectors struct {
}

func (*awsRestjson1_serializeOpListConnectors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConnectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConnectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/connectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConnectorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConnectorsInput(v *ListConnectorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorNamePrefix != nil {
		encoder.SetQuery("connectorNamePrefix").String(*v.ConnectorNamePrefix)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCustomPlugins struct {
}

func (*awsRestjson1_serializeOpListCustomPlugins) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCustomPlugins) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomPluginsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/custom-plugins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCustomPluginsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCustomPluginsInput(v *ListCustomPluginsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListWorkerConfigurations struct {
}

func (*awsRestjson1_serializeOpListWorkerConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkerConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkerConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/worker-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkerConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkerConfigurationsInput(v *ListWorkerConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConnector struct {
}

func (*awsRestjson1_serializeOpUpdateConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/connectors/{connectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConnectorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConnectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConnectorInput(v *UpdateConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member connectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("connectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		encoder.SetQuery("currentVersion").String(*v.CurrentVersion)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConnectorInput(v *UpdateConnectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capacity != nil {
		ok := object.Key("capacity")
		if err := awsRestjson1_serializeDocumentCapacityUpdate(v.Capacity, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfPlugin(v []types.Plugin, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPlugin(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__sensitive__mapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentApacheKafkaCluster(v *types.ApacheKafkaCluster, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BootstrapServers != nil {
		ok := object.Key("bootstrapServers")
		ok.String(*v.BootstrapServers)
	}

	if v.Vpc != nil {
		ok := object.Key("vpc")
		if err := awsRestjson1_serializeDocumentVpc(v.Vpc, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutoScaling(v *types.AutoScaling, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxWorkerCount")
		ok.Integer(v.MaxWorkerCount)
	}

	{
		ok := object.Key("mcuCount")
		ok.Integer(v.McuCount)
	}

	{
		ok := object.Key("minWorkerCount")
		ok.Integer(v.MinWorkerCount)
	}

	if v.ScaleInPolicy != nil {
		ok := object.Key("scaleInPolicy")
		if err := awsRestjson1_serializeDocumentScaleInPolicy(v.ScaleInPolicy, ok); err != nil {
			return err
		}
	}

	if v.ScaleOutPolicy != nil {
		ok := object.Key("scaleOutPolicy")
		if err := awsRestjson1_serializeDocumentScaleOutPolicy(v.ScaleOutPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutoScalingUpdate(v *types.AutoScalingUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maxWorkerCount")
		ok.Integer(v.MaxWorkerCount)
	}

	{
		ok := object.Key("mcuCount")
		ok.Integer(v.McuCount)
	}

	{
		ok := object.Key("minWorkerCount")
		ok.Integer(v.MinWorkerCount)
	}

	if v.ScaleInPolicy != nil {
		ok := object.Key("scaleInPolicy")
		if err := awsRestjson1_serializeDocumentScaleInPolicyUpdate(v.ScaleInPolicy, ok); err != nil {
			return err
		}
	}

	if v.ScaleOutPolicy != nil {
		ok := object.Key("scaleOutPolicy")
		if err := awsRestjson1_serializeDocumentScaleOutPolicyUpdate(v.ScaleOutPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCapacity(v *types.Capacity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScaling != nil {
		ok := object.Key("autoScaling")
		if err := awsRestjson1_serializeDocumentAutoScaling(v.AutoScaling, ok); err != nil {
			return err
		}
	}

	if v.ProvisionedCapacity != nil {
		ok := object.Key("provisionedCapacity")
		if err := awsRestjson1_serializeDocumentProvisionedCapacity(v.ProvisionedCapacity, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCapacityUpdate(v *types.CapacityUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScaling != nil {
		ok := object.Key("autoScaling")
		if err := awsRestjson1_serializeDocumentAutoScalingUpdate(v.AutoScaling, ok); err != nil {
			return err
		}
	}

	if v.ProvisionedCapacity != nil {
		ok := object.Key("provisionedCapacity")
		if err := awsRestjson1_serializeDocumentProvisionedCapacityUpdate(v.ProvisionedCapacity, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchLogsLogDelivery(v *types.CloudWatchLogsLogDelivery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.LogGroup != nil {
		ok := object.Key("logGroup")
		ok.String(*v.LogGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomPlugin(v *types.CustomPlugin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomPluginArn != nil {
		ok := object.Key("customPluginArn")
		ok.String(*v.CustomPluginArn)
	}

	{
		ok := object.Key("revision")
		ok.Long(v.Revision)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomPluginLocation(v *types.CustomPluginLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Location != nil {
		ok := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(v.S3Location, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFirehoseLogDelivery(v *types.FirehoseLogDelivery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStream != nil {
		ok := object.Key("deliveryStream")
		ok.String(*v.DeliveryStream)
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentKafkaCluster(v *types.KafkaCluster, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApacheKafkaCluster != nil {
		ok := object.Key("apacheKafkaCluster")
		if err := awsRestjson1_serializeDocumentApacheKafkaCluster(v.ApacheKafkaCluster, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKafkaClusterClientAuthentication(v *types.KafkaClusterClientAuthentication, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("authenticationType")
		ok.String(string(v.AuthenticationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentKafkaClusterEncryptionInTransit(v *types.KafkaClusterEncryptionInTransit, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncryptionType) > 0 {
		ok := object.Key("encryptionType")
		ok.String(string(v.EncryptionType))
	}

	return nil
}

func awsRestjson1_serializeDocumentLogDelivery(v *types.LogDelivery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WorkerLogDelivery != nil {
		ok := object.Key("workerLogDelivery")
		if err := awsRestjson1_serializeDocumentWorkerLogDelivery(v.WorkerLogDelivery, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPlugin(v *types.Plugin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomPlugin != nil {
		ok := object.Key("customPlugin")
		if err := awsRestjson1_serializeDocumentCustomPlugin(v.CustomPlugin, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentProvisionedCapacity(v *types.ProvisionedCapacity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("mcuCount")
		ok.Integer(v.McuCount)
	}

	{
		ok := object.Key("workerCount")
		ok.Integer(v.WorkerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentProvisionedCapacityUpdate(v *types.ProvisionedCapacityUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("mcuCount")
		ok.Integer(v.McuCount)
	}

	{
		ok := object.Key("workerCount")
		ok.Integer(v.WorkerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Location(v *types.S3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketArn != nil {
		ok := object.Key("bucketArn")
		ok.String(*v.BucketArn)
	}

	if v.FileKey != nil {
		ok := object.Key("fileKey")
		ok.String(*v.FileKey)
	}

	if v.ObjectVersion != nil {
		ok := object.Key("objectVersion")
		ok.String(*v.ObjectVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3LogDelivery(v *types.S3LogDelivery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentScaleInPolicy(v *types.ScaleInPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("cpuUtilizationPercentage")
		ok.Integer(v.CpuUtilizationPercentage)
	}

	return nil
}

func awsRestjson1_serializeDocumentScaleInPolicyUpdate(v *types.ScaleInPolicyUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("cpuUtilizationPercentage")
		ok.Integer(v.CpuUtilizationPercentage)
	}

	return nil
}

func awsRestjson1_serializeDocumentScaleOutPolicy(v *types.ScaleOutPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("cpuUtilizationPercentage")
		ok.Integer(v.CpuUtilizationPercentage)
	}

	return nil
}

func awsRestjson1_serializeDocumentScaleOutPolicyUpdate(v *types.ScaleOutPolicyUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("cpuUtilizationPercentage")
		ok.Integer(v.CpuUtilizationPercentage)
	}

	return nil
}

func awsRestjson1_serializeDocumentVpc(v *types.Vpc, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroups != nil {
		ok := object.Key("securityGroups")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("subnets")
		if err := awsRestjson1_serializeDocument__listOf__string(v.Subnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkerConfiguration(v *types.WorkerConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("revision")
		ok.Long(v.Revision)
	}

	if v.WorkerConfigurationArn != nil {
		ok := object.Key("workerConfigurationArn")
		ok.String(*v.WorkerConfigurationArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkerLogDelivery(v *types.WorkerLogDelivery, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogs != nil {
		ok := object.Key("cloudWatchLogs")
		if err := awsRestjson1_serializeDocumentCloudWatchLogsLogDelivery(v.CloudWatchLogs, ok); err != nil {
			return err
		}
	}

	if v.Firehose != nil {
		ok := object.Key("firehose")
		if err := awsRestjson1_serializeDocumentFirehoseLogDelivery(v.Firehose, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("s3")
		if err := awsRestjson1_serializeDocumentS3LogDelivery(v.S3, ok); err != nil {
			return err
		}
	}

	return nil
}
