// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/neptunedata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The fast reset REST API lets you reset a Neptune graph quicky and easily,
// removing all of its data. Neptune fast reset is a two-step process. First you
// call ExecuteFastReset with action set to initiateDatabaseReset . This returns a
// UUID token which you then include when calling ExecuteFastReset again with
// action set to performDatabaseReset . See Empty an Amazon Neptune DB cluster
// using the fast reset API (https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html)
// . When invoking this operation in a Neptune cluster that has IAM authentication
// enabled, the IAM user or role making the request must have a policy attached
// that allows the neptune-db:ResetDatabase (https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase)
// IAM action in that cluster.
func (c *Client) ExecuteFastReset(ctx context.Context, params *ExecuteFastResetInput, optFns ...func(*Options)) (*ExecuteFastResetOutput, error) {
	if params == nil {
		params = &ExecuteFastResetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ExecuteFastReset", params, optFns, c.addOperationExecuteFastResetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ExecuteFastResetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ExecuteFastResetInput struct {

	// The fast reset action. One of the following values:
	//   - initiateDatabaseReset – This action generates a unique token needed to
	//   actually perform the fast reset.
	//   - performDatabaseReset – This action uses the token generated by the
	//   initiateDatabaseReset action to actually perform the fast reset.
	//
	// This member is required.
	Action types.Action

	// The fast-reset token to initiate the reset.
	Token *string

	noSmithyDocumentSerde
}

type ExecuteFastResetOutput struct {

	// The status is only returned for the performDatabaseReset action, and indicates
	// whether or not the fast reset rquest is accepted.
	//
	// This member is required.
	Status *string

	// The payload is only returned by the initiateDatabaseReset action, and contains
	// the unique token to use with the performDatabaseReset action to make the reset
	// occur.
	Payload *types.FastResetToken

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationExecuteFastResetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpExecuteFastReset{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpExecuteFastReset{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ExecuteFastReset"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpExecuteFastResetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opExecuteFastReset(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opExecuteFastReset(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ExecuteFastReset",
	}
}
