// Code generated by smithy-go-codegen DO NOT EDIT.

package pi

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pi/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreatePerformanceAnalysisReport struct {
}

func (*validateOpCreatePerformanceAnalysisReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePerformanceAnalysisReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePerformanceAnalysisReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePerformanceAnalysisReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePerformanceAnalysisReport struct {
}

func (*validateOpDeletePerformanceAnalysisReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePerformanceAnalysisReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePerformanceAnalysisReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePerformanceAnalysisReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDimensionKeys struct {
}

func (*validateOpDescribeDimensionKeys) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDimensionKeys) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDimensionKeysInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDimensionKeysInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDimensionKeyDetails struct {
}

func (*validateOpGetDimensionKeyDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDimensionKeyDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDimensionKeyDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDimensionKeyDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPerformanceAnalysisReport struct {
}

func (*validateOpGetPerformanceAnalysisReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPerformanceAnalysisReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPerformanceAnalysisReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPerformanceAnalysisReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResourceMetadata struct {
}

func (*validateOpGetResourceMetadata) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResourceMetadata) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResourceMetadataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResourceMetadataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResourceMetrics struct {
}

func (*validateOpGetResourceMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResourceMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResourceMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResourceMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAvailableResourceDimensions struct {
}

func (*validateOpListAvailableResourceDimensions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAvailableResourceDimensions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAvailableResourceDimensionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAvailableResourceDimensionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAvailableResourceMetrics struct {
}

func (*validateOpListAvailableResourceMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAvailableResourceMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAvailableResourceMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAvailableResourceMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPerformanceAnalysisReports struct {
}

func (*validateOpListPerformanceAnalysisReports) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPerformanceAnalysisReports) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPerformanceAnalysisReportsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPerformanceAnalysisReportsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreatePerformanceAnalysisReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePerformanceAnalysisReport{}, middleware.After)
}

func addOpDeletePerformanceAnalysisReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePerformanceAnalysisReport{}, middleware.After)
}

func addOpDescribeDimensionKeysValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDimensionKeys{}, middleware.After)
}

func addOpGetDimensionKeyDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDimensionKeyDetails{}, middleware.After)
}

func addOpGetPerformanceAnalysisReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPerformanceAnalysisReport{}, middleware.After)
}

func addOpGetResourceMetadataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResourceMetadata{}, middleware.After)
}

func addOpGetResourceMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResourceMetrics{}, middleware.After)
}

func addOpListAvailableResourceDimensionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAvailableResourceDimensions{}, middleware.After)
}

func addOpListAvailableResourceMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAvailableResourceMetrics{}, middleware.After)
}

func addOpListPerformanceAnalysisReportsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPerformanceAnalysisReports{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateDimensionGroup(v *types.DimensionGroup) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DimensionGroup"}
	if v.Group == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Group"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricQuery(v *types.MetricQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricQuery"}
	if v.Metric == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metric"))
	}
	if v.GroupBy != nil {
		if err := validateDimensionGroup(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricQueryList(v []types.MetricQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricQueryList"}
	for i := range v {
		if err := validateMetricQuery(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePerformanceAnalysisReportInput(v *CreatePerformanceAnalysisReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePerformanceAnalysisReportInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePerformanceAnalysisReportInput(v *DeletePerformanceAnalysisReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePerformanceAnalysisReportInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.AnalysisReportId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalysisReportId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDimensionKeysInput(v *DescribeDimensionKeysInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDimensionKeysInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.Metric == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metric"))
	}
	if v.GroupBy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GroupBy"))
	} else if v.GroupBy != nil {
		if err := validateDimensionGroup(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if v.PartitionBy != nil {
		if err := validateDimensionGroup(v.PartitionBy); err != nil {
			invalidParams.AddNested("PartitionBy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDimensionKeyDetailsInput(v *GetDimensionKeyDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDimensionKeyDetailsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.Group == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Group"))
	}
	if v.GroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GroupIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPerformanceAnalysisReportInput(v *GetPerformanceAnalysisReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPerformanceAnalysisReportInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.AnalysisReportId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalysisReportId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResourceMetadataInput(v *GetResourceMetadataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResourceMetadataInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResourceMetricsInput(v *GetResourceMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResourceMetricsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.MetricQueries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricQueries"))
	} else if v.MetricQueries != nil {
		if err := validateMetricQueryList(v.MetricQueries); err != nil {
			invalidParams.AddNested("MetricQueries", err.(smithy.InvalidParamsError))
		}
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAvailableResourceDimensionsInput(v *ListAvailableResourceDimensionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAvailableResourceDimensionsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.Metrics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metrics"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAvailableResourceMetricsInput(v *ListAvailableResourceMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAvailableResourceMetricsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.MetricTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPerformanceAnalysisReportsInput(v *ListPerformanceAnalysisReportsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPerformanceAnalysisReportsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
