// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// When included in a receipt rule, this action adds a header to the received
// email. For information about adding a header using a receipt rule, see the
// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-add-header.html)
// .
type AddHeaderAction struct {

	// The name of the header to add to the incoming message. The name must contain at
	// least one character, and can contain up to 50 characters. It consists of
	// alphanumeric (a–z, A–Z, 0–9) characters and dashes.
	//
	// This member is required.
	HeaderName *string

	// The content to include in the header. This value can contain up to 2048
	// characters. It can't contain newline ( \n ) or carriage return ( \r ) characters.
	//
	// This member is required.
	HeaderValue *string

	noSmithyDocumentSerde
}

// Represents the body of the message. You can specify text, HTML, or both. If you
// use both, then the message should display correctly in the widest variety of
// email clients.
type Body struct {

	// The content of the message, in HTML format. Use this for email clients that can
	// process HTML. You can include clickable links, formatted text, and much more in
	// an HTML message.
	Html *Content

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	Text *Content

	noSmithyDocumentSerde
}

// When included in a receipt rule, this action rejects the received email by
// returning a bounce response to the sender and, optionally, publishes a
// notification to Amazon Simple Notification Service (Amazon SNS). For information
// about sending a bounce message in response to a received email, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-bounce.html)
// .
type BounceAction struct {

	// Human-readable text to include in the bounce message.
	//
	// This member is required.
	Message *string

	// The email address of the sender of the bounced email. This is the address from
	// which the bounce message is sent.
	//
	// This member is required.
	Sender *string

	// The SMTP reply code, as defined by RFC 5321 (https://tools.ietf.org/html/rfc5321)
	// .
	//
	// This member is required.
	SmtpReplyCode *string

	// The SMTP enhanced status code, as defined by RFC 3463 (https://tools.ietf.org/html/rfc3463)
	// .
	StatusCode *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// bounce action is taken. You can find the ARN of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// operation in Amazon SNS. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	TopicArn *string

	noSmithyDocumentSerde
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces. For
// information about receiving email through Amazon SES, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html)
// .
type BouncedRecipientInfo struct {

	// The email address of the recipient of the bounced email.
	//
	// This member is required.
	Recipient *string

	// The reason for the bounce. You must provide either this parameter or
	// RecipientDsnFields .
	BounceType BounceType

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to receive email for the recipient of the bounced email. For more
	// information about sending authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html)
	// .
	RecipientArn *string

	// Recipient-related DSN fields, most of which would normally be filled in
	// automatically when provided with a BounceType . You must provide either this
	// parameter or BounceType .
	RecipientDsnFields *RecipientDsnFields

	noSmithyDocumentSerde
}

// An array that contains one or more Destinations, as well as the tags and
// replacement data associated with each of those Destinations.
type BulkEmailDestination struct {

	// Represents the destination of the message, consisting of To:, CC:, and BCC:
	// fields. Amazon SES does not support the SMTPUTF8 extension, as described in
	// RFC6531 (https://tools.ietf.org/html/rfc6531) . For this reason, the email
	// address string must be 7-bit ASCII. If you want to send to or from email
	// addresses that contain Unicode characters in the domain part of an address, you
	// must encode the domain using Punycode. Punycode is not permitted in the local
	// part of the email address (the part before the @ sign) nor in the "friendly
	// from" name. If you want to use Unicode characters in the "friendly from" name,
	// you must encode the "friendly from" name using MIME encoded-word syntax, as
	// described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html)
	// . For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492)
	// .
	//
	// This member is required.
	Destination *Destination

	// A list of tags, in the form of name/value pairs, to apply to an email that you
	// send using SendBulkTemplatedEmail . Tags correspond to characteristics of the
	// email that you define, so that you can publish email sending events.
	ReplacementTags []MessageTag

	// A list of replacement values to apply to the template. This parameter is a JSON
	// object, typically consisting of key-value pairs in which the keys correspond to
	// replacement tags in the email template.
	ReplacementTemplateData *string

	noSmithyDocumentSerde
}

// An object that contains the response from the SendBulkTemplatedEmail operation.
type BulkEmailDestinationStatus struct {

	// A description of an error that prevented a message being sent using the
	// SendBulkTemplatedEmail operation.
	Error *string

	// The unique message identifier returned from the SendBulkTemplatedEmail
	// operation.
	MessageId *string

	// The status of a message sent using the SendBulkTemplatedEmail operation.
	// Possible values for this parameter include:
	//   - Success : Amazon SES accepted the message, and attempts to deliver it to the
	//   recipients.
	//   - MessageRejected : The message was rejected because it contained a virus.
	//   - MailFromDomainNotVerified : The sender's email address or domain was not
	//   verified.
	//   - ConfigurationSetDoesNotExist : The configuration set you specified does not
	//   exist.
	//   - TemplateDoesNotExist : The template you specified does not exist.
	//   - AccountSuspended : Your account has been shut down because of issues related
	//   to your email sending practices.
	//   - AccountThrottled : The number of emails you can send has been reduced
	//   because your account has exceeded its allocated sending limit.
	//   - AccountDailyQuotaExceeded : You have reached or exceeded the maximum number
	//   of emails you can send from your account in a 24-hour period.
	//   - InvalidSendingPoolName : The configuration set you specified refers to an IP
	//   pool that does not exist.
	//   - AccountSendingPaused : Email sending for the Amazon SES account was disabled
	//   using the UpdateAccountSendingEnabled operation.
	//   - ConfigurationSetSendingPaused : Email sending for this configuration set was
	//   disabled using the UpdateConfigurationSetSendingEnabled operation.
	//   - InvalidParameterValue : One or more of the parameters you specified when
	//   calling this operation was invalid. See the error message for additional
	//   information.
	//   - TransientFailure : Amazon SES was unable to process your request because of
	//   a temporary issue.
	//   - Failed : Amazon SES was unable to process your request. See the error
	//   message for additional information.
	Status BulkEmailStatus

	noSmithyDocumentSerde
}

// Contains information associated with an Amazon CloudWatch event destination to
// which email sending events are published. Event destinations, such as Amazon
// CloudWatch, are associated with configuration sets, which enable you to publish
// email sending events. For information about using configuration sets, see the
// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// .
type CloudWatchDestination struct {

	// A list of dimensions upon which to categorize your emails when you publish
	// email sending events to Amazon CloudWatch.
	//
	// This member is required.
	DimensionConfigurations []CloudWatchDimensionConfiguration

	noSmithyDocumentSerde
}

// Contains the dimension configuration to use when you publish email sending
// events to Amazon CloudWatch. For information about publishing email sending
// events to Amazon CloudWatch, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// .
type CloudWatchDimensionConfiguration struct {

	// The default value of the dimension that is published to Amazon CloudWatch if
	// you do not provide the value of the dimension when you send an email. The
	// default value must meet the following requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//   dashes (-), at signs (@), or periods (.).
	//   - Contain 256 characters or fewer.
	//
	// This member is required.
	DefaultDimensionValue *string

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name must meet the following requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//   dashes (-), or colons (:).
	//   - Contain 256 characters or fewer.
	//
	// This member is required.
	DimensionName *string

	// The place where Amazon SES finds the value of a dimension to publish to Amazon
	// CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS
	// header or a parameter to the SendEmail / SendRawEmail API, specify messageTag .
	// To use your own email headers, specify emailHeader . To put a custom tag on any
	// link included in your email, specify linkTag .
	//
	// This member is required.
	DimensionValueSource DimensionValueSource

	noSmithyDocumentSerde
}

// The name of the configuration set. Configuration sets let you create groups of
// rules that you can apply to the emails you send using Amazon SES. For more
// information about using configuration sets, see Using Amazon SES Configuration
// Sets (https://docs.aws.amazon.com/ses/latest/dg/using-configuration-sets.html)
// in the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/) .
type ConfigurationSet struct {

	// The name of the configuration set. The name must meet the following
	// requirements:
	//   - Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes
	//   (-).
	//   - Contain 64 characters or fewer.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents textual data, plus an optional character set specification. By
// default, the text must be 7-bit ASCII, due to the constraints of the SMTP
// protocol. If the text must contain any other characters, then you must also
// specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
type Content struct {

	// The textual data of the content.
	//
	// This member is required.
	Data *string

	// The character set of the content.
	Charset *string

	noSmithyDocumentSerde
}

// Contains information about a custom verification email template.
type CustomVerificationEmailTemplate struct {

	// The URL that the recipient of the verification email is sent to if his or her
	// address is not successfully verified.
	FailureRedirectionURL *string

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string

	// The URL that the recipient of the verification email is sent to if his or her
	// address is successfully verified.
	SuccessRedirectionURL *string

	// The name of the custom verification email template.
	TemplateName *string

	// The subject line of the custom verification email.
	TemplateSubject *string

	noSmithyDocumentSerde
}

// Specifies whether messages that use the configuration set are required to use
// Transport Layer Security (TLS).
type DeliveryOptions struct {

	// Specifies whether messages that use the configuration set are required to use
	// Transport Layer Security (TLS). If the value is Require , messages are only
	// delivered if a TLS connection can be established. If the value is Optional ,
	// messages can be delivered in plain text if a TLS connection can't be
	// established.
	TlsPolicy TlsPolicy

	noSmithyDocumentSerde
}

// Represents the destination of the message, consisting of To:, CC:, and BCC:
// fields. Amazon SES does not support the SMTPUTF8 extension, as described in
// RFC6531 (https://tools.ietf.org/html/rfc6531) . For this reason, the email
// address string must be 7-bit ASCII. If you want to send to or from email
// addresses that contain Unicode characters in the domain part of an address, you
// must encode the domain using Punycode. Punycode is not permitted in the local
// part of the email address (the part before the @ sign) nor in the "friendly
// from" name. If you want to use Unicode characters in the "friendly from" name,
// you must encode the "friendly from" name using MIME encoded-word syntax, as
// described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html)
// . For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492)
// .
type Destination struct {

	// The recipients to place on the BCC: line of the message.
	BccAddresses []string

	// The recipients to place on the CC: line of the message.
	CcAddresses []string

	// The recipients to place on the To: line of the message.
	ToAddresses []string

	noSmithyDocumentSerde
}

// Contains information about an event destination. When you create or update an
// event destination, you must provide one, and only one, destination. The
// destination can be Amazon CloudWatch, Amazon Kinesis Firehose or Amazon Simple
// Notification Service (Amazon SNS). Event destinations are associated with
// configuration sets, which enable you to publish email sending events to Amazon
// CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service
// (Amazon SNS). For information about using configuration sets, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// .
type EventDestination struct {

	// The type of email sending events to publish to the event destination.
	//   - send - The call was successful and Amazon SES is attempting to deliver the
	//   email.
	//   - reject - Amazon SES determined that the email contained a virus and rejected
	//   it.
	//   - bounce - The recipient's mail server permanently rejected the email. This
	//   corresponds to a hard bounce.
	//   - complaint - The recipient marked the email as spam.
	//   - delivery - Amazon SES successfully delivered the email to the recipient's
	//   mail server.
	//   - open - The recipient received the email and opened it in their email client.
	//   - click - The recipient clicked one or more links in the email.
	//   - renderingFailure - Amazon SES did not send the email because of a template
	//   rendering issue.
	//
	// This member is required.
	MatchingEventTypes []EventType

	// The name of the event destination. The name must meet the following
	// requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//   dashes (-).
	//   - Contain 64 characters or fewer.
	//
	// This member is required.
	Name *string

	// An object that contains the names, default values, and sources of the
	// dimensions associated with an Amazon CloudWatch event destination.
	CloudWatchDestination *CloudWatchDestination

	// Sets whether Amazon SES publishes events to this destination when you send an
	// email with the associated configuration set. Set to true to enable publishing
	// to this destination; set to false to prevent publishing to this destination.
	// The default value is false .
	Enabled bool

	// An object that contains the delivery stream ARN and the IAM role ARN associated
	// with an Amazon Kinesis Firehose event destination.
	KinesisFirehoseDestination *KinesisFirehoseDestination

	// An object that contains the topic ARN associated with an Amazon Simple
	// Notification Service (Amazon SNS) event destination.
	SNSDestination *SNSDestination

	noSmithyDocumentSerde
}

// Additional X-headers to include in the Delivery Status Notification (DSN) when
// an email that Amazon SES receives on your behalf bounces. For information about
// receiving email through Amazon SES, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html)
// .
type ExtensionField struct {

	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	//
	// This member is required.
	Name *string

	// The value of the header to add. Must contain 2048 characters or fewer, and must
	// not contain newline characters ("\r" or "\n").
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Represents the DKIM attributes of a verified email address or a domain.
type IdentityDkimAttributes struct {

	// Is true if DKIM signing is enabled for email sent from the identity. It's false
	// otherwise. The default value is true.
	//
	// This member is required.
	DkimEnabled bool

	// Describes whether Amazon SES has successfully verified the DKIM DNS records
	// (tokens) published in the domain name's DNS. (This only applies to domain
	// identities, not email address identities.)
	//
	// This member is required.
	DkimVerificationStatus VerificationStatus

	// A set of character strings that represent the domain's identity. Using these
	// tokens, you need to create DNS CNAME records that point to DKIM public keys that
	// are hosted by Amazon SES. Amazon Web Services eventually detects that you've
	// updated your DNS records. This detection process might take up to 72 hours.
	// After successful detection, Amazon SES is able to DKIM-sign email originating
	// from that domain. (This only applies to domain identities, not email address
	// identities.) For more information about creating DNS records using DKIM tokens,
	// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html)
	// .
	DkimTokens []string

	noSmithyDocumentSerde
}

// Represents the custom MAIL FROM domain attributes of a verified identity (email
// address or domain).
type IdentityMailFromDomainAttributes struct {

	// The action that Amazon SES takes if it cannot successfully read the required MX
	// record when you send an email. A value of UseDefaultValue indicates that if
	// Amazon SES cannot read the required MX record, it uses amazonses.com (or a
	// subdomain of that) as the MAIL FROM domain. A value of RejectMessage indicates
	// that if Amazon SES cannot read the required MX record, Amazon SES returns a
	// MailFromDomainNotVerified error and does not send the email. The custom MAIL
	// FROM setup states that result in this behavior are Pending , Failed , and
	// TemporaryFailure .
	//
	// This member is required.
	BehaviorOnMXFailure BehaviorOnMXFailure

	// The custom MAIL FROM domain that the identity is configured to use.
	//
	// This member is required.
	MailFromDomain *string

	// The state that indicates whether Amazon SES has successfully read the MX record
	// required for custom MAIL FROM domain setup. If the state is Success , Amazon SES
	// uses the specified custom MAIL FROM domain when the verified identity sends an
	// email. All other states indicate that Amazon SES takes the action described by
	// BehaviorOnMXFailure .
	//
	// This member is required.
	MailFromDomainStatus CustomMailFromStatus

	noSmithyDocumentSerde
}

// Represents the notification attributes of an identity, including whether an
// identity has Amazon Simple Notification Service (Amazon SNS) topics set for
// bounce, complaint, and/or delivery notifications, and whether feedback
// forwarding is enabled for bounce and complaint notifications.
type IdentityNotificationAttributes struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES
	// publishes bounce notifications.
	//
	// This member is required.
	BounceTopic *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES
	// publishes complaint notifications.
	//
	// This member is required.
	ComplaintTopic *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES
	// publishes delivery notifications.
	//
	// This member is required.
	DeliveryTopic *string

	// Describes whether Amazon SES forwards bounce and complaint notifications as
	// email. true indicates that Amazon SES forwards bounce and complaint
	// notifications as email, while false indicates that bounce and complaint
	// notifications are published only to the specified bounce and complaint Amazon
	// SNS topics.
	//
	// This member is required.
	ForwardingEnabled bool

	// Describes whether Amazon SES includes the original email headers in Amazon SNS
	// notifications of type Bounce . A value of true specifies that Amazon SES
	// includes headers in bounce notifications, and a value of false specifies that
	// Amazon SES does not include headers in bounce notifications.
	HeadersInBounceNotificationsEnabled bool

	// Describes whether Amazon SES includes the original email headers in Amazon SNS
	// notifications of type Complaint . A value of true specifies that Amazon SES
	// includes headers in complaint notifications, and a value of false specifies
	// that Amazon SES does not include headers in complaint notifications.
	HeadersInComplaintNotificationsEnabled bool

	// Describes whether Amazon SES includes the original email headers in Amazon SNS
	// notifications of type Delivery . A value of true specifies that Amazon SES
	// includes headers in delivery notifications, and a value of false specifies that
	// Amazon SES does not include headers in delivery notifications.
	HeadersInDeliveryNotificationsEnabled bool

	noSmithyDocumentSerde
}

// Represents the verification attributes of a single identity.
type IdentityVerificationAttributes struct {

	// The verification status of the identity: "Pending", "Success", "Failed", or
	// "TemporaryFailure".
	//
	// This member is required.
	VerificationStatus VerificationStatus

	// The verification token for a domain identity. Null for email address identities.
	VerificationToken *string

	noSmithyDocumentSerde
}

// Contains the delivery stream ARN and the IAM role ARN associated with an Amazon
// Kinesis Firehose event destination. Event destinations, such as Amazon Kinesis
// Firehose, are associated with configuration sets, which enable you to publish
// email sending events. For information about using configuration sets, see the
// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// .
type KinesisFirehoseDestination struct {

	// The ARN of the Amazon Kinesis Firehose stream that email sending events should
	// be published to.
	//
	// This member is required.
	DeliveryStreamARN *string

	// The ARN of the IAM role under which Amazon SES publishes email sending events
	// to the Amazon Kinesis Firehose stream.
	//
	// This member is required.
	IAMRoleARN *string

	noSmithyDocumentSerde
}

// When included in a receipt rule, this action calls an Amazon Web Services
// Lambda function and, optionally, publishes a notification to Amazon Simple
// Notification Service (Amazon SNS). To enable Amazon SES to call your Amazon Web
// Services Lambda function or to publish to an Amazon SNS topic of another
// account, Amazon SES must have permission to access those resources. For
// information about giving permissions, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html)
// . For information about using Amazon Web Services Lambda actions in receipt
// rules, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-lambda.html)
// .
type LambdaAction struct {

	// The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function. An
	// example of an Amazon Web Services Lambda function ARN is
	// arn:aws:lambda:us-west-2:account-id:function:MyFunction . For more information
	// about Amazon Web Services Lambda, see the Amazon Web Services Lambda Developer
	// Guide (https://docs.aws.amazon.com/lambda/latest/dg/welcome.html) .
	//
	// This member is required.
	FunctionArn *string

	// The invocation type of the Amazon Web Services Lambda function. An invocation
	// type of RequestResponse means that the execution of the function immediately
	// results in a response, and a value of Event means that the function is invoked
	// asynchronously. The default value is Event . For information about Amazon Web
	// Services Lambda invocation types, see the Amazon Web Services Lambda Developer
	// Guide (https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html) . There is
	// a 30-second timeout on RequestResponse invocations. You should use Event
	// invocation in most cases. Use RequestResponse only to make a mail flow
	// decision, such as whether to stop the receipt rule or the receipt rule set.
	InvocationType InvocationType

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// Lambda action is executed. You can find the ARN of a topic by using the
	// ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// operation in Amazon SNS. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	TopicArn *string

	noSmithyDocumentSerde
}

// Represents the message to be sent, composed of a subject and a body.
type Message struct {

	// The message body.
	//
	// This member is required.
	Body *Body

	// The subject of the message: A short summary of the content, which appears in
	// the recipient's inbox.
	//
	// This member is required.
	Subject *Content

	noSmithyDocumentSerde
}

// Message-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces. For
// information about receiving email through Amazon SES, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html)
// .
type MessageDsn struct {

	// The reporting MTA that attempted to deliver the message, formatted as specified
	// in RFC 3464 (https://tools.ietf.org/html/rfc3464) ( mta-name-type; mta-name ).
	// The default value is dns; inbound-smtp.[region].amazonaws.com .
	//
	// This member is required.
	ReportingMta *string

	// When the message was received by the reporting mail transfer agent (MTA), in
	// RFC 822 (https://www.ietf.org/rfc/rfc0822.txt) date-time format.
	ArrivalDate *time.Time

	// Additional X-headers to include in the DSN.
	ExtensionFields []ExtensionField

	noSmithyDocumentSerde
}

// Contains the name and value of a tag that you can provide to SendEmail or
// SendRawEmail to apply to an email. Message tags, which you use with
// configuration sets, enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// .
type MessageTag struct {

	// The name of the tag. The name must meet the following requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//   dashes (-).
	//   - Contain 256 characters or fewer.
	//
	// This member is required.
	Name *string

	// The value of the tag. The value must meet the following requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//   dashes (-).
	//   - Contain 256 characters or fewer.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Represents the raw data of the message.
type RawMessage struct {

	// The raw data of the message. This data needs to base64-encoded if you are
	// accessing Amazon SES directly through the HTTPS interface. If you are accessing
	// Amazon SES using an Amazon Web Services SDK, the SDK takes care of the base
	// 64-encoding for you. In all cases, the client must ensure that the message
	// format complies with Internet email standards regarding email header fields,
	// MIME types, and MIME encoding. The To:, CC:, and BCC: headers in the raw message
	// can contain a group list. If you are using SendRawEmail with sending
	// authorization, you can include X-headers in the raw message to specify the
	// "Source," "From," and "Return-Path" addresses. For more information, see the
	// documentation for SendRawEmail . Do not include these X-headers in the DKIM
	// signature, because they are removed by Amazon SES before sending the email. For
	// more information, go to the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html)
	// .
	//
	// This member is required.
	Data []byte

	noSmithyDocumentSerde
}

// An action that Amazon SES can take when it receives an email on behalf of one
// or more email addresses or domains that you own. An instance of this data type
// can represent only one action. For information about setting up receipt rules,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html)
// .
type ReceiptAction struct {

	// Adds a header to the received email.
	AddHeaderAction *AddHeaderAction

	// Rejects the received email by returning a bounce response to the sender and,
	// optionally, publishes a notification to Amazon Simple Notification Service
	// (Amazon SNS).
	BounceAction *BounceAction

	// Calls an Amazon Web Services Lambda function, and optionally, publishes a
	// notification to Amazon SNS.
	LambdaAction *LambdaAction

	// Saves the received message to an Amazon Simple Storage Service (Amazon S3)
	// bucket and, optionally, publishes a notification to Amazon SNS.
	S3Action *S3Action

	// Publishes the email content within a notification to Amazon SNS.
	SNSAction *SNSAction

	// Terminates the evaluation of the receipt rule set and optionally publishes a
	// notification to Amazon SNS.
	StopAction *StopAction

	// Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
	// Amazon SNS.
	WorkmailAction *WorkmailAction

	noSmithyDocumentSerde
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses. For information
// about setting up IP address filters, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html)
// .
type ReceiptFilter struct {

	// A structure that provides the IP addresses to block or allow, and whether to
	// block or allow incoming mail from them.
	//
	// This member is required.
	IpFilter *ReceiptIpFilter

	// The name of the IP address filter. The name must meet the following
	// requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//   dashes (-).
	//   - Start and end with a letter or number.
	//   - Contain 64 characters or fewer.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses. For information
// about setting up IP address filters, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html)
// .
type ReceiptIpFilter struct {

	// A single IP address or a range of IP addresses to block or allow, specified in
	// Classless Inter-Domain Routing (CIDR) notation. An example of a single email
	// address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For
	// more information about CIDR notation, see RFC 2317 (https://tools.ietf.org/html/rfc2317)
	// .
	//
	// This member is required.
	Cidr *string

	// Indicates whether to block or allow incoming mail from the specified IP
	// addresses.
	//
	// This member is required.
	Policy ReceiptFilterPolicy

	noSmithyDocumentSerde
}

// Receipt rules enable you to specify which actions Amazon SES should take when
// it receives mail on behalf of one or more email addresses or domains that you
// own. Each receipt rule defines a set of email addresses or domains that it
// applies to. If the email addresses or domains match at least one recipient
// address of the message, Amazon SES executes all of the receipt rule's actions on
// the message. For information about setting up receipt rules, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html)
// .
type ReceiptRule struct {

	// The name of the receipt rule. The name must meet the following requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//   dashes (-), or periods (.).
	//   - Start and end with a letter or number.
	//   - Contain 64 characters or fewer.
	//
	// This member is required.
	Name *string

	// An ordered list of actions to perform on messages that match at least one of
	// the recipient email addresses or domains specified in the receipt rule.
	Actions []ReceiptAction

	// If true , the receipt rule is active. The default value is false .
	Enabled bool

	// The recipient domains and email addresses that the receipt rule applies to. If
	// this field is not specified, this rule matches all recipients on all verified
	// domains.
	Recipients []string

	// If true , then messages that this receipt rule applies to are scanned for spam
	// and viruses. The default value is false .
	ScanEnabled bool

	// Specifies whether Amazon SES should require that incoming email is delivered
	// over a connection encrypted with Transport Layer Security (TLS). If this
	// parameter is set to Require , Amazon SES bounces emails that are not received
	// over TLS. The default is Optional .
	TlsPolicy TlsPolicy

	noSmithyDocumentSerde
}

// Information about a receipt rule set. A receipt rule set is a collection of
// rules that specify what Amazon SES should do with mail it receives on behalf of
// your account's verified domains. For information about setting up receipt rule
// sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules)
// .
type ReceiptRuleSetMetadata struct {

	// The date and time the receipt rule set was created.
	CreatedTimestamp *time.Time

	// The name of the receipt rule set. The name must meet the following
	// requirements:
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//   dashes (-).
	//   - Start and end with a letter or number.
	//   - Contain 64 characters or fewer.
	Name *string

	noSmithyDocumentSerde
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces. For
// information about receiving email through Amazon SES, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html)
// .
type RecipientDsnFields struct {

	// The action performed by the reporting mail transfer agent (MTA) as a result of
	// its attempt to deliver the message to the recipient address. This is required by
	// RFC 3464 (https://tools.ietf.org/html/rfc3464) .
	//
	// This member is required.
	Action DsnAction

	// The status code that indicates what went wrong. This is required by RFC 3464 (https://tools.ietf.org/html/rfc3464)
	// .
	//
	// This member is required.
	Status *string

	// An extended explanation of what went wrong; this is usually an SMTP response.
	// See RFC 3463 (https://tools.ietf.org/html/rfc3463) for the correct formatting
	// of this parameter.
	DiagnosticCode *string

	// Additional X-headers to include in the DSN.
	ExtensionFields []ExtensionField

	// The email address that the message was ultimately delivered to. This
	// corresponds to the Final-Recipient in the DSN. If not specified, FinalRecipient
	// is set to the Recipient specified in the BouncedRecipientInfo structure. Either
	// FinalRecipient or the recipient in BouncedRecipientInfo must be a recipient of
	// the original bounced message. Do not prepend the FinalRecipient email address
	// with rfc 822; , as described in RFC 3798 (https://tools.ietf.org/html/rfc3798) .
	FinalRecipient *string

	// The time the final delivery attempt was made, in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt)
	// date-time format.
	LastAttemptDate *time.Time

	// The MTA to which the remote MTA attempted to deliver the message, formatted as
	// specified in RFC 3464 (https://tools.ietf.org/html/rfc3464) ( mta-name-type;
	// mta-name ). This parameter typically applies only to propagating synchronous
	// bounces.
	RemoteMta *string

	noSmithyDocumentSerde
}

// Contains information about the reputation settings for a configuration set.
type ReputationOptions struct {

	// The date and time at which the reputation metrics for the configuration set
	// were last reset. Resetting these metrics is known as a fresh start. When you
	// disable email sending for a configuration set using
	// UpdateConfigurationSetSendingEnabled and later re-enable it, the reputation
	// metrics for the configuration set (but not for the entire Amazon SES account)
	// are reset. If email sending for the configuration set has never been disabled
	// and later re-enabled, the value of this attribute is null .
	LastFreshStart *time.Time

	// Describes whether or not Amazon SES publishes reputation metrics for the
	// configuration set, such as bounce and complaint rates, to Amazon CloudWatch. If
	// the value is true , reputation metrics are published. If the value is false ,
	// reputation metrics are not published. The default value is false .
	ReputationMetricsEnabled bool

	// Describes whether email sending is enabled or disabled for the configuration
	// set. If the value is true , then Amazon SES sends emails that use the
	// configuration set. If the value is false , Amazon SES does not send emails that
	// use the configuration set. The default value is true . You can change this
	// setting using UpdateConfigurationSetSendingEnabled .
	SendingEnabled bool

	noSmithyDocumentSerde
}

// When included in a receipt rule, this action saves the received message to an
// Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
// notification to Amazon Simple Notification Service (Amazon SNS). To enable
// Amazon SES to write emails to your Amazon S3 bucket, use an Amazon Web Services
// KMS key to encrypt your emails, or publish to an Amazon SNS topic of another
// account, Amazon SES must have permission to access those resources. For
// information about granting permissions, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html)
// . When you save your emails to an Amazon S3 bucket, the maximum email size
// (including headers) is 40 MB. Emails larger than that bounces. For information
// about specifying Amazon S3 actions in receipt rules, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-s3.html)
// .
type S3Action struct {

	// The name of the Amazon S3 bucket for incoming email.
	//
	// This member is required.
	BucketName *string

	// The customer master key that Amazon SES should use to encrypt your emails
	// before saving them to the Amazon S3 bucket. You can use the default master key
	// or a custom master key that you created in Amazon Web Services KMS as follows:
	//   - To use the default master key, provide an ARN in the form of
	//   arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses . For example, if
	//   your Amazon Web Services account ID is 123456789012 and you want to use the
	//   default master key in the US West (Oregon) Region, the ARN of the default master
	//   key would be arn:aws:kms:us-west-2:123456789012:alias/aws/ses . If you use the
	//   default master key, you don't need to perform any extra steps to give Amazon SES
	//   permission to use the key.
	//   - To use a custom master key that you created in Amazon Web Services KMS,
	//   provide the ARN of the master key and ensure that you add a statement to your
	//   key's policy to give Amazon SES permission to use it. For more information about
	//   giving permissions, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html)
	//   .
	// For more information about key policies, see the Amazon Web Services KMS
	// Developer Guide (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
	// . If you do not specify a master key, Amazon SES does not encrypt your emails.
	// Your mail is encrypted by Amazon SES using the Amazon S3 encryption client
	// before the mail is submitted to Amazon S3 for storage. It is not encrypted using
	// Amazon S3 server-side encryption. This means that you must use the Amazon S3
	// encryption client to decrypt the email after retrieving it from Amazon S3, as
	// the service has no access to use your Amazon Web Services KMS keys for
	// decryption. This encryption client is currently available with the Amazon Web
	// Services SDK for Java (http://aws.amazon.com/sdk-for-java/) and Amazon Web
	// Services SDK for Ruby (http://aws.amazon.com/sdk-for-ruby/) only. For more
	// information about client-side encryption using Amazon Web Services KMS master
	// keys, see the Amazon S3 Developer Guide (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html)
	// .
	KmsKeyArn *string

	// The key prefix of the Amazon S3 bucket. The key prefix is similar to a
	// directory name that enables you to store similar data under the same directory
	// in a bucket.
	ObjectKeyPrefix *string

	// The ARN of the Amazon SNS topic to notify when the message is saved to the
	// Amazon S3 bucket. You can find the ARN of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// operation in Amazon SNS. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	TopicArn *string

	noSmithyDocumentSerde
}

// Represents sending statistics data. Each SendDataPoint contains statistics for
// a 15-minute period of sending activity.
type SendDataPoint struct {

	// Number of emails that have bounced.
	Bounces int64

	// Number of unwanted emails that were rejected by recipients.
	Complaints int64

	// Number of emails that have been sent.
	DeliveryAttempts int64

	// Number of emails rejected by Amazon SES.
	Rejects int64

	// Time of the data point.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// When included in a receipt rule, this action publishes a notification to Amazon
// Simple Notification Service (Amazon SNS). This action includes a complete copy
// of the email content in the Amazon SNS notifications. Amazon SNS notifications
// for all other actions simply provide information about the email. They do not
// include the email content itself. If you own the Amazon SNS topic, you don't
// need to do anything to give Amazon SES permission to publish emails to it.
// However, if you don't own the Amazon SNS topic, you need to attach a policy to
// the topic to give Amazon SES permissions to access it. For information about
// giving permissions, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html)
// . You can only publish emails that are 150 KB or less (including the header) to
// Amazon SNS. Larger emails bounce. If you anticipate emails larger than 150 KB,
// use the S3 action instead. For information about using a receipt rule to publish
// an Amazon SNS notification, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-sns.html)
// .
type SNSAction struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. You can find
	// the ARN of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// operation in Amazon SNS. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	//
	// This member is required.
	TopicArn *string

	// The encoding to use for the email within the Amazon SNS notification. UTF-8 is
	// easier to use, but may not preserve all special characters when a message was
	// encoded with a different encoding format. Base64 preserves all special
	// characters. The default value is UTF-8.
	Encoding SNSActionEncoding

	noSmithyDocumentSerde
}

// Contains the topic ARN associated with an Amazon Simple Notification Service
// (Amazon SNS) event destination. Event destinations, such as Amazon SNS, are
// associated with configuration sets, which enable you to publish email sending
// events. For information about using configuration sets, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// .
type SNSDestination struct {

	// The ARN of the Amazon SNS topic for email sending events. You can find the ARN
	// of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// Amazon SNS operation. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	//
	// This member is required.
	TopicARN *string

	noSmithyDocumentSerde
}

// When included in a receipt rule, this action terminates the evaluation of the
// receipt rule set and, optionally, publishes a notification to Amazon Simple
// Notification Service (Amazon SNS). For information about setting a stop action
// in a receipt rule, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-stop.html)
// .
type StopAction struct {

	// The scope of the StopAction. The only acceptable value is RuleSet .
	//
	// This member is required.
	Scope StopScope

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop
	// action is taken. You can find the ARN of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// Amazon SNS operation. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	TopicArn *string

	noSmithyDocumentSerde
}

// The content of the email, composed of a subject line and either an HTML part or
// a text-only part.
type Template struct {

	// The name of the template. You use this name when you send email using the
	// SendTemplatedEmail or SendBulkTemplatedEmail operations.
	//
	// This member is required.
	TemplateName *string

	// The HTML body of the email.
	HtmlPart *string

	// The subject line of the email.
	SubjectPart *string

	// The email body that is visible to recipients whose email clients do not display
	// HTML content.
	TextPart *string

	noSmithyDocumentSerde
}

// Contains information about an email template.
type TemplateMetadata struct {

	// The time and date the template was created.
	CreatedTimestamp *time.Time

	// The name of the template.
	Name *string

	noSmithyDocumentSerde
}

// A domain that is used to redirect email recipients to an Amazon SES-operated
// domain. This domain captures open and click events generated by Amazon SES
// emails. For more information, see Configuring Custom Domains to Handle Open and
// Click Tracking (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html)
// in the Amazon SES Developer Guide.
type TrackingOptions struct {

	// The custom subdomain that is used to redirect email recipients to the Amazon
	// SES event tracking domain.
	CustomRedirectDomain *string

	noSmithyDocumentSerde
}

// When included in a receipt rule, this action calls Amazon WorkMail and,
// optionally, publishes a notification to Amazon Simple Notification Service
// (Amazon SNS). It usually isn't necessary to set this up manually, because Amazon
// WorkMail adds the rule automatically during its setup procedure. For information
// using a receipt rule to call Amazon WorkMail, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-workmail.html)
// .
type WorkmailAction struct {

	// The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon
	// WorkMail ARNs use the following format: arn:aws:workmail:::organization/ You
	// can find the ID of your organization by using the ListOrganizations (https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html)
	// operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with " m-
	// ", followed by a string of alphanumeric characters. For information about Amazon
	// WorkMail organizations, see the Amazon WorkMail Administrator Guide (https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html)
	// .
	//
	// This member is required.
	OrganizationArn *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// WorkMail action is called. You can find the ARN of a topic by using the
	// ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// operation in Amazon SNS. For more information about Amazon SNS topics, see the
	// Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
	// .
	TopicArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
