// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1beta1/data_items.proto

package automl

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/any"
	_ "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Unit of the document dimension.
type DocumentDimensions_DocumentDimensionUnit int32

const (
	// Should not be used.
	DocumentDimensions_DOCUMENT_DIMENSION_UNIT_UNSPECIFIED DocumentDimensions_DocumentDimensionUnit = 0
	// Document dimension is measured in inches.
	DocumentDimensions_INCH DocumentDimensions_DocumentDimensionUnit = 1
	// Document dimension is measured in centimeters.
	DocumentDimensions_CENTIMETER DocumentDimensions_DocumentDimensionUnit = 2
	// Document dimension is measured in points. 72 points = 1 inch.
	DocumentDimensions_POINT DocumentDimensions_DocumentDimensionUnit = 3
)

var DocumentDimensions_DocumentDimensionUnit_name = map[int32]string{
	0: "DOCUMENT_DIMENSION_UNIT_UNSPECIFIED",
	1: "INCH",
	2: "CENTIMETER",
	3: "POINT",
}

var DocumentDimensions_DocumentDimensionUnit_value = map[string]int32{
	"DOCUMENT_DIMENSION_UNIT_UNSPECIFIED": 0,
	"INCH":                                1,
	"CENTIMETER":                          2,
	"POINT":                               3,
}

func (x DocumentDimensions_DocumentDimensionUnit) String() string {
	return proto.EnumName(DocumentDimensions_DocumentDimensionUnit_name, int32(x))
}

func (DocumentDimensions_DocumentDimensionUnit) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{2, 0}
}

// The type of TextSegment in the context of the original document.
type Document_Layout_TextSegmentType int32

const (
	// Should not be used.
	Document_Layout_TEXT_SEGMENT_TYPE_UNSPECIFIED Document_Layout_TextSegmentType = 0
	// The text segment is a token. e.g. word.
	Document_Layout_TOKEN Document_Layout_TextSegmentType = 1
	// The text segment is a paragraph.
	Document_Layout_PARAGRAPH Document_Layout_TextSegmentType = 2
	// The text segment is a form field.
	Document_Layout_FORM_FIELD Document_Layout_TextSegmentType = 3
	// The text segment is the name part of a form field. It will be treated
	// as child of another FORM_FIELD TextSegment if its span is subspan of
	// another TextSegment with type FORM_FIELD.
	Document_Layout_FORM_FIELD_NAME Document_Layout_TextSegmentType = 4
	// The text segment is the text content part of a form field. It will be
	// treated as child of another FORM_FIELD TextSegment if its span is
	// subspan of another TextSegment with type FORM_FIELD.
	Document_Layout_FORM_FIELD_CONTENTS Document_Layout_TextSegmentType = 5
	// The text segment is a whole table, including headers, and all rows.
	Document_Layout_TABLE Document_Layout_TextSegmentType = 6
	// The text segment is a table's headers. It will be treated as child of
	// another TABLE TextSegment if its span is subspan of another TextSegment
	// with type TABLE.
	Document_Layout_TABLE_HEADER Document_Layout_TextSegmentType = 7
	// The text segment is a row in table. It will be treated as child of
	// another TABLE TextSegment if its span is subspan of another TextSegment
	// with type TABLE.
	Document_Layout_TABLE_ROW Document_Layout_TextSegmentType = 8
	// The text segment is a cell in table. It will be treated as child of
	// another TABLE_ROW TextSegment if its span is subspan of another
	// TextSegment with type TABLE_ROW.
	Document_Layout_TABLE_CELL Document_Layout_TextSegmentType = 9
)

var Document_Layout_TextSegmentType_name = map[int32]string{
	0: "TEXT_SEGMENT_TYPE_UNSPECIFIED",
	1: "TOKEN",
	2: "PARAGRAPH",
	3: "FORM_FIELD",
	4: "FORM_FIELD_NAME",
	5: "FORM_FIELD_CONTENTS",
	6: "TABLE",
	7: "TABLE_HEADER",
	8: "TABLE_ROW",
	9: "TABLE_CELL",
}

var Document_Layout_TextSegmentType_value = map[string]int32{
	"TEXT_SEGMENT_TYPE_UNSPECIFIED": 0,
	"TOKEN":                         1,
	"PARAGRAPH":                     2,
	"FORM_FIELD":                    3,
	"FORM_FIELD_NAME":               4,
	"FORM_FIELD_CONTENTS":           5,
	"TABLE":                         6,
	"TABLE_HEADER":                  7,
	"TABLE_ROW":                     8,
	"TABLE_CELL":                    9,
}

func (x Document_Layout_TextSegmentType) String() string {
	return proto.EnumName(Document_Layout_TextSegmentType_name, int32(x))
}

func (Document_Layout_TextSegmentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{3, 0, 0}
}

// A representation of an image.
// Only images up to 30MB in size are supported.
type Image struct {
	// Input only. The data representing the image.
	// For Predict calls
	// [image_bytes][google.cloud.automl.v1beta1.Image.image_bytes] must be set,
	// as other options are not currently supported by prediction API. You can
	// read the contents of an uploaded image by using the
	// [content_uri][google.cloud.automl.v1beta1.Image.content_uri] field.
	//
	// Types that are valid to be assigned to Data:
	//	*Image_ImageBytes
	//	*Image_InputConfig
	Data isImage_Data `protobuf_oneof:"data"`
	// Output only. HTTP URI to the thumbnail image.
	ThumbnailUri         string   `protobuf:"bytes,4,opt,name=thumbnail_uri,json=thumbnailUri,proto3" json:"thumbnail_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{0}
}

func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

type isImage_Data interface {
	isImage_Data()
}

type Image_ImageBytes struct {
	ImageBytes []byte `protobuf:"bytes,1,opt,name=image_bytes,json=imageBytes,proto3,oneof"`
}

type Image_InputConfig struct {
	InputConfig *InputConfig `protobuf:"bytes,6,opt,name=input_config,json=inputConfig,proto3,oneof"`
}

func (*Image_ImageBytes) isImage_Data() {}

func (*Image_InputConfig) isImage_Data() {}

func (m *Image) GetData() isImage_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Image) GetImageBytes() []byte {
	if x, ok := m.GetData().(*Image_ImageBytes); ok {
		return x.ImageBytes
	}
	return nil
}

func (m *Image) GetInputConfig() *InputConfig {
	if x, ok := m.GetData().(*Image_InputConfig); ok {
		return x.InputConfig
	}
	return nil
}

func (m *Image) GetThumbnailUri() string {
	if m != nil {
		return m.ThumbnailUri
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Image) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Image_ImageBytes)(nil),
		(*Image_InputConfig)(nil),
	}
}

// A representation of a text snippet.
type TextSnippet struct {
	// Required. The content of the text snippet as a string. Up to 250000
	// characters long.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. The format of
	// [content][google.cloud.automl.v1beta1.TextSnippet.content]. Currently the
	// only two allowed values are "text/html" and "text/plain". If left blank,
	// the format is automatically determined from the type of the uploaded
	// [content][google.cloud.automl.v1beta1.TextSnippet.content].
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Output only. HTTP URI where you can download the content.
	ContentUri           string   `protobuf:"bytes,4,opt,name=content_uri,json=contentUri,proto3" json:"content_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextSnippet) Reset()         { *m = TextSnippet{} }
func (m *TextSnippet) String() string { return proto.CompactTextString(m) }
func (*TextSnippet) ProtoMessage()    {}
func (*TextSnippet) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{1}
}

func (m *TextSnippet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextSnippet.Unmarshal(m, b)
}
func (m *TextSnippet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextSnippet.Marshal(b, m, deterministic)
}
func (m *TextSnippet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextSnippet.Merge(m, src)
}
func (m *TextSnippet) XXX_Size() int {
	return xxx_messageInfo_TextSnippet.Size(m)
}
func (m *TextSnippet) XXX_DiscardUnknown() {
	xxx_messageInfo_TextSnippet.DiscardUnknown(m)
}

var xxx_messageInfo_TextSnippet proto.InternalMessageInfo

func (m *TextSnippet) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *TextSnippet) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *TextSnippet) GetContentUri() string {
	if m != nil {
		return m.ContentUri
	}
	return ""
}

// Message that describes dimension of a document.
type DocumentDimensions struct {
	// Unit of the dimension.
	Unit DocumentDimensions_DocumentDimensionUnit `protobuf:"varint,1,opt,name=unit,proto3,enum=google.cloud.automl.v1beta1.DocumentDimensions_DocumentDimensionUnit" json:"unit,omitempty"`
	// Width value of the document, works together with the unit.
	Width float32 `protobuf:"fixed32,2,opt,name=width,proto3" json:"width,omitempty"`
	// Height value of the document, works together with the unit.
	Height               float32  `protobuf:"fixed32,3,opt,name=height,proto3" json:"height,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DocumentDimensions) Reset()         { *m = DocumentDimensions{} }
func (m *DocumentDimensions) String() string { return proto.CompactTextString(m) }
func (*DocumentDimensions) ProtoMessage()    {}
func (*DocumentDimensions) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{2}
}

func (m *DocumentDimensions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DocumentDimensions.Unmarshal(m, b)
}
func (m *DocumentDimensions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DocumentDimensions.Marshal(b, m, deterministic)
}
func (m *DocumentDimensions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DocumentDimensions.Merge(m, src)
}
func (m *DocumentDimensions) XXX_Size() int {
	return xxx_messageInfo_DocumentDimensions.Size(m)
}
func (m *DocumentDimensions) XXX_DiscardUnknown() {
	xxx_messageInfo_DocumentDimensions.DiscardUnknown(m)
}

var xxx_messageInfo_DocumentDimensions proto.InternalMessageInfo

func (m *DocumentDimensions) GetUnit() DocumentDimensions_DocumentDimensionUnit {
	if m != nil {
		return m.Unit
	}
	return DocumentDimensions_DOCUMENT_DIMENSION_UNIT_UNSPECIFIED
}

func (m *DocumentDimensions) GetWidth() float32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *DocumentDimensions) GetHeight() float32 {
	if m != nil {
		return m.Height
	}
	return 0
}

// A structured text document e.g. a PDF.
type Document struct {
	// An input config specifying the content of the document.
	InputConfig *DocumentInputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The plain text version of this document.
	DocumentText *TextSnippet `protobuf:"bytes,2,opt,name=document_text,json=documentText,proto3" json:"document_text,omitempty"`
	// Describes the layout of the document.
	// Sorted by [page_number][].
	Layout []*Document_Layout `protobuf:"bytes,3,rep,name=layout,proto3" json:"layout,omitempty"`
	// The dimensions of the page in the document.
	DocumentDimensions *DocumentDimensions `protobuf:"bytes,4,opt,name=document_dimensions,json=documentDimensions,proto3" json:"document_dimensions,omitempty"`
	// Number of pages in the document.
	PageCount            int32    `protobuf:"varint,5,opt,name=page_count,json=pageCount,proto3" json:"page_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document) Reset()         { *m = Document{} }
func (m *Document) String() string { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()    {}
func (*Document) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{3}
}

func (m *Document) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document.Unmarshal(m, b)
}
func (m *Document) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document.Marshal(b, m, deterministic)
}
func (m *Document) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document.Merge(m, src)
}
func (m *Document) XXX_Size() int {
	return xxx_messageInfo_Document.Size(m)
}
func (m *Document) XXX_DiscardUnknown() {
	xxx_messageInfo_Document.DiscardUnknown(m)
}

var xxx_messageInfo_Document proto.InternalMessageInfo

func (m *Document) GetInputConfig() *DocumentInputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *Document) GetDocumentText() *TextSnippet {
	if m != nil {
		return m.DocumentText
	}
	return nil
}

func (m *Document) GetLayout() []*Document_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document) GetDocumentDimensions() *DocumentDimensions {
	if m != nil {
		return m.DocumentDimensions
	}
	return nil
}

func (m *Document) GetPageCount() int32 {
	if m != nil {
		return m.PageCount
	}
	return 0
}

// Describes the layout information of a
// [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment] in
// the document.
type Document_Layout struct {
	// Text Segment that represents a segment in
	// [document_text][google.cloud.automl.v1beta1.Document.document_text].
	TextSegment *TextSegment `protobuf:"bytes,1,opt,name=text_segment,json=textSegment,proto3" json:"text_segment,omitempty"`
	// Page number of the
	// [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment]
	// in the original document, starts from 1.
	PageNumber int32 `protobuf:"varint,2,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// The position of the
	// [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment]
	// in the page. Contains exactly 4
	//
	// [normalized_vertices][google.cloud.automl.v1beta1.BoundingPoly.normalized_vertices]
	// and they are connected by edges in the order provided, which will
	// represent a rectangle parallel to the frame. The
	// [NormalizedVertex-s][google.cloud.automl.v1beta1.NormalizedVertex] are
	// relative to the page.
	// Coordinates are based on top-left as point (0,0).
	BoundingPoly *BoundingPoly `protobuf:"bytes,3,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The type of the
	// [text_segment][google.cloud.automl.v1beta1.Document.Layout.text_segment]
	// in document.
	TextSegmentType      Document_Layout_TextSegmentType `protobuf:"varint,4,opt,name=text_segment_type,json=textSegmentType,proto3,enum=google.cloud.automl.v1beta1.Document_Layout_TextSegmentType" json:"text_segment_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Document_Layout) Reset()         { *m = Document_Layout{} }
func (m *Document_Layout) String() string { return proto.CompactTextString(m) }
func (*Document_Layout) ProtoMessage()    {}
func (*Document_Layout) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{3, 0}
}

func (m *Document_Layout) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Layout.Unmarshal(m, b)
}
func (m *Document_Layout) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Layout.Marshal(b, m, deterministic)
}
func (m *Document_Layout) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Layout.Merge(m, src)
}
func (m *Document_Layout) XXX_Size() int {
	return xxx_messageInfo_Document_Layout.Size(m)
}
func (m *Document_Layout) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Layout.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Layout proto.InternalMessageInfo

func (m *Document_Layout) GetTextSegment() *TextSegment {
	if m != nil {
		return m.TextSegment
	}
	return nil
}

func (m *Document_Layout) GetPageNumber() int32 {
	if m != nil {
		return m.PageNumber
	}
	return 0
}

func (m *Document_Layout) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *Document_Layout) GetTextSegmentType() Document_Layout_TextSegmentType {
	if m != nil {
		return m.TextSegmentType
	}
	return Document_Layout_TEXT_SEGMENT_TYPE_UNSPECIFIED
}

// A representation of a row in a relational table.
type Row struct {
	// The resource IDs of the column specs describing the columns of the row.
	// If set must contain, but possibly in a different order, all input
	// feature
	//
	// [column_spec_ids][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
	// of the Model this row is being passed to.
	// Note: The below `values` field must match order of this field, if this
	// field is set.
	ColumnSpecIds []string `protobuf:"bytes,2,rep,name=column_spec_ids,json=columnSpecIds,proto3" json:"column_spec_ids,omitempty"`
	// Required. The values of the row cells, given in the same order as the
	// column_spec_ids, or, if not set, then in the same order as input
	// feature
	//
	// [column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
	// of the Model this row is being passed to.
	Values               []*_struct.Value `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Row) Reset()         { *m = Row{} }
func (m *Row) String() string { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()    {}
func (*Row) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{4}
}

func (m *Row) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Row.Unmarshal(m, b)
}
func (m *Row) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Row.Marshal(b, m, deterministic)
}
func (m *Row) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Row.Merge(m, src)
}
func (m *Row) XXX_Size() int {
	return xxx_messageInfo_Row.Size(m)
}
func (m *Row) XXX_DiscardUnknown() {
	xxx_messageInfo_Row.DiscardUnknown(m)
}

var xxx_messageInfo_Row proto.InternalMessageInfo

func (m *Row) GetColumnSpecIds() []string {
	if m != nil {
		return m.ColumnSpecIds
	}
	return nil
}

func (m *Row) GetValues() []*_struct.Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// Example data used for training or prediction.
type ExamplePayload struct {
	// Required. Input only. The example data.
	//
	// Types that are valid to be assigned to Payload:
	//	*ExamplePayload_Image
	//	*ExamplePayload_TextSnippet
	//	*ExamplePayload_Document
	//	*ExamplePayload_Row
	Payload              isExamplePayload_Payload `protobuf_oneof:"payload"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ExamplePayload) Reset()         { *m = ExamplePayload{} }
func (m *ExamplePayload) String() string { return proto.CompactTextString(m) }
func (*ExamplePayload) ProtoMessage()    {}
func (*ExamplePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd1fd4e23d5f1ca3, []int{5}
}

func (m *ExamplePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExamplePayload.Unmarshal(m, b)
}
func (m *ExamplePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExamplePayload.Marshal(b, m, deterministic)
}
func (m *ExamplePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExamplePayload.Merge(m, src)
}
func (m *ExamplePayload) XXX_Size() int {
	return xxx_messageInfo_ExamplePayload.Size(m)
}
func (m *ExamplePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ExamplePayload.DiscardUnknown(m)
}

var xxx_messageInfo_ExamplePayload proto.InternalMessageInfo

type isExamplePayload_Payload interface {
	isExamplePayload_Payload()
}

type ExamplePayload_Image struct {
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3,oneof"`
}

type ExamplePayload_TextSnippet struct {
	TextSnippet *TextSnippet `protobuf:"bytes,2,opt,name=text_snippet,json=textSnippet,proto3,oneof"`
}

type ExamplePayload_Document struct {
	Document *Document `protobuf:"bytes,4,opt,name=document,proto3,oneof"`
}

type ExamplePayload_Row struct {
	Row *Row `protobuf:"bytes,3,opt,name=row,proto3,oneof"`
}

func (*ExamplePayload_Image) isExamplePayload_Payload() {}

func (*ExamplePayload_TextSnippet) isExamplePayload_Payload() {}

func (*ExamplePayload_Document) isExamplePayload_Payload() {}

func (*ExamplePayload_Row) isExamplePayload_Payload() {}

func (m *ExamplePayload) GetPayload() isExamplePayload_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *ExamplePayload) GetImage() *Image {
	if x, ok := m.GetPayload().(*ExamplePayload_Image); ok {
		return x.Image
	}
	return nil
}

func (m *ExamplePayload) GetTextSnippet() *TextSnippet {
	if x, ok := m.GetPayload().(*ExamplePayload_TextSnippet); ok {
		return x.TextSnippet
	}
	return nil
}

func (m *ExamplePayload) GetDocument() *Document {
	if x, ok := m.GetPayload().(*ExamplePayload_Document); ok {
		return x.Document
	}
	return nil
}

func (m *ExamplePayload) GetRow() *Row {
	if x, ok := m.GetPayload().(*ExamplePayload_Row); ok {
		return x.Row
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExamplePayload) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExamplePayload_Image)(nil),
		(*ExamplePayload_TextSnippet)(nil),
		(*ExamplePayload_Document)(nil),
		(*ExamplePayload_Row)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.automl.v1beta1.DocumentDimensions_DocumentDimensionUnit", DocumentDimensions_DocumentDimensionUnit_name, DocumentDimensions_DocumentDimensionUnit_value)
	proto.RegisterEnum("google.cloud.automl.v1beta1.Document_Layout_TextSegmentType", Document_Layout_TextSegmentType_name, Document_Layout_TextSegmentType_value)
	proto.RegisterType((*Image)(nil), "google.cloud.automl.v1beta1.Image")
	proto.RegisterType((*TextSnippet)(nil), "google.cloud.automl.v1beta1.TextSnippet")
	proto.RegisterType((*DocumentDimensions)(nil), "google.cloud.automl.v1beta1.DocumentDimensions")
	proto.RegisterType((*Document)(nil), "google.cloud.automl.v1beta1.Document")
	proto.RegisterType((*Document_Layout)(nil), "google.cloud.automl.v1beta1.Document.Layout")
	proto.RegisterType((*Row)(nil), "google.cloud.automl.v1beta1.Row")
	proto.RegisterType((*ExamplePayload)(nil), "google.cloud.automl.v1beta1.ExamplePayload")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1beta1/data_items.proto", fileDescriptor_bd1fd4e23d5f1ca3)
}

var fileDescriptor_bd1fd4e23d5f1ca3 = []byte{
	// 1030 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0x4b, 0x73, 0xe3, 0x44,
	0x10, 0xb6, 0xfc, 0xda, 0xb8, 0xed, 0x6c, 0xc4, 0x04, 0x16, 0x93, 0xec, 0xc3, 0xeb, 0xe5, 0x61,
	0xa8, 0x2d, 0x9b, 0x0d, 0x9c, 0x0c, 0x17, 0x3f, 0x94, 0x58, 0xb5, 0xb6, 0xec, 0x1a, 0xcb, 0x0b,
	0x4b, 0x85, 0x12, 0xb2, 0x3d, 0xab, 0x4c, 0x95, 0xa4, 0x51, 0xd9, 0xa3, 0x4d, 0x7c, 0xe7, 0x8f,
	0x70, 0x80, 0xdf, 0x42, 0xf1, 0x53, 0xb8, 0x72, 0xe4, 0x42, 0xcd, 0x68, 0x9c, 0x78, 0x93, 0x2d,
	0x93, 0xdc, 0xd4, 0x5f, 0x7f, 0x3d, 0xdd, 0xea, 0xfe, 0x7a, 0x06, 0x9e, 0x7b, 0x8c, 0x79, 0x3e,
	0x69, 0xcc, 0x7c, 0x16, 0xcf, 0x1b, 0x6e, 0xcc, 0x59, 0xe0, 0x37, 0xde, 0xbe, 0x98, 0x12, 0xee,
	0xbe, 0x68, 0xcc, 0x5d, 0xee, 0x3a, 0x94, 0x93, 0x60, 0x59, 0x8f, 0x16, 0x8c, 0x33, 0x74, 0x98,
	0xb0, 0xeb, 0x92, 0x5d, 0x4f, 0xd8, 0x75, 0xc5, 0x3e, 0x78, 0xa8, 0x8e, 0x72, 0x23, 0xda, 0x70,
	0xc3, 0x90, 0x71, 0x97, 0x53, 0x16, 0xaa, 0xd0, 0x83, 0xaf, 0xb6, 0x25, 0xf2, 0x08, 0x0b, 0x08,
	0x5f, 0xac, 0x14, 0xf7, 0xd3, 0x6d, 0x5c, 0xca, 0x14, 0xab, 0xbe, 0x8d, 0xc5, 0xc9, 0x05, 0x77,
	0x96, 0xc4, 0x0b, 0x48, 0xc8, 0x15, 0xff, 0x13, 0xc5, 0x97, 0xd6, 0x34, 0x7e, 0xd3, 0x70, 0xc3,
	0x75, 0xc2, 0xc7, 0xd7, 0x5d, 0xf3, 0x78, 0x21, 0xab, 0x57, 0xfe, 0x87, 0xd7, 0xfd, 0x4b, 0xbe,
	0x88, 0x67, 0xea, 0xe0, 0xea, 0x1f, 0x1a, 0xe4, 0xcc, 0xc0, 0xf5, 0x08, 0x7a, 0x0a, 0x45, 0x2a,
	0x3e, 0x9c, 0xe9, 0x8a, 0x93, 0x65, 0x59, 0xab, 0x68, 0xb5, 0x52, 0x2f, 0x85, 0x41, 0x82, 0x6d,
	0x81, 0xa1, 0x01, 0x94, 0x68, 0x18, 0xc5, 0xdc, 0x99, 0xb1, 0xf0, 0x0d, 0xf5, 0xca, 0xf9, 0x8a,
	0x56, 0x2b, 0x1e, 0xd5, 0xea, 0x5b, 0x3a, 0x5b, 0x37, 0x45, 0x40, 0x47, 0xf2, 0x7b, 0x29, 0x5c,
	0xa4, 0x57, 0x26, 0x7a, 0x06, 0xbb, 0xfc, 0x2c, 0x0e, 0xa6, 0xa1, 0x4b, 0x7d, 0x27, 0x5e, 0xd0,
	0x72, 0xb6, 0xa2, 0xd5, 0x0a, 0xb8, 0x74, 0x09, 0x4e, 0x16, 0xb4, 0x9d, 0x87, 0xac, 0x18, 0x65,
	0x95, 0x40, 0xd1, 0x26, 0x17, 0x7c, 0x1c, 0xd2, 0x28, 0x22, 0x1c, 0x95, 0xe1, 0xde, 0x8c, 0x85,
	0x9c, 0x84, 0x5c, 0x56, 0x5a, 0xc0, 0x6b, 0x13, 0x1d, 0x42, 0x21, 0xa0, 0x01, 0x71, 0xf8, 0x2a,
	0x22, 0xe5, 0xb4, 0xf4, 0xed, 0x08, 0xc0, 0x5e, 0x45, 0x04, 0x3d, 0x81, 0xa2, 0xe2, 0x6d, 0x24,
	0x04, 0x05, 0x4d, 0x16, 0xb4, 0xfa, 0x6b, 0x1a, 0x50, 0x97, 0xcd, 0x62, 0xd1, 0xfb, 0x2e, 0x0d,
	0x48, 0xb8, 0x14, 0x3a, 0x40, 0xaf, 0x21, 0x1b, 0x87, 0x34, 0xc9, 0x75, 0xff, 0xc8, 0xd8, 0xfa,
	0xc7, 0x37, 0xc3, 0x6f, 0x42, 0x93, 0x90, 0x72, 0x2c, 0x8f, 0x44, 0x1f, 0x42, 0xee, 0x9c, 0xce,
	0xf9, 0x99, 0xac, 0x35, 0x8d, 0x13, 0x03, 0x3d, 0x80, 0xfc, 0x19, 0xa1, 0xde, 0x19, 0x2f, 0x67,
	0x24, 0xac, 0xac, 0x2a, 0x81, 0x8f, 0xde, 0x7b, 0x18, 0xfa, 0x02, 0x9e, 0x75, 0x87, 0x9d, 0xc9,
	0xc0, 0xb0, 0x6c, 0xa7, 0x6b, 0x0e, 0x0c, 0x6b, 0x6c, 0x0e, 0x2d, 0x67, 0x62, 0x99, 0xb6, 0x33,
	0xb1, 0xc6, 0x23, 0xa3, 0x63, 0x1e, 0x9b, 0x46, 0x57, 0x4f, 0xa1, 0x1d, 0xc8, 0x9a, 0x56, 0xa7,
	0xa7, 0x6b, 0xe8, 0x3e, 0x40, 0xc7, 0xb0, 0x6c, 0x73, 0x60, 0xd8, 0x06, 0xd6, 0xd3, 0xa8, 0x00,
	0xb9, 0xd1, 0xd0, 0xb4, 0x6c, 0x3d, 0x53, 0xfd, 0x27, 0x0f, 0x3b, 0xeb, 0x3c, 0x68, 0x7c, 0x6d,
	0xec, 0x9a, 0x1c, 0xfb, 0xd7, 0xb7, 0x6a, 0xc2, 0xc6, 0xf8, 0xdf, 0x1d, 0xfe, 0x00, 0x76, 0xe7,
	0x8a, 0xe3, 0x08, 0xc1, 0xcb, 0xdf, 0xff, 0x3f, 0x31, 0x6d, 0x28, 0x00, 0x97, 0xd6, 0xe1, 0x02,
	0x44, 0x5d, 0xc8, 0xfb, 0xee, 0x8a, 0xc5, 0xa2, 0x5f, 0x99, 0x5a, 0xf1, 0xe8, 0xf9, 0xad, 0xaa,
	0xab, 0xf7, 0x65, 0x0c, 0x56, 0xb1, 0xe8, 0x17, 0xd8, 0xbf, 0x2c, 0x6a, 0x7e, 0x39, 0x3e, 0x29,
	0x93, 0xe2, 0x51, 0xe3, 0x8e, 0x53, 0xc7, 0x68, 0x7e, 0x53, 0x48, 0x8f, 0x00, 0x22, 0xb1, 0x64,
	0x33, 0x16, 0x87, 0xbc, 0x9c, 0xab, 0x68, 0xb5, 0x1c, 0x2e, 0x08, 0xa4, 0x23, 0x80, 0x83, 0x7f,
	0x33, 0x90, 0x4f, 0x6a, 0x42, 0x2f, 0xa1, 0xb4, 0x79, 0x11, 0xa8, 0xae, 0xdf, 0xa2, 0x3f, 0x09,
	0x1f, 0x17, 0xf9, 0x95, 0x21, 0x74, 0x2f, 0xd3, 0x86, 0x71, 0x30, 0x25, 0x0b, 0xd9, 0xeb, 0x1c,
	0x96, 0x95, 0x58, 0x12, 0x41, 0x16, 0xec, 0x4e, 0x59, 0x1c, 0xce, 0x69, 0xe8, 0x39, 0x11, 0xf3,
	0x57, 0x52, 0x76, 0xc5, 0xa3, 0x2f, 0xb7, 0xa6, 0x6b, 0xab, 0x88, 0x11, 0xf3, 0x57, 0xb8, 0x34,
	0xdd, 0xb0, 0xd0, 0x19, 0x7c, 0xb0, 0x59, 0x7d, 0xb2, 0x8d, 0x59, 0xb9, 0x3d, 0xdf, 0xdf, 0x65,
	0x34, 0x9b, 0xbf, 0x24, 0x36, 0x18, 0xef, 0xf1, 0x77, 0x81, 0xea, 0x9f, 0x1a, 0xec, 0x5d, 0x23,
	0xa1, 0xa7, 0xf0, 0xc8, 0x36, 0x7e, 0xb4, 0x9d, 0xb1, 0x71, 0x22, 0x17, 0xc2, 0x7e, 0x3d, 0x32,
	0xae, 0xad, 0x41, 0x01, 0x72, 0xf6, 0xf0, 0xa5, 0x61, 0xe9, 0x1a, 0xda, 0x85, 0xc2, 0xa8, 0x85,
	0x5b, 0x27, 0xb8, 0x35, 0xea, 0xe9, 0x69, 0xb1, 0x16, 0xc7, 0x43, 0x3c, 0x70, 0x8e, 0x4d, 0xa3,
	0xdf, 0xd5, 0x33, 0x68, 0x1f, 0xf6, 0xae, 0x6c, 0xc7, 0x6a, 0x0d, 0x0c, 0x3d, 0x8b, 0x3e, 0x86,
	0xfd, 0x0d, 0xb0, 0x33, 0xb4, 0x6c, 0xc3, 0xb2, 0xc7, 0x7a, 0x4e, 0x9e, 0xdb, 0x6a, 0xf7, 0x0d,
	0x3d, 0x8f, 0x74, 0x28, 0xc9, 0x4f, 0xa7, 0x67, 0xb4, 0xba, 0x06, 0xd6, 0xef, 0x89, 0x4c, 0x09,
	0x82, 0x87, 0x3f, 0xe8, 0x3b, 0x22, 0x53, 0x62, 0x76, 0x8c, 0x7e, 0x5f, 0x2f, 0x54, 0x7f, 0x86,
	0x0c, 0x66, 0xe7, 0xe8, 0x73, 0xd8, 0x9b, 0x31, 0x3f, 0x0e, 0x42, 0x67, 0x19, 0x91, 0x99, 0x43,
	0xe7, 0xcb, 0x72, 0xba, 0x92, 0xa9, 0x15, 0xf0, 0x6e, 0x02, 0x8f, 0x23, 0x32, 0x33, 0xe7, 0x4b,
	0x54, 0x87, 0xfc, 0x5b, 0xd7, 0x8f, 0xc9, 0x52, 0x69, 0xfe, 0xc1, 0xba, 0xb1, 0xeb, 0xab, 0xbe,
	0xfe, 0x4a, 0xb8, 0xb1, 0x62, 0x55, 0x7f, 0x4b, 0xc3, 0x7d, 0xe3, 0xc2, 0x0d, 0x22, 0x9f, 0x8c,
	0xdc, 0x95, 0xcf, 0xdc, 0x39, 0x6a, 0x42, 0x4e, 0xde, 0xef, 0x4a, 0x5d, 0xd5, 0xed, 0x57, 0xb9,
	0x60, 0xf6, 0x52, 0x38, 0x09, 0x11, 0xaf, 0x41, 0x32, 0xe2, 0x64, 0x21, 0xef, 0xba, 0xc0, 0xe2,
	0x35, 0xe0, 0x1b, 0x37, 0x7a, 0x07, 0x76, 0xd6, 0xfb, 0xa2, 0x16, 0xee, 0xb3, 0x5b, 0x09, 0xa5,
	0x97, 0xc2, 0x97, 0x81, 0xe8, 0x5b, 0xc8, 0x2c, 0xd8, 0xb9, 0x12, 0x6f, 0x65, 0x6b, 0x3c, 0x66,
	0xe7, 0xbd, 0x14, 0x16, 0xf4, 0x76, 0x01, 0xee, 0x45, 0x49, 0x43, 0xda, 0xbf, 0x6b, 0xf0, 0x64,
	0xc6, 0x82, 0x6d, 0x91, 0x23, 0xed, 0xa7, 0x96, 0x72, 0x7b, 0xcc, 0x77, 0x43, 0xaf, 0xce, 0x16,
	0x5e, 0xc3, 0x23, 0xa1, 0x6c, 0x7b, 0x23, 0x71, 0xb9, 0x11, 0x5d, 0xbe, 0xf7, 0x75, 0xff, 0x2e,
	0x31, 0xff, 0x4a, 0x1f, 0x9e, 0x48, 0xe2, 0x69, 0x47, 0x90, 0x4e, 0x5b, 0x31, 0x67, 0x03, 0xff,
	0xf4, 0x55, 0x42, 0xfa, 0x3b, 0xfd, 0x38, 0xf1, 0x36, 0x9b, 0xd2, 0xdd, 0x6c, 0x4a, 0x7f, 0xbf,
	0xd9, 0x54, 0x84, 0x69, 0x5e, 0x26, 0xfb, 0xe6, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x77, 0xbf,
	0xea, 0x65, 0x04, 0x09, 0x00, 0x00,
}
