// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/pubsub/v1beta2/pubsub.proto

package pubsub

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A topic resource.
type Topic struct {
	// Name of the topic.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Topic) Reset()         { *m = Topic{} }
func (m *Topic) String() string { return proto.CompactTextString(m) }
func (*Topic) ProtoMessage()    {}
func (*Topic) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{0}
}

func (m *Topic) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Topic.Unmarshal(m, b)
}
func (m *Topic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Topic.Marshal(b, m, deterministic)
}
func (m *Topic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Topic.Merge(m, src)
}
func (m *Topic) XXX_Size() int {
	return xxx_messageInfo_Topic.Size(m)
}
func (m *Topic) XXX_DiscardUnknown() {
	xxx_messageInfo_Topic.DiscardUnknown(m)
}

var xxx_messageInfo_Topic proto.InternalMessageInfo

func (m *Topic) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A message data and its attributes.
type PubsubMessage struct {
	// The message payload. For JSON requests, the value of this field must be
	// base64-encoded.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes for this message.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of this message assigned by the server at publication time. Guaranteed
	// to be unique within the topic. This value may be read by a subscriber
	// that receives a PubsubMessage via a Pull call or a push delivery. It must
	// not be populated by a publisher in a Publish call.
	MessageId            string   `protobuf:"bytes,3,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PubsubMessage) Reset()         { *m = PubsubMessage{} }
func (m *PubsubMessage) String() string { return proto.CompactTextString(m) }
func (*PubsubMessage) ProtoMessage()    {}
func (*PubsubMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{1}
}

func (m *PubsubMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PubsubMessage.Unmarshal(m, b)
}
func (m *PubsubMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PubsubMessage.Marshal(b, m, deterministic)
}
func (m *PubsubMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PubsubMessage.Merge(m, src)
}
func (m *PubsubMessage) XXX_Size() int {
	return xxx_messageInfo_PubsubMessage.Size(m)
}
func (m *PubsubMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_PubsubMessage.DiscardUnknown(m)
}

var xxx_messageInfo_PubsubMessage proto.InternalMessageInfo

func (m *PubsubMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PubsubMessage) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *PubsubMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	// The name of the topic to get.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTopicRequest) Reset()         { *m = GetTopicRequest{} }
func (m *GetTopicRequest) String() string { return proto.CompactTextString(m) }
func (*GetTopicRequest) ProtoMessage()    {}
func (*GetTopicRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{2}
}

func (m *GetTopicRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTopicRequest.Unmarshal(m, b)
}
func (m *GetTopicRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTopicRequest.Marshal(b, m, deterministic)
}
func (m *GetTopicRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTopicRequest.Merge(m, src)
}
func (m *GetTopicRequest) XXX_Size() int {
	return xxx_messageInfo_GetTopicRequest.Size(m)
}
func (m *GetTopicRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTopicRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTopicRequest proto.InternalMessageInfo

func (m *GetTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Request for the Publish method.
type PublishRequest struct {
	// The messages in the request will be published on this topic.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// The messages to publish.
	Messages             []*PubsubMessage `protobuf:"bytes,2,rep,name=messages,proto3" json:"messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PublishRequest) Reset()         { *m = PublishRequest{} }
func (m *PublishRequest) String() string { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()    {}
func (*PublishRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{3}
}

func (m *PublishRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishRequest.Unmarshal(m, b)
}
func (m *PublishRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishRequest.Marshal(b, m, deterministic)
}
func (m *PublishRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishRequest.Merge(m, src)
}
func (m *PublishRequest) XXX_Size() int {
	return xxx_messageInfo_PublishRequest.Size(m)
}
func (m *PublishRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PublishRequest proto.InternalMessageInfo

func (m *PublishRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *PublishRequest) GetMessages() []*PubsubMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

// Response for the Publish method.
type PublishResponse struct {
	// The server-assigned ID of each published message, in the same order as
	// the messages in the request. IDs are guaranteed to be unique within
	// the topic.
	MessageIds           []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds,proto3" json:"message_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublishResponse) Reset()         { *m = PublishResponse{} }
func (m *PublishResponse) String() string { return proto.CompactTextString(m) }
func (*PublishResponse) ProtoMessage()    {}
func (*PublishResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{4}
}

func (m *PublishResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishResponse.Unmarshal(m, b)
}
func (m *PublishResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishResponse.Marshal(b, m, deterministic)
}
func (m *PublishResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishResponse.Merge(m, src)
}
func (m *PublishResponse) XXX_Size() int {
	return xxx_messageInfo_PublishResponse.Size(m)
}
func (m *PublishResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PublishResponse proto.InternalMessageInfo

func (m *PublishResponse) GetMessageIds() []string {
	if m != nil {
		return m.MessageIds
	}
	return nil
}

// Request for the ListTopics method.
type ListTopicsRequest struct {
	// The name of the cloud project that topics belong to.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last ListTopicsResponse; indicates that this is
	// a continuation of a prior ListTopics call, and that the system should
	// return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicsRequest) Reset()         { *m = ListTopicsRequest{} }
func (m *ListTopicsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTopicsRequest) ProtoMessage()    {}
func (*ListTopicsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{5}
}

func (m *ListTopicsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicsRequest.Unmarshal(m, b)
}
func (m *ListTopicsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicsRequest.Marshal(b, m, deterministic)
}
func (m *ListTopicsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicsRequest.Merge(m, src)
}
func (m *ListTopicsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTopicsRequest.Size(m)
}
func (m *ListTopicsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicsRequest proto.InternalMessageInfo

func (m *ListTopicsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListTopicsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListTopics method.
type ListTopicsResponse struct {
	// The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics,proto3" json:"topics,omitempty"`
	// If not empty, indicates that there may be more topics that match the
	// request; this value should be passed in a new ListTopicsRequest.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicsResponse) Reset()         { *m = ListTopicsResponse{} }
func (m *ListTopicsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTopicsResponse) ProtoMessage()    {}
func (*ListTopicsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{6}
}

func (m *ListTopicsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicsResponse.Unmarshal(m, b)
}
func (m *ListTopicsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicsResponse.Marshal(b, m, deterministic)
}
func (m *ListTopicsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicsResponse.Merge(m, src)
}
func (m *ListTopicsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTopicsResponse.Size(m)
}
func (m *ListTopicsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicsResponse proto.InternalMessageInfo

func (m *ListTopicsResponse) GetTopics() []*Topic {
	if m != nil {
		return m.Topics
	}
	return nil
}

func (m *ListTopicsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the ListTopicSubscriptions method.
type ListTopicSubscriptionsRequest struct {
	// The name of the topic that subscriptions are attached to.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last ListTopicSubscriptionsResponse; indicates
	// that this is a continuation of a prior ListTopicSubscriptions call, and
	// that the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicSubscriptionsRequest) Reset()         { *m = ListTopicSubscriptionsRequest{} }
func (m *ListTopicSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsRequest) ProtoMessage()    {}
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{7}
}

func (m *ListTopicSubscriptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicSubscriptionsRequest.Unmarshal(m, b)
}
func (m *ListTopicSubscriptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicSubscriptionsRequest.Marshal(b, m, deterministic)
}
func (m *ListTopicSubscriptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicSubscriptionsRequest.Merge(m, src)
}
func (m *ListTopicSubscriptionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTopicSubscriptionsRequest.Size(m)
}
func (m *ListTopicSubscriptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicSubscriptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicSubscriptionsRequest proto.InternalMessageInfo

func (m *ListTopicSubscriptionsRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *ListTopicSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListTopicSubscriptions method.
type ListTopicSubscriptionsResponse struct {
	// The names of the subscriptions that match the request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// ListTopicSubscriptionsRequest to get more subscriptions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicSubscriptionsResponse) Reset()         { *m = ListTopicSubscriptionsResponse{} }
func (m *ListTopicSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsResponse) ProtoMessage()    {}
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{8}
}

func (m *ListTopicSubscriptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicSubscriptionsResponse.Unmarshal(m, b)
}
func (m *ListTopicSubscriptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicSubscriptionsResponse.Marshal(b, m, deterministic)
}
func (m *ListTopicSubscriptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicSubscriptionsResponse.Merge(m, src)
}
func (m *ListTopicSubscriptionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTopicSubscriptionsResponse.Size(m)
}
func (m *ListTopicSubscriptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicSubscriptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicSubscriptionsResponse proto.InternalMessageInfo

func (m *ListTopicSubscriptionsResponse) GetSubscriptions() []string {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListTopicSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the DeleteTopic method.
type DeleteTopicRequest struct {
	// Name of the topic to delete.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTopicRequest) Reset()         { *m = DeleteTopicRequest{} }
func (m *DeleteTopicRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTopicRequest) ProtoMessage()    {}
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{9}
}

func (m *DeleteTopicRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTopicRequest.Unmarshal(m, b)
}
func (m *DeleteTopicRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTopicRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTopicRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTopicRequest.Merge(m, src)
}
func (m *DeleteTopicRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTopicRequest.Size(m)
}
func (m *DeleteTopicRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTopicRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTopicRequest proto.InternalMessageInfo

func (m *DeleteTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// A subscription resource.
type Subscription struct {
	// Name of the subscription.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the topic from which this subscription is receiving messages.
	// This will be present if and only if the subscription has not been detached
	// from its topic.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// If push delivery is used with this subscription, this field is
	// used to configure it. An empty pushConfig signifies that the subscriber
	// will pull and ack messages using API methods.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
	// This value is the maximum time after a subscriber receives a message
	// before the subscriber should acknowledge the message. After message
	// delivery but before the ack deadline expires and before the message is
	// acknowledged, it is an outstanding message and will not be delivered
	// again during that time (on a best-effort basis).
	//
	// For pull delivery this value
	// is used as the initial value for the ack deadline. It may be overridden
	// for a specific message by calling ModifyAckDeadline.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds   int32    `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{10}
}

func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (m *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(m, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Subscription) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

func (m *Subscription) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	// A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use "https://example.com/push".
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint,proto3" json:"push_endpoint,omitempty"`
	// Endpoint configuration attributes.
	//
	// Every endpoint has a set of API supported attributes that can be used to
	// control different aspects of the message delivery.
	//
	// The currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the push message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the envelope (i.e. its fields and metadata).
	// The endpoint version is based on the version of the Pub/Sub
	// API.
	//
	// If not present during the CreateSubscription call, it will default to
	// the version of the API used to make such call. If not present during a
	// ModifyPushConfig call, its value will not be changed. GetSubscription
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The possible values for this attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1beta2`: uses the push format defined in the v1beta2 Pub/Sub API.
	//
	Attributes           map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PushConfig) Reset()         { *m = PushConfig{} }
func (m *PushConfig) String() string { return proto.CompactTextString(m) }
func (*PushConfig) ProtoMessage()    {}
func (*PushConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{11}
}

func (m *PushConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PushConfig.Unmarshal(m, b)
}
func (m *PushConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PushConfig.Marshal(b, m, deterministic)
}
func (m *PushConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushConfig.Merge(m, src)
}
func (m *PushConfig) XXX_Size() int {
	return xxx_messageInfo_PushConfig.Size(m)
}
func (m *PushConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PushConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PushConfig proto.InternalMessageInfo

func (m *PushConfig) GetPushEndpoint() string {
	if m != nil {
		return m.PushEndpoint
	}
	return ""
}

func (m *PushConfig) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	// This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId,proto3" json:"ack_id,omitempty"`
	// The message.
	Message              *PubsubMessage `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ReceivedMessage) Reset()         { *m = ReceivedMessage{} }
func (m *ReceivedMessage) String() string { return proto.CompactTextString(m) }
func (*ReceivedMessage) ProtoMessage()    {}
func (*ReceivedMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{12}
}

func (m *ReceivedMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceivedMessage.Unmarshal(m, b)
}
func (m *ReceivedMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceivedMessage.Marshal(b, m, deterministic)
}
func (m *ReceivedMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceivedMessage.Merge(m, src)
}
func (m *ReceivedMessage) XXX_Size() int {
	return xxx_messageInfo_ReceivedMessage.Size(m)
}
func (m *ReceivedMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceivedMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ReceivedMessage proto.InternalMessageInfo

func (m *ReceivedMessage) GetAckId() string {
	if m != nil {
		return m.AckId
	}
	return ""
}

func (m *ReceivedMessage) GetMessage() *PubsubMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	// The name of the subscription to get.
	Subscription         string   `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSubscriptionRequest) Reset()         { *m = GetSubscriptionRequest{} }
func (m *GetSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSubscriptionRequest) ProtoMessage()    {}
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{13}
}

func (m *GetSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSubscriptionRequest.Unmarshal(m, b)
}
func (m *GetSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSubscriptionRequest.Marshal(b, m, deterministic)
}
func (m *GetSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSubscriptionRequest.Merge(m, src)
}
func (m *GetSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSubscriptionRequest.Size(m)
}
func (m *GetSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSubscriptionRequest proto.InternalMessageInfo

func (m *GetSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the ListSubscriptions method.
type ListSubscriptionsRequest struct {
	// The name of the cloud project that subscriptions belong to.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last ListSubscriptionsResponse; indicates that
	// this is a continuation of a prior ListSubscriptions call, and that the
	// system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubscriptionsRequest) Reset()         { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()    {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{14}
}

func (m *ListSubscriptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubscriptionsRequest.Unmarshal(m, b)
}
func (m *ListSubscriptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubscriptionsRequest.Marshal(b, m, deterministic)
}
func (m *ListSubscriptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubscriptionsRequest.Merge(m, src)
}
func (m *ListSubscriptionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSubscriptionsRequest.Size(m)
}
func (m *ListSubscriptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubscriptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubscriptionsRequest proto.InternalMessageInfo

func (m *ListSubscriptionsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListSubscriptions method.
type ListSubscriptionsResponse struct {
	// The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new ListSubscriptionsRequest
	// to get more subscriptions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubscriptionsResponse) Reset()         { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()    {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{15}
}

func (m *ListSubscriptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubscriptionsResponse.Unmarshal(m, b)
}
func (m *ListSubscriptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubscriptionsResponse.Marshal(b, m, deterministic)
}
func (m *ListSubscriptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubscriptionsResponse.Merge(m, src)
}
func (m *ListSubscriptionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSubscriptionsResponse.Size(m)
}
func (m *ListSubscriptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubscriptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubscriptionsResponse proto.InternalMessageInfo

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	// The subscription to delete.
	Subscription         string   `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSubscriptionRequest) Reset()         { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()    {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{16}
}

func (m *DeleteSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSubscriptionRequest.Unmarshal(m, b)
}
func (m *DeleteSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSubscriptionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSubscriptionRequest.Merge(m, src)
}
func (m *DeleteSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSubscriptionRequest.Size(m)
}
func (m *DeleteSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSubscriptionRequest proto.InternalMessageInfo

func (m *DeleteSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The push configuration for future deliveries.
	//
	// An empty pushConfig indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if Pull is not called.
	PushConfig           *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ModifyPushConfigRequest) Reset()         { *m = ModifyPushConfigRequest{} }
func (m *ModifyPushConfigRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyPushConfigRequest) ProtoMessage()    {}
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{17}
}

func (m *ModifyPushConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyPushConfigRequest.Unmarshal(m, b)
}
func (m *ModifyPushConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyPushConfigRequest.Marshal(b, m, deterministic)
}
func (m *ModifyPushConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyPushConfigRequest.Merge(m, src)
}
func (m *ModifyPushConfigRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyPushConfigRequest.Size(m)
}
func (m *ModifyPushConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyPushConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyPushConfigRequest proto.InternalMessageInfo

func (m *ModifyPushConfigRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Request for the Pull method.
type PullRequest struct {
	// The subscription from which messages should be pulled.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// If this is specified as true the system will respond immediately even if
	// it is not able to return a message in the Pull response. Otherwise the
	// system is allowed to wait until at least one message is available rather
	// than returning no messages. The client may cancel the request if it does
	// not wish to wait any longer for the response.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately,proto3" json:"return_immediately,omitempty"`
	// The maximum number of messages returned for this request. The Pub/Sub
	// system may return fewer than the number specified.
	MaxMessages          int32    `protobuf:"varint,3,opt,name=max_messages,json=maxMessages,proto3" json:"max_messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PullRequest) Reset()         { *m = PullRequest{} }
func (m *PullRequest) String() string { return proto.CompactTextString(m) }
func (*PullRequest) ProtoMessage()    {}
func (*PullRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{18}
}

func (m *PullRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullRequest.Unmarshal(m, b)
}
func (m *PullRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullRequest.Marshal(b, m, deterministic)
}
func (m *PullRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullRequest.Merge(m, src)
}
func (m *PullRequest) XXX_Size() int {
	return xxx_messageInfo_PullRequest.Size(m)
}
func (m *PullRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PullRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PullRequest proto.InternalMessageInfo

func (m *PullRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *PullRequest) GetReturnImmediately() bool {
	if m != nil {
		return m.ReturnImmediately
	}
	return false
}

func (m *PullRequest) GetMaxMessages() int32 {
	if m != nil {
		return m.MaxMessages
	}
	return 0
}

// Response for the Pull method.
type PullResponse struct {
	// Received Pub/Sub messages. The Pub/Sub system will return zero messages if
	// there are no more available in the backlog. The Pub/Sub system may return
	// fewer than the maxMessages requested even if there are more messages
	// available in the backlog.
	ReceivedMessages     []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages,proto3" json:"received_messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PullResponse) Reset()         { *m = PullResponse{} }
func (m *PullResponse) String() string { return proto.CompactTextString(m) }
func (*PullResponse) ProtoMessage()    {}
func (*PullResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{19}
}

func (m *PullResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullResponse.Unmarshal(m, b)
}
func (m *PullResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullResponse.Marshal(b, m, deterministic)
}
func (m *PullResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullResponse.Merge(m, src)
}
func (m *PullResponse) XXX_Size() int {
	return xxx_messageInfo_PullResponse.Size(m)
}
func (m *PullResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PullResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PullResponse proto.InternalMessageInfo

func (m *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The acknowledgment ID.
	AckId string `protobuf:"bytes,2,opt,name=ack_id,json=ackId,proto3" json:"ack_id,omitempty"`
	// The new ack deadline with respect to the time this request was sent to the
	// Pub/Sub system. Must be >= 0. For example, if the value is 10, the new ack
	// deadline will expire 10 seconds after the ModifyAckDeadline call was made.
	// Specifying zero may immediately make the message available for another pull
	// request.
	AckDeadlineSeconds   int32    `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ModifyAckDeadlineRequest) Reset()         { *m = ModifyAckDeadlineRequest{} }
func (m *ModifyAckDeadlineRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyAckDeadlineRequest) ProtoMessage()    {}
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{20}
}

func (m *ModifyAckDeadlineRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyAckDeadlineRequest.Unmarshal(m, b)
}
func (m *ModifyAckDeadlineRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyAckDeadlineRequest.Marshal(b, m, deterministic)
}
func (m *ModifyAckDeadlineRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyAckDeadlineRequest.Merge(m, src)
}
func (m *ModifyAckDeadlineRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyAckDeadlineRequest.Size(m)
}
func (m *ModifyAckDeadlineRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyAckDeadlineRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyAckDeadlineRequest proto.InternalMessageInfo

func (m *ModifyAckDeadlineRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyAckDeadlineRequest) GetAckId() string {
	if m != nil {
		return m.AckId
	}
	return ""
}

func (m *ModifyAckDeadlineRequest) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	// The subscription whose message is being acknowledged.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The acknowledgment ID for the messages being acknowledged that was returned
	// by the Pub/Sub system in the Pull response. Must not be empty.
	AckIds               []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcknowledgeRequest) Reset()         { *m = AcknowledgeRequest{} }
func (m *AcknowledgeRequest) String() string { return proto.CompactTextString(m) }
func (*AcknowledgeRequest) ProtoMessage()    {}
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b98a574e1e7c287, []int{21}
}

func (m *AcknowledgeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcknowledgeRequest.Unmarshal(m, b)
}
func (m *AcknowledgeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcknowledgeRequest.Marshal(b, m, deterministic)
}
func (m *AcknowledgeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcknowledgeRequest.Merge(m, src)
}
func (m *AcknowledgeRequest) XXX_Size() int {
	return xxx_messageInfo_AcknowledgeRequest.Size(m)
}
func (m *AcknowledgeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AcknowledgeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AcknowledgeRequest proto.InternalMessageInfo

func (m *AcknowledgeRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *AcknowledgeRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

func init() {
	proto.RegisterType((*Topic)(nil), "google.pubsub.v1beta2.Topic")
	proto.RegisterType((*PubsubMessage)(nil), "google.pubsub.v1beta2.PubsubMessage")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1beta2.PubsubMessage.AttributesEntry")
	proto.RegisterType((*GetTopicRequest)(nil), "google.pubsub.v1beta2.GetTopicRequest")
	proto.RegisterType((*PublishRequest)(nil), "google.pubsub.v1beta2.PublishRequest")
	proto.RegisterType((*PublishResponse)(nil), "google.pubsub.v1beta2.PublishResponse")
	proto.RegisterType((*ListTopicsRequest)(nil), "google.pubsub.v1beta2.ListTopicsRequest")
	proto.RegisterType((*ListTopicsResponse)(nil), "google.pubsub.v1beta2.ListTopicsResponse")
	proto.RegisterType((*ListTopicSubscriptionsRequest)(nil), "google.pubsub.v1beta2.ListTopicSubscriptionsRequest")
	proto.RegisterType((*ListTopicSubscriptionsResponse)(nil), "google.pubsub.v1beta2.ListTopicSubscriptionsResponse")
	proto.RegisterType((*DeleteTopicRequest)(nil), "google.pubsub.v1beta2.DeleteTopicRequest")
	proto.RegisterType((*Subscription)(nil), "google.pubsub.v1beta2.Subscription")
	proto.RegisterType((*PushConfig)(nil), "google.pubsub.v1beta2.PushConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1beta2.PushConfig.AttributesEntry")
	proto.RegisterType((*ReceivedMessage)(nil), "google.pubsub.v1beta2.ReceivedMessage")
	proto.RegisterType((*GetSubscriptionRequest)(nil), "google.pubsub.v1beta2.GetSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.pubsub.v1beta2.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.pubsub.v1beta2.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.pubsub.v1beta2.DeleteSubscriptionRequest")
	proto.RegisterType((*ModifyPushConfigRequest)(nil), "google.pubsub.v1beta2.ModifyPushConfigRequest")
	proto.RegisterType((*PullRequest)(nil), "google.pubsub.v1beta2.PullRequest")
	proto.RegisterType((*PullResponse)(nil), "google.pubsub.v1beta2.PullResponse")
	proto.RegisterType((*ModifyAckDeadlineRequest)(nil), "google.pubsub.v1beta2.ModifyAckDeadlineRequest")
	proto.RegisterType((*AcknowledgeRequest)(nil), "google.pubsub.v1beta2.AcknowledgeRequest")
}

func init() { proto.RegisterFile("google/pubsub/v1beta2/pubsub.proto", fileDescriptor_2b98a574e1e7c287) }

var fileDescriptor_2b98a574e1e7c287 = []byte{
	// 1107 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x5f, 0x6f, 0xdb, 0x54,
	0x14, 0x97, 0x93, 0xfe, 0xcb, 0x71, 0x4a, 0xda, 0xab, 0xad, 0x73, 0x53, 0x06, 0x9d, 0x37, 0x4a,
	0x86, 0xb4, 0x64, 0x0b, 0x45, 0x42, 0x8c, 0x7f, 0xed, 0x56, 0x4d, 0x91, 0xa8, 0xc8, 0xdc, 0x3e,
	0xa0, 0x09, 0x2d, 0x72, 0xec, 0x5b, 0xc7, 0xc4, 0xb1, 0x3d, 0x5f, 0xbb, 0x34, 0x7b, 0x43, 0x08,
	0xc1, 0x13, 0x1f, 0x85, 0xaf, 0xc0, 0x03, 0x1f, 0x82, 0xaf, 0x83, 0x7c, 0xef, 0xb5, 0x63, 0xa7,
	0xbe, 0xa9, 0xdb, 0x89, 0x37, 0xdf, 0x73, 0xcf, 0xff, 0x73, 0x7e, 0xe7, 0x1e, 0x83, 0x6a, 0x79,
	0x9e, 0xe5, 0xe0, 0x8e, 0x1f, 0x0d, 0x49, 0x34, 0xec, 0x9c, 0x3f, 0x19, 0xe2, 0x50, 0xef, 0xf2,
	0x63, 0xdb, 0x0f, 0xbc, 0xd0, 0x43, 0xb7, 0x19, 0x4f, 0x9b, 0x13, 0x39, 0x4f, 0x73, 0x27, 0x11,
	0x8d, 0x99, 0x86, 0xd1, 0x59, 0x07, 0x4f, 0xfc, 0x70, 0xca, 0x64, 0xd4, 0x1d, 0x58, 0x3e, 0xf5,
	0x7c, 0xdb, 0x40, 0x08, 0x96, 0x5c, 0x7d, 0x82, 0x15, 0x69, 0x57, 0x6a, 0xd5, 0x34, 0xfa, 0xad,
	0xfe, 0x2b, 0xc1, 0x7a, 0x9f, 0x2a, 0x3b, 0xc6, 0x84, 0xe8, 0x16, 0x8e, 0xb9, 0x4c, 0x3d, 0xd4,
	0x29, 0x57, 0x5d, 0xa3, 0xdf, 0xe8, 0x14, 0x40, 0x0f, 0xc3, 0xc0, 0x1e, 0x46, 0x21, 0x26, 0x4a,
	0x65, 0xb7, 0xda, 0x92, 0xbb, 0xfb, 0xed, 0x42, 0x5f, 0xda, 0x39, 0x6d, 0xed, 0x83, 0x54, 0xec,
	0xc8, 0x0d, 0x83, 0xa9, 0x96, 0xd1, 0x83, 0xee, 0x02, 0x4c, 0x18, 0xdb, 0xc0, 0x36, 0x95, 0x2a,
	0xf5, 0xaa, 0xc6, 0x29, 0x3d, 0xb3, 0xf9, 0x15, 0x34, 0xe6, 0xa4, 0xd1, 0x06, 0x54, 0xc7, 0x78,
	0xca, 0x03, 0x88, 0x3f, 0xd1, 0x2d, 0x58, 0x3e, 0xd7, 0x9d, 0x08, 0x2b, 0x15, 0x4a, 0x63, 0x87,
	0x2f, 0x2a, 0x9f, 0x4b, 0xea, 0xc7, 0xd0, 0x78, 0x81, 0x43, 0x1a, 0xb9, 0x86, 0xdf, 0x44, 0x98,
	0x84, 0x31, 0x73, 0x18, 0x9f, 0xb9, 0x02, 0x76, 0x50, 0x47, 0xf0, 0x5e, 0x3f, 0x1a, 0x3a, 0x36,
	0x19, 0x2d, 0xe4, 0x43, 0xdf, 0xc2, 0x1a, 0x77, 0x2e, 0x49, 0xc1, 0x83, 0x32, 0x29, 0xd0, 0x52,
	0x29, 0xb5, 0x0b, 0x8d, 0xd4, 0x12, 0xf1, 0x3d, 0x97, 0x60, 0xf4, 0x21, 0xc8, 0xb3, 0x1c, 0x10,
	0x45, 0xda, 0xad, 0xb6, 0x6a, 0x1a, 0xa4, 0x49, 0x20, 0xaa, 0x0d, 0x9b, 0xdf, 0xd9, 0x84, 0xc5,
	0x41, 0x12, 0x07, 0x15, 0x58, 0xf5, 0x03, 0xef, 0x27, 0x6c, 0x84, 0xdc, 0xc5, 0xe4, 0x88, 0x76,
	0xa0, 0xe6, 0xc7, 0xca, 0x88, 0xfd, 0x96, 0xe5, 0x64, 0x59, 0x5b, 0x8b, 0x09, 0x27, 0xf6, 0x5b,
	0x1c, 0x27, 0x9c, 0x5e, 0x86, 0xde, 0x18, 0xbb, 0x49, 0xc2, 0x63, 0xca, 0x69, 0x4c, 0x50, 0x03,
	0x40, 0x59, 0x53, 0xdc, 0xc3, 0x7d, 0x58, 0xa1, 0xf1, 0x33, 0xe7, 0xe4, 0xee, 0xfb, 0x82, 0xa0,
	0x59, 0xa6, 0x39, 0x2f, 0xda, 0x83, 0x86, 0x8b, 0x2f, 0xc2, 0x41, 0xc6, 0x1e, 0xab, 0xd0, 0x7a,
	0x4c, 0xee, 0xa7, 0x36, 0xdf, 0xc0, 0xdd, 0xd4, 0xe6, 0x49, 0x34, 0x24, 0x46, 0x60, 0xfb, 0xa1,
	0xed, 0xb9, 0x64, 0x71, 0x2d, 0xde, 0x25, 0x4c, 0x17, 0x3e, 0x10, 0x99, 0xe4, 0x21, 0x3f, 0x80,
	0x75, 0x92, 0xbd, 0xe0, 0x65, 0xc9, 0x13, 0x4b, 0x87, 0xf8, 0x09, 0xa0, 0xe7, 0xd8, 0xc1, 0x21,
	0x2e, 0xd1, 0x8b, 0x7f, 0x49, 0x50, 0xcf, 0xfa, 0x54, 0x84, 0xd9, 0x99, 0x68, 0x25, 0x9b, 0x92,
	0x43, 0x90, 0xfd, 0x88, 0x8c, 0x06, 0x86, 0xe7, 0x9e, 0xd9, 0x96, 0xb2, 0xb4, 0x2b, 0xb5, 0xe4,
	0xee, 0x3d, 0x61, 0x87, 0x92, 0xd1, 0x33, 0xca, 0xa8, 0x81, 0x9f, 0x7e, 0xa3, 0xc7, 0x70, 0x4b,
	0x37, 0xc6, 0x03, 0x13, 0xeb, 0xa6, 0x63, 0xbb, 0x78, 0x40, 0xb0, 0xe1, 0xb9, 0x26, 0x51, 0x96,
	0x69, 0x86, 0x91, 0x6e, 0x8c, 0x9f, 0xf3, 0xab, 0x13, 0x76, 0xa3, 0xfe, 0x23, 0x01, 0xcc, 0x94,
	0xa1, 0xfb, 0xb0, 0x4e, 0x9d, 0xc0, 0xae, 0xe9, 0x7b, 0xb6, 0x9b, 0xb4, 0x67, 0x3d, 0x26, 0x1e,
	0x71, 0x1a, 0x7a, 0x59, 0x30, 0x4d, 0x9e, 0x5c, 0xe9, 0xe8, 0xa2, 0x51, 0xf2, 0xae, 0xb3, 0x62,
	0x04, 0x0d, 0x0d, 0x1b, 0xd8, 0x3e, 0xc7, 0x66, 0x32, 0x06, 0x6f, 0xc3, 0x4a, 0x9c, 0x0a, 0xdb,
	0x4c, 0x0a, 0xa4, 0x1b, 0xe3, 0x9e, 0x89, 0xbe, 0x86, 0x55, 0x0e, 0x4e, 0xaa, 0xa5, 0xec, 0x0c,
	0x48, 0x84, 0xd4, 0x2f, 0x61, 0xeb, 0x05, 0x0e, 0xb3, 0x25, 0x4e, 0x1a, 0x42, 0x85, 0x7a, 0xb6,
	0xbf, 0x92, 0xcc, 0x65, 0x69, 0xaa, 0x0f, 0x4a, 0xdc, 0xba, 0x85, 0x40, 0xf9, 0x7f, 0x66, 0xc2,
	0x9f, 0x12, 0x6c, 0x17, 0x98, 0xe4, 0x40, 0xe9, 0x15, 0x01, 0x45, 0xee, 0xde, 0x17, 0xe4, 0x24,
	0x17, 0xf6, 0x0d, 0xd1, 0xf4, 0x0d, 0x6c, 0x33, 0x34, 0xdd, 0x34, 0x87, 0xbf, 0x48, 0x70, 0xe7,
	0xd8, 0x33, 0xed, 0xb3, 0x69, 0x06, 0x04, 0xe5, 0xe5, 0xe7, 0x71, 0x56, 0xb9, 0x01, 0xce, 0xd4,
	0x5f, 0x25, 0x90, 0xfb, 0x91, 0xe3, 0x5c, 0xc7, 0xee, 0x23, 0x40, 0x01, 0x0e, 0xa3, 0xc0, 0x1d,
	0xd8, 0x93, 0x09, 0x36, 0x6d, 0x3d, 0xc4, 0xce, 0x94, 0x9a, 0x5f, 0xd3, 0x36, 0xd9, 0x4d, 0x6f,
	0x76, 0x81, 0xee, 0x41, 0x7d, 0xa2, 0x5f, 0x0c, 0xd2, 0x17, 0xab, 0x4a, 0xeb, 0x2e, 0x4f, 0xf4,
	0x8b, 0xe3, 0xe4, 0x39, 0x32, 0xa0, 0xce, 0x9c, 0xe0, 0xd5, 0x3c, 0x81, 0xcd, 0x80, 0xa3, 0x60,
	0x26, 0xc7, 0x2a, 0xba, 0x27, 0x88, 0x6f, 0x0e, 0x35, 0xda, 0x46, 0x90, 0x27, 0x10, 0xf5, 0x77,
	0x09, 0x14, 0x96, 0xee, 0x83, 0xd9, 0xf4, 0xb8, 0x4e, 0xdc, 0x33, 0x20, 0x56, 0xb2, 0x40, 0x14,
	0x8d, 0xaa, 0xaa, 0x70, 0x54, 0xbd, 0x04, 0x74, 0x60, 0x8c, 0x5d, 0xef, 0x67, 0x07, 0x9b, 0xd6,
	0xb5, 0x5c, 0xb8, 0x03, 0xab, 0xcc, 0x05, 0x36, 0xad, 0x6a, 0xda, 0x0a, 0xf5, 0x81, 0x74, 0xff,
	0x58, 0x01, 0xe0, 0x7d, 0x38, 0xc4, 0x01, 0x7a, 0x0d, 0xe8, 0x59, 0x80, 0xf5, 0x7c, 0x6f, 0xa2,
	0x32, 0x68, 0x68, 0x96, 0x61, 0x42, 0x98, 0xae, 0x34, 0x39, 0xd2, 0x23, 0x81, 0x5c, 0xf1, 0x90,
	0x29, 0x67, 0xe6, 0x9c, 0xad, 0x1c, 0x39, 0xc8, 0xa3, 0x8e, 0x40, 0x52, 0x34, 0x8f, 0x9a, 0x8f,
	0xcb, 0x0b, 0xf0, 0xfe, 0x7b, 0x9d, 0x3c, 0x94, 0x39, 0x6f, 0x44, 0x7a, 0x84, 0x53, 0xa0, 0xb9,
	0x95, 0x4a, 0xf0, 0x75, 0xb8, 0x7d, 0x14, 0xaf, 0xc3, 0xe8, 0x47, 0xd8, 0xbc, 0xd4, 0x89, 0xc2,
	0xb8, 0x44, 0x3d, 0x2b, 0xd4, 0xde, 0x07, 0x39, 0xd3, 0x5e, 0xe8, 0xa1, 0x40, 0xef, 0xe5, 0x16,
	0x14, 0x6a, 0xfc, 0x1e, 0x96, 0x62, 0x7c, 0x22, 0x55, 0x38, 0x5c, 0xd2, 0x09, 0x22, 0x2c, 0x6c,
	0x0e, 0xe0, 0xaf, 0x60, 0x63, 0x7e, 0xf2, 0xa1, 0xf6, 0xc2, 0xf8, 0x2f, 0x8d, 0x48, 0x91, 0xb3,
	0xdd, 0xbf, 0x97, 0xa0, 0xc6, 0x97, 0x5b, 0x1c, 0xa0, 0x1e, 0xc8, 0x0c, 0x09, 0xec, 0xcf, 0x63,
	0xe1, 0xce, 0xd8, 0x5c, 0x78, 0x8b, 0x7e, 0x80, 0x55, 0xae, 0x17, 0x7d, 0x24, 0x7e, 0x6b, 0x33,
	0xeb, 0x7b, 0x73, 0xef, 0x2a, 0x36, 0x9e, 0x8e, 0x3e, 0xac, 0x25, 0x7f, 0x08, 0x68, 0x4f, 0x8c,
	0xa3, 0xec, 0xda, 0x76, 0x85, 0xaf, 0x3a, 0xc0, 0x6c, 0x83, 0x46, 0xad, 0x05, 0x08, 0xc8, 0xed,
	0xf3, 0xcd, 0x87, 0x25, 0x38, 0xb9, 0xd3, 0xbf, 0x49, 0xb0, 0x55, 0xbc, 0xbe, 0xa2, 0xfd, 0xab,
	0xb4, 0x14, 0xe2, 0xf4, 0xb3, 0x6b, 0x4a, 0xa5, 0xc9, 0x93, 0x33, 0x5b, 0xad, 0xb0, 0xdd, 0x2f,
	0x6f, 0xbe, 0xa2, 0x0e, 0x3a, 0xb4, 0x60, 0xdb, 0xf0, 0x26, 0xc5, 0x7a, 0x0e, 0x65, 0xb6, 0x4f,
	0xf5, 0x63, 0x91, 0xbe, 0xf4, 0xea, 0x29, 0xe7, 0xb2, 0x3c, 0x47, 0x77, 0xad, 0xb6, 0x17, 0x58,
	0x1d, 0x0b, 0xbb, 0x54, 0x61, 0x87, 0x5d, 0xe9, 0xbe, 0x4d, 0xe6, 0x7e, 0xa5, 0x9f, 0xb2, 0xe3,
	0x70, 0x85, 0xf2, 0x7d, 0xfa, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe2, 0x2d, 0xb0, 0x67, 0x71,
	0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SubscriberClient is the client API for Subscriber service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SubscriberClient interface {
	// Creates a subscription to a given topic for a given subscriber.
	// If the subscription already exists, returns ALREADY_EXISTS.
	// If the corresponding topic doesn't exist, returns NOT_FOUND.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to Pull after deletion will return
	// NOT_FOUND. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful to
	// indicate that more time is needed to process a message by the subscriber,
	// or to make the message available for redelivery if the processing was
	// interrupted.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Acknowledges the messages associated with the ack tokens in the
	// AcknowledgeRequest. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return UNAVAILABLE if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// Modifies the PushConfig for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified
	// by an empty PushConfig) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for
	// delivery continuously through the call regardless of changes to the
	// PushConfig.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type subscriberClient struct {
	cc *grpc.ClientConn
}

func NewSubscriberClient(cc *grpc.ClientConn) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/CreateSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/GetSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ListSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/DeleteSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ModifyAckDeadline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/Acknowledge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/Pull", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ModifyPushConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubscriberServer is the server API for Subscriber service.
type SubscriberServer interface {
	// Creates a subscription to a given topic for a given subscriber.
	// If the subscription already exists, returns ALREADY_EXISTS.
	// If the corresponding topic doesn't exist, returns NOT_FOUND.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to Pull after deletion will return
	// NOT_FOUND. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*empty.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful to
	// indicate that more time is needed to process a message by the subscriber,
	// or to make the message available for redelivery if the processing was
	// interrupted.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*empty.Empty, error)
	// Acknowledges the messages associated with the ack tokens in the
	// AcknowledgeRequest. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*empty.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return UNAVAILABLE if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// Modifies the PushConfig for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified
	// by an empty PushConfig) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for
	// delivery continuously through the call regardless of changes to the
	// PushConfig.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*empty.Empty, error)
}

// UnimplementedSubscriberServer can be embedded to have forward compatible implementations.
type UnimplementedSubscriberServer struct {
}

func (*UnimplementedSubscriberServer) CreateSubscription(ctx context.Context, req *Subscription) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubscription not implemented")
}
func (*UnimplementedSubscriberServer) GetSubscription(ctx context.Context, req *GetSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubscription not implemented")
}
func (*UnimplementedSubscriberServer) ListSubscriptions(ctx context.Context, req *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscriptions not implemented")
}
func (*UnimplementedSubscriberServer) DeleteSubscription(ctx context.Context, req *DeleteSubscriptionRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubscription not implemented")
}
func (*UnimplementedSubscriberServer) ModifyAckDeadline(ctx context.Context, req *ModifyAckDeadlineRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyAckDeadline not implemented")
}
func (*UnimplementedSubscriberServer) Acknowledge(ctx context.Context, req *AcknowledgeRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Acknowledge not implemented")
}
func (*UnimplementedSubscriberServer) Pull(ctx context.Context, req *PullRequest) (*PullResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Pull not implemented")
}
func (*UnimplementedSubscriberServer) ModifyPushConfig(ctx context.Context, req *ModifyPushConfigRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyPushConfig not implemented")
}

func RegisterSubscriberServer(s *grpc.Server, srv SubscriberServer) {
	s.RegisterService(&_Subscriber_serviceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ModifyAckDeadline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/Acknowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ModifyPushConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Subscriber_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1beta2.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1beta2/pubsub.proto",
}

// PublisherClient is the client API for Publisher service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PublisherClient interface {
	// Creates the given topic with the given name.
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns NOT_FOUND if the topic does
	// not exist.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns NOT_FOUND if the topic does
	// not exist. After a topic is deleted, a new topic may be created with the
	// same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type publisherClient struct {
	cc *grpc.ClientConn
}

func NewPublisherClient(cc *grpc.ClientConn) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/CreateTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/Publish", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/GetTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/ListTopics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/ListTopicSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/DeleteTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PublisherServer is the server API for Publisher service.
type PublisherServer interface {
	// Creates the given topic with the given name.
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Adds one or more messages to the topic. Returns NOT_FOUND if the topic does
	// not exist.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns NOT_FOUND if the topic does
	// not exist. After a topic is deleted, a new topic may be created with the
	// same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*empty.Empty, error)
}

// UnimplementedPublisherServer can be embedded to have forward compatible implementations.
type UnimplementedPublisherServer struct {
}

func (*UnimplementedPublisherServer) CreateTopic(ctx context.Context, req *Topic) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTopic not implemented")
}
func (*UnimplementedPublisherServer) Publish(ctx context.Context, req *PublishRequest) (*PublishResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Publish not implemented")
}
func (*UnimplementedPublisherServer) GetTopic(ctx context.Context, req *GetTopicRequest) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTopic not implemented")
}
func (*UnimplementedPublisherServer) ListTopics(ctx context.Context, req *ListTopicsRequest) (*ListTopicsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopics not implemented")
}
func (*UnimplementedPublisherServer) ListTopicSubscriptions(ctx context.Context, req *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopicSubscriptions not implemented")
}
func (*UnimplementedPublisherServer) DeleteTopic(ctx context.Context, req *DeleteTopicRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTopic not implemented")
}

func RegisterPublisherServer(s *grpc.Server, srv PublisherServer) {
	s.RegisterService(&_Publisher_serviceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/CreateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/Publish",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/GetTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/ListTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/ListTopicSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/DeleteTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Publisher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1beta2.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1beta2/pubsub.proto",
}
