/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;

public class VersionInfo implements Versioned {
    private final Version version;

    public VersionInfo(String version) {
        this.version = VersionParser.INSTANCE.transform(version);
    }

    public Version getVersion() {
        return version;
    }

    public boolean equals(Object other) {
        return other instanceof VersionInfo && version.equals(((VersionInfo) other).getVersion());
    }

    public int hashCode() {
        return version.hashCode();
    }
}
