find_path(CAIRO_INCLUDE_DIR cairo/cairo.h)

find_library(CAIRO_LIBRARY NAMES cairo)

find_file(CAIRO_RUNTIME_LIBRARY NAMES cairo.dll)
find_file(EXPAT_RUNTIME_LIBRARY NAMES expat.dll)
find_file(FONTCONFIG_RUNTIME_LIBRARY NAMES fontconfig.dll)
find_file(PIXMAN_RUNTIME_LIBRARY NAMES pixman-1.dll)

include(FindPackageHandleStandardArgs)
if (WIN32)
    find_package_handle_standard_args(CAIRO DEFAULT_MSG
        CAIRO_INCLUDE_DIR

        CAIRO_LIBRARY

        CAIRO_RUNTIME_LIBRARY
        EXPAT_RUNTIME_LIBRARY
        FONTCONFIG_RUNTIME_LIBRARY
        PIXMAN_RUNTIME_LIBRARY
    )
else()
    find_package_handle_standard_args(CAIRO DEFAULT_MSG
        CAIRO_INCLUDE_DIR

        CAIRO_LIBRARY
    )
endif()

mark_as_advanced(
    CAIRO_INCLUDE_DIR

    CAIRO_LIBRARY

    CAIRO_RUNTIME_LIBRARY
    EXPAT_RUNTIME_LIBRARY
    FONTCONFIG_RUNTIME_LIBRARY
    PIXMAN_RUNTIME_LIBRARY
)

set(CAIRO_INCLUDE_DIRS ${CAIRO_INCLUDE_DIR})

set(CAIRO_LIBRARIES
    ${CAIRO_LIBRARY}
)

set(CAIRO_RUNTIME_LIBRARIES
    ${CAIRO_RUNTIME_LIBRARY}
    ${EXPAT_RUNTIME_LIBRARY}
    ${FONTCONFIG_RUNTIME_LIBRARY}
    ${PIXMAN_RUNTIME_LIBRARY}
)
