/*
 * Copyright 2014 Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <folly/io/async/EventBase.h>


// Interface for D code.  Note that we use C-style functions instead of C++
// members, to avoid mismatched virtual tables.
extern "C" {

void teventbase_loop(folly::EventBase* eb) {
  eb->loop();
}

bool teventbase_isRunning(folly::EventBase* eb) {
  return eb->isRunning();
}

}// extern "C"
