# Support and other resources

## Accessing Hewlett Packard Enterprise Support

- For live assistance, go to the **Contact Hewlett Packard Enterprise Worldwide** website.

[http://www.hpe.com/assistance](http://www.hpe.com/assistance)

- To access documentation and support services, go to the **Hewlett Packard Enterprise Support Center** website.

[http://www.hpe.com/support/hpesc](http://www.hpe.com/support/hpesc)

### Information to collect

- Technical support registration number (if applicable)

- Product name, model or version, and serial number

- Operating system name and version

- Firmware version

- Error messages

- Product-specific reports and logs

- Add-on products or components

- Third-party products or components

## Accessing updates

- Some software products provide a mechanism for accessing software updates through the product interface. Review your product documentation to identify the recommended software update method.

- To download product updates, go to either of the following:

  - Hewlett Packard Enterprise Support Center **Get connected with updates** page: [http://www.hpe.com/support/e-updates](http://www.hpe.com/support/e-updates)

  - Software Depot website: [http://www.hpe.com/support/softwaredepot](http://www.hpe.com/support/softwaredepot)

- To view and update your entitlements and to link your contracts and warranties with your profile, go to the Hewlett Packard Enterprise Support Center **More Information on the Access to Support Materials** page. [http://www.hpe.com/support/AccessToSupportMaterials](http://www.hpe.com/support/AccessToSupportMaterials)

<aside class="notice">Access to some updates might require product entitlement when accessed through the <b>Hewlett Packard Enterprise Support Center</b>. You must have an HPE Passport set up with relevant entitlements.</aside>


## Websites and documents

### Tutorial Videos

[Creating iLO REST Extensions](https://www.youtube.com/watch?v=CGl8DsYTdQo)

[An Introduction to the RESTful Interface Tool](https://www.youtube.com/watch?v=xfEN95pNNfY)

[Benefits of RESTful Interface Tool vs. CONREP](https://www.youtube.com/watch?v=WPz2FP8bXYU)

### Websites

Website | Link
--------|-------
Hewlett Packard Enterprise Information Library 	| [www.hpe.com/info/enterprise/docs]([http://www.hpe.com/info/enterprise/docs)
Hewlett Packard Enterprise Support Center		| [www.hpe.com/support/hpesc](http://www.hpe.com/support/hpesc)
Contact Hewlett Packard Enterprise Worldwide	| [www.hpe.com/assistance](http://www.hpe.com/assistance)
Subscription Service/Support Alerts				| [www.hpe.com/support/e-updates](http://www.hpe.com/support/e-updates)
Software Depot									| [www.hpe.com/support/softwaredepot](http://www.hpe.com/support/softwaredepot)
Customer Self Repair							| [www.hpe.com/support/selfrepair](http://www.hpe.com/support/selfrepair)
Insight Remote Support							| [www.hpe.com/info/insightremotesupport/docs](http://www.hpe.com/info/insightremotesupport/docs)
Serviceguard Solutions for HP-UX				| [www.hpe.com/info/hpux-serviceguard-docs](http://www.hpe.com/info/hpux-serviceguard-docs)
Single Point of Connectivity Knowledge (SPOCK) Storage compatibility matrix	| [www.hpe.com/storage/spock](http://www.hpe.com/storage/spock)
Storage white papers and analyst reports		| [www.hpe.com/storage/whitepapers](http://www.hpe.com/storage/whitepapers)
iLO RESTful API									| [www.hpe.com/info/restfulapi](http://www.hpe.com/info/restfulapi)
HPE ProLiant Gen9 Server Management				| [www.hpe.com/servers/proliantgen9/docs](http://www.hpe.com/servers/proliantgen9/docs)
HPE Intelligent Provisioning					| [www.hpe.com/info/intelligentprovisioning/docs](http://www.hpe.com/info/intelligentprovisioning/docs)
UEFI System Utilities							| [www.hpe.com/info/ProLiantUEFI/docs](http://www.hpe.com/info/ProLiantUEFI/docs)
SUM												| [www.hpe.com/info/hpsum](http://www.hpe.com/info/hpsum)
Service Pack for ProLiant (SPP)					| [www.hpe.com/servers/spp](http://www.hpe.com/servers/spp)
HPE iLO 4										| [www.hpe.com/info/ilo/docs](http://www.hpe.com/info/ilo/docs)
HPE iLO University videos						| [www.hpe.com/info/ilo/videos](http://www.hpe.com/info/ilo/videos)
HPE Systems Insight Manager						| [www.hpe.com/info/hpsim](http://www.hpe.com/info/hpsim)
U.S. Authorized Resellers						| [www.hpe.com/support/service_locator](http://www.hpe.com/support/service_locator)

### Documents

- [Transition to the RESTful Interface Tool (iLORest)](https://support.hpe.com/hpsc/doc/public/display?docId=a00061427en_us)
- [iLO RESTful API Data Model Reference (iLO 4)](http://h22208.www2.hpe.com/eginfolib/servers/docs/HPRestfultool/iLo4/data_model_reference.html)
- [HPE iLO 4 Scripting and Command Line Guide](http://h20564.www2.hpe.com/hpsc/doc/public/display?docId=c03334058)
- [HPE iLO 4 Release Notes](http://h20565.www2.hpe.com/hpsc/doc/public/display?docId=emr_na-c03334036&lang=en-us&cc=us)
- [HPE ROM-Based Setup Utility User Guide](http://h20564.www2.hpe.com/hpsc/doc/public/display?docId=c00191707)
- [HPE UEFI System Utilities User Guide](https://support.hpe.com/hpesc/public/docDisplay?docId=a00016407en_us)
- [HPE Intelligent Provisioning User Guide for HPE ProLiant Gen9 Servers](https://support.hpe.com/hpesc/public/docDisplay?docId=c04419967)
- [Scripting Toolkit for Linux User Guide](https://support.hpe.com/hpesc/public/docDisplay?docLocale=en_US&docId=emr_na-a00047893en_us)
- [Scripting Toolkit for Windows User Guide](https://support.hpe.com/hpesc/public/docDisplay?docId=a00017070en_us)
- [Smart Update Manager User Guide](http://h20564.www2.hpe.com/hpsc/doc/public/display?docId=c05059565)
- [Service Pack for ProLiant User Guide](http://h20564.www2.hpe.com/hpsc/doc/public/display?docId=c03190790)
- [HPE BladeSystem Onboard Administrator User Guide](http://h20628.www2.hpe.com/km-ext/kmcsdirect/emr_na-c00705292-47.pdf)
- [HPE iLO Federation User Guide](http://h20564.www2.hpe.com/hpsc/doc/public/display?docId=c04149067)

## Customer self-repair

**Hewlett Packard Enterprise customer self repair** (CSR) programs allow you to repair your product. If a CSR part needs to be replaced, it will be shipped directly to you so that you can install it at your convenience. Some parts do not qualify for CSR. Your Hewlett Packard Enterprise authorized service provider will determine whether a repair can be accomplished by CSR.

For more information about CSR, contact your local service provider or go to the CSR website.

[www.hpe.com/support/selfrepair](http://www.hpe.com/support/selfrepair)

## Remote Support

Remote support is available with supported devices as part of your warranty or contractual support agreement. It provides intelligent event diagnosis, and automatic, secure submission of hardware event notifications to Hewlett Packard Enterprise, which will initiate a fast and accurate resolution based on your product&apos;s service level. Hewlett Packard Enterprise strongly recommends that you register your device for remote support.

For more information and device support details, go to the following website.

[www.hpe.com/info/insightremotesupport/docs](http://www.hpe.com/info/insightremotesupport/docs)

## Documentation feedback

Hewlett Packard Enterprise is committed to providing documentation that meets your needs. To help us improve the documentation, send any errors, suggestions, or comments to **Documentation Feedback**, [docsfeedback@hpe.com](mailto:docsfeedback@hpe.com). When submitting your feedback, include the document title, part number, edition, and publication date located on the front cover of the document. For online help content, include the product name, product version, help edition, and publication date located on the legal notices page.
