# -*- coding: utf-8 -*-

# LyricsScreenlet Copyright (C) 2009 by Marcel Dancak <dancakm@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
import urllib
import urllib2
import re

partial_result_regex = re.compile('partial: (\d+)\s')
		
class LrcdbEngine:
	
	continueDownloading = True
	
	def __init__(self, resultCallback):
		self.resultCallback = resultCallback
	
	def stop(self):
		self.continueDownloading = False
		
	def find(self, songInfo):
		self.continueDownloading = True
		
		if not songInfo.has_key('title') or not songInfo.has_key('artist'):
			return
		
		title  = songInfo['title' ]
		artist = songInfo['artist']
	
		if songInfo.has_key('album'):
			album = songInfo['album']
		else:
			album = ''
	
		params = {'artist':str(unicode(artist).encode('utf8')),'title':str(unicode(title).encode('utf8')),'album':album,'query':'plugin','type':'plugin','submit':'submit'}
		try:
			file = urllib2.urlopen('http://www.lrcdb.org/search.php',urllib.urlencode(params))
			response = file.read()
			#print "lrcdb response:"
			#print response
			file.close()
			
			for response in response.rsplit('\n'):
				if self.continueDownloading == True and not response.startswith('no match'):
					if response.startswith('exact: '):
						lrcId = response[7:]
					else:
						match = partial_result_regex.match(response)
						if match:
							lrcId = match.group(1)
						else: continue
	
					print lrcId
					url = 'http://www.lrcdb.org/lyric.php?lid=%s&astext=yes' %lrcId
					lyrFile = urllib2.urlopen(url)
					lyrics = lyrFile.read()
					lyrFile.close()
					#print lyrics
					# brrr, windows separators
					if self.continueDownloading == True:
						self.resultCallback(lyrics.replace('\r\n', '\n'))
		except Exception, e:
			print e

