#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
VERSION=$(dpkg-parsechangelog | sed -ne 's,^Version: \(.*\)-.*,\1,p')
TAR=jblas_${2}.orig.tar.gz
ORIGDIR=mikiobraun-jblas-*/
TARGETDIR=jblas-$2

# clean up the upstream tarball
tar xzf $3
mv $ORIGDIR $TARGETDIR
tar -czf $TAR --exclude '*/javadoc' --exclude '*/native-libs' $TARGETDIR
rm -rf $TARGETDIR
rm -f $3

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0
