This document describe the plan for the next releases of Jbuilder.

# V1

Jbuilder is currently in feature freeze. V1 should be released soon.

## ~~CLI~~

Add a proper [cmdliner](http://erratique.ch/software/cmdliner) based
CLI.  Jbuilder will include a copy of cmdliner to avoid the extra
dependency.

- *20/02/2017*: This is now implemented thanks to Rudi Grinberg (#5)

### Improve the man pages

Add a bit more documentation in the Man pages generated by cmdliner.

## ~~Documentation~~

Document the usage and design of Jbuilder.

- *21/02/2017*: There is now a manual, it still needs a bit more about
  CLI usage
- *07/03/2017*: Manual is complete

## ~~Stable jbuild types~~

Add a stable version of the jbuild format so that one can write
`(jbuild_version 1)` inside jbuild files and be sure that they will
work with future versions of jbuild.

- *24/02/2017*: implemented

## ~~Finding the project/workspace root~~

Currently `jbuilder` assumes that the root of the project/workspace is
where it is started. Eventually this will be changed as follows:

- if there is a `jbuild-workspace` in a parent directory, it marks the root;
- if not found, look for a `opam` or `package.opam` file in parent directories;
- if not found, look for a `.git`, `.hg`, ... file in parent directories;
- if not found, use the current directory as root.

- *28/02/2017*: Implemented

## ~~Generate .merlin files #1~~

- *25/02/2017*: Implemented by Richard Davison (#2)

## ~~Running tests with jbuilder #3~~

Allow to define tests with `(alias ...)` stanzas and add `jbuilder
runtest` to run them.

- *21/02/2017*: Rudi Grinberg added support for aliases (#7)
- *23/02/2017*: Added a `runtest` subcommand

## ~~Implement package version support~~

Implement finding the version of a package, as described in the
documentation.

- *24/02/2017*: Implemented

## ~~Add a `(package ...)` field to alias stanzas~~

So that we can filter tests when using `-p pkg`

- *05/02/2017*: Rudi Grinberg added this ([[https://github.com/janestreet/jbuilder/pull/64][#64]])

## ~~Integrate rules for js_of_ocaml~~

#60

- *02/05/2017*: Merged

## ~~Topkg integration~~

It would be nice to integrate with
[topkg](http://erratique.ch/software/topkg). Some of the features
overlap, and for instance there doesn't seem to be much point in using
topkg to generate the .install or invoke jbuilder since jbuilder
already handles that well. However, the other features available
through the `topkg` command line tool would be good to have.

- *08/05/2017*: Made topkg and jbuilder work together with
  [topkg-jbuilder](https://github.com/diml/topkg-jbuilder)

## ~~odoc support~~

Support generating documentation with
[odoc](https://github.com/ocaml-doc/odoc)

# After V1

## Integrate rules for `-output-complete-obj`

#23

## Cross-compilation

Everything needed for cross-compilation is implemented. One
essentially need to add a function `host_exe : Path.t -> Path.t`
inside build contexts to make it all work, as well as a way to define
the build contexts. These could be defined inside `jbuild-workspace`
as follows:

```scheme
(context
 ((name   foo)
  (switch 4.04.0)))

(context
 ((name   foo+mingw)
  (switch 4.04.0+mingw)
  (host   foo)))
```

## Jenga bridge

Implement a jenga plugin that can read the same jbuild files as
Jbuilder. To do that we'll use Jbuilder as a library.

## Inline tests

Setup automatic support of
[inline tests](https://github.com/janestreet/ppx_inline_test) and
[inline benchmarks](https://github.com/janestreet/ppx_bench).

## Extend the action language

Currently in `(action ...)` fields, when not using `bash` the language
is very limited. It would be nice to add more commands that would
guarantee portability and avoid the quoting nightmare of `bash`.

FS commands should be straight foward to implement:
- `(copy <src> <dst>)`
- `(mkdir <path>)`
- ...

Redirections to/from files are simple as well.

We could also implements pipes (`(pipe <command1> <command2> ...)`) by
using temporary files. Using proper pipes would complicate windows
support and would make proper handling of `-j` hard. Using temporary
files will be just fine.

## User configuration file

Load a configuration file from `~/.config/jbuilder/config.sexp` where
the user can define preferences such as colors.

## Code improvements

### Delete the global variables in Clflags

### Consolidate the S-expression parser

It doesn't follow the specification given in the readme of
[parsexp](https://github.com/janestreet/parsexp). This need to be
fixed.
