/*
 * Copyright (C) 2018 KeePassXC Team <team@keepassxc.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 or (at your option)
 * version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEEPASSXC_CRYPTO_ARGON2_H
#define KEEPASSXC_CRYPTO_ARGON2_H

/*
    Argon2 wrapper header with redefined symbols to be used with the
    patched libargon2 binary which is generated by the build system.
    This is to avoid link-time definition clashes with libsodium on Windows.
 */

#ifdef Q_OS_WIN
#define argon2_hash libargon2_argon2_hash
#define argon2_error_message libargon2_argon2_error_message
#endif

#include <argon2.h>

#endif // KEEPASSXC_CRYPTO_ARGON2_H
