/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright The KiCad Developers, see AUTHORS.txt for contributors.
 * Author: SYSUEric <jzzhuang666@gmail.com>.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>
#include "odb_entity.h"

const std::string odb_fonts1 = R"(
XSIZE  0.302000
YSIZE  0.302000
OFFSET 0.000000
CHAR !
LINE 0.000000 0.000000 0.000000 0.200000 P R 0.012000
LINE 0.000000 -0.100000 0.000000 -0.100000 P R 0.012000
ECHAR
CHAR "
LINE -0.050000 0.100000 -0.050000 0.200000 P R 0.012000
LINE 0.050000 0.100000 0.050000 0.200000 P R 0.012000
ECHAR
CHAR #
LINE -0.050000 -0.100000 -0.050000 0.200000 P R 0.012000
LINE 0.050000 -0.100000 0.050000 0.200000 P R 0.012000
LINE -0.100000 0.000000 0.100000 0.000000 P R 0.012000
LINE -0.100000 0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR $
LINE 0.000000 -0.100000 0.000000 0.200000 P R 0.012000
LINE -0.100000 -0.050000 0.050000 -0.050000 P R 0.012000
LINE 0.050000 -0.050000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 -0.050000 0.050000 P R 0.012000
LINE -0.050000 0.050000 -0.100000 0.100000 P R 0.012000
LINE -0.100000 0.100000 -0.050000 0.150000 P R 0.012000
LINE -0.050000 0.150000 0.100000 0.150000 P R 0.012000
ECHAR
CHAR %
LINE -0.100000 -0.100000 0.100000 0.200000 P R 0.012000
LINE -0.075000 0.175000 -0.075000 0.175000 P R 0.012000
LINE 0.075000 -0.075000 0.075000 -0.075000 P R 0.012000
ECHAR
CHAR &
LINE 0.100000 -0.100000 -0.100000 0.100000 P R 0.012000
LINE -0.100000 0.100000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.000000 0.150000 P R 0.012000
LINE 0.000000 0.150000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 -0.100000 0.000000 P R 0.012000
LINE -0.100000 0.000000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.100000 0.000000 P R 0.012000
ECHAR
CHAR '
LINE 0.000000 0.050000 0.050000 0.150000 P R 0.012000
LINE 0.025000 0.175000 0.025000 0.175000 P R 0.012000
ECHAR
CHAR (
LINE 0.050000 -0.100000 -0.050000 0.000000 P R 0.012000
LINE -0.050000 0.000000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.050000 0.200000 P R 0.012000
ECHAR
CHAR )
LINE -0.050000 -0.100000 0.050000 0.000000 P R 0.012000
LINE 0.050000 0.000000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 -0.050000 0.200000 P R 0.012000
ECHAR
CHAR *
LINE -0.100000 -0.050000 0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 0.100000 -0.050000 P R 0.012000
LINE 0.000000 -0.100000 0.000000 0.200000 P R 0.012000
ECHAR
CHAR +
LINE -0.100000 0.050000 0.100000 0.050000 P R 0.012000
LINE 0.000000 -0.050000 0.000000 0.150000 P R 0.012000
ECHAR
CHAR ,
LINE 0.000000 -0.100000 0.050000 0.000000 P R 0.012000
LINE 0.025000 0.025000 0.025000 0.025000 P R 0.012000
ECHAR
CHAR -
LINE -0.100000 0.050000 0.100000 0.050000 P R 0.012000
ECHAR
CHAR .
LINE 0.025000 -0.075000 0.025000 -0.075000 P R 0.012000
ECHAR
CHAR /
LINE -0.100000 -0.050000 0.100000 0.150000 P R 0.012000
ECHAR
CHAR 0
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 0.100000 0.150000 P R 0.012000
ECHAR
CHAR 1
LINE -0.050000 0.150000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 0.000000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
ECHAR
CHAR 2
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.100000 P R 0.012000
LINE 0.100000 0.100000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 0.000000 0.050000 P R 0.012000
LINE 0.000000 0.050000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR 3
LINE -0.100000 0.200000 0.100000 0.200000 P R 0.012000
LINE 0.100000 0.200000 0.100000 0.100000 P R 0.012000
LINE 0.100000 0.100000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 0.000000 0.050000 P R 0.012000
LINE 0.050000 0.050000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR 4
LINE 0.050000 -0.100000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 -0.100000 0.000000 P R 0.012000
LINE -0.100000 0.000000 0.100000 0.000000 P R 0.012000
ECHAR
CHAR 5
LINE 0.100000 0.200000 -0.100000 0.200000 P R 0.012000
LINE -0.100000 0.200000 -0.100000 0.100000 P R 0.012000
LINE -0.100000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR 6
LINE 0.100000 0.200000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 -0.100000 0.100000 P R 0.012000
LINE -0.100000 0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 -0.100000 0.050000 P R 0.012000
ECHAR
CHAR 7
LINE -0.100000 0.200000 0.100000 0.200000 P R 0.012000
LINE 0.100000 0.200000 -0.050000 -0.100000 P R 0.012000
ECHAR
CHAR 8
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE -0.050000 0.050000 0.050000 0.050000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE -0.100000 0.150000 -0.100000 0.100000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.100000 P R 0.012000
LINE -0.100000 0.000000 -0.100000 -0.050000 P R 0.012000
LINE 0.100000 0.000000 0.100000 -0.050000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE -0.050000 0.200000 -0.100000 0.150000 P R 0.012000
LINE 0.050000 0.050000 0.100000 0.100000 P R 0.012000
LINE -0.050000 0.050000 -0.100000 0.100000 P R 0.012000
LINE 0.050000 0.050000 0.100000 0.000000 P R 0.012000
LINE -0.050000 0.050000 -0.100000 0.000000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR 9
LINE -0.100000 -0.100000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.100000 0.100000 P R 0.012000
LINE -0.100000 0.100000 -0.050000 0.050000 P R 0.012000
LINE -0.050000 0.050000 0.100000 0.050000 P R 0.012000
ECHAR
CHAR :
LINE 0.000000 0.012000 0.000000 0.012000 P R 0.012000
LINE 0.000000 -0.025000 0.000000 -0.025000 P R 0.012000
ECHAR
CHAR ;
LINE 0.000000 0.025000 -0.050000 -0.100000 P R 0.012000
LINE 0.000000 0.025000 0.000000 0.025000 P R 0.012000
LINE 0.000000 0.175000 0.000000 0.175000 P R 0.012000
ECHAR
CHAR <
LINE 0.100000 0.200000 -0.050000 0.050000 P R 0.012000
LINE -0.050000 0.050000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR =
LINE -0.100000 0.100000 0.100000 0.100000 P R 0.012000
LINE -0.100000 0.000000 0.100000 0.000000 P R 0.012000
ECHAR
CHAR >
LINE -0.100000 0.200000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 -0.100000 -0.100000 P R 0.012000
ECHAR
CHAR ?
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.000000 0.050000 P R 0.012000
LINE 0.000000 0.050000 0.000000 0.000000 P R 0.012000
LINE 0.000000 -0.100000 0.000000 -0.100000 P R 0.012000
ECHAR
CHAR @
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.000000 0.000000 P R 0.012000
LINE 0.000000 0.000000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR A
LINE -0.100000 -0.100000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.050000 0.100000 0.050000 P R 0.012000
ECHAR
CHAR B
LINE -0.100000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.100000 P R 0.012000
LINE 0.100000 0.100000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.100000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.050000 0.050000 0.050000 P R 0.012000
ECHAR
CHAR C
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
ECHAR
CHAR D
LINE -0.100000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.100000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.050000 0.200000 P R 0.012000
ECHAR
CHAR E
LINE -0.100000 0.200000 0.100000 0.200000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.050000 0.050000 0.050000 P R 0.012000
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
ECHAR
CHAR F
LINE -0.100000 0.200000 0.100000 0.200000 P R 0.012000
LINE -0.100000 0.050000 0.050000 0.050000 P R 0.012000
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
ECHAR
CHAR G
LINE -0.050000 0.200000 0.100000 0.200000 P R 0.012000
LINE -0.050000 0.200000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.050000 0.050000 P R 0.012000
ECHAR
CHAR H
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE 0.100000 0.200000 0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.050000 0.100000 0.050000 P R 0.012000
ECHAR
CHAR I
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.000000 0.200000 0.000000 -0.100000 P R 0.012000
ECHAR
CHAR J
LINE 0.100000 0.200000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR K
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE 0.100000 0.200000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR L
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR M
LINE -0.100000 -0.100000 -0.100000 0.200000 P R 0.012000
LINE -0.100000 0.200000 0.000000 0.050000 P R 0.012000
LINE 0.000000 0.050000 0.100000 0.200000 P R 0.012000
LINE 0.100000 0.200000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR N
LINE -0.100000 -0.100000 -0.100000 0.200000 P R 0.012000
LINE -0.100000 0.200000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 0.100000 0.200000 P R 0.012000
ECHAR
CHAR O
LINE -0.100000 -0.050000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR P
LINE -0.100000 -0.100000 -0.100000 0.200000 P R 0.012000
LINE -0.100000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.100000 P R 0.012000
LINE 0.100000 0.100000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 -0.100000 0.050000 P R 0.012000
ECHAR
CHAR Q
LINE -0.100000 -0.050000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
LINE 0.000000 0.000000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR R
LINE -0.100000 -0.100000 -0.100000 0.200000 P R 0.012000
LINE -0.100000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE 0.100000 0.150000 0.100000 0.100000 P R 0.012000
LINE 0.100000 0.100000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 -0.100000 0.050000 P R 0.012000
LINE -0.050000 0.050000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR S
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.050000 0.050000 P R 0.012000
LINE 0.050000 0.050000 -0.050000 0.050000 P R 0.012000
LINE -0.050000 0.050000 -0.100000 0.100000 P R 0.012000
LINE -0.100000 0.100000 -0.100000 0.150000 P R 0.012000
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
ECHAR
CHAR T
LINE -0.100000 0.200000 0.100000 0.200000 P R 0.012000
LINE 0.000000 0.200000 0.000000 -0.100000 P R 0.012000
ECHAR
CHAR U
LINE -0.100000 0.200000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.100000 0.200000 P R 0.012000
ECHAR
CHAR V
LINE -0.100000 0.200000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.100000 0.200000 P R 0.012000
ECHAR
CHAR W
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.000000 0.050000 P R 0.012000
LINE 0.000000 0.050000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 0.100000 0.200000 P R 0.012000
ECHAR
CHAR X
LINE -0.100000 0.200000 0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 0.200000 P R 0.012000
ECHAR
CHAR Y
LINE -0.100000 0.200000 0.000000 0.050000 P R 0.012000
LINE 0.000000 0.050000 0.100000 0.200000 P R 0.012000
LINE 0.000000 0.050000 0.000000 -0.100000 P R 0.012000
ECHAR
CHAR Z
LINE -0.100000 0.200000 0.100000 0.200000 P R 0.012000
LINE 0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR [
LINE 0.050000 0.200000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.050000 -0.100000 P R 0.012000
ECHAR)";

const std::string odb_fonts2 = R"(
CHAR \
LINE -0.100000 0.200000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR ]
LINE -0.050000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
ECHAR
CHAR ^
LINE -0.100000 0.100000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR _
LINE -0.100000 -0.100000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR `
LINE -0.050000 0.200000 0.000000 0.050000 P R 0.012000
ECHAR
CHAR a
LINE -0.050000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 0.000000 P R 0.012000
LINE -0.050000 0.000000 0.100000 0.000000 P R 0.012000
ECHAR
CHAR b
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 -0.100000 0.050000 P R 0.012000
ECHAR
CHAR c
LINE 0.100000 0.100000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR d
LINE 0.100000 0.200000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 0.100000 0.050000 P R 0.012000
ECHAR
CHAR e
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.050000 0.000000 P R 0.012000
LINE 0.050000 0.000000 -0.100000 0.000000 P R 0.012000
ECHAR
CHAR f
LINE -0.050000 -0.100000 -0.050000 0.150000 P R 0.012000
LINE -0.050000 0.150000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 0.050000 0.200000 P R 0.012000
LINE 0.050000 0.200000 0.100000 0.150000 P R 0.012000
LINE -0.100000 0.050000 0.000000 0.050000 P R 0.012000
ECHAR
CHAR g
LINE -0.050000 -0.150000 0.050000 -0.150000 P R 0.012000
LINE 0.050000 -0.150000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.100000 0.000000 P R 0.012000
LINE -0.100000 0.000000 -0.050000 -0.050000 P R 0.012000
LINE -0.050000 -0.050000 0.100000 -0.050000 P R 0.012000
ECHAR
CHAR h
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.050000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR i
LINE 0.000000 0.100000 0.000000 -0.050000 P R 0.012000
LINE 0.000000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.000000 0.200000 0.000000 0.200000 P R 0.012000
ECHAR
CHAR j
LINE 0.050000 0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.000000 -0.150000 P R 0.012000
LINE 0.000000 -0.150000 -0.050000 -0.150000 P R 0.012000
LINE -0.050000 -0.150000 -0.100000 -0.100000 P R 0.012000
LINE 0.050000 0.200000 0.050000 0.200000 P R 0.012000
ECHAR
CHAR k
LINE -0.100000 0.200000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.000000 0.000000 0.000000 P R 0.012000
LINE 0.000000 0.000000 0.100000 -0.100000 P R 0.012000
LINE -0.050000 0.000000 0.050000 0.100000 P R 0.012000
ECHAR
CHAR l
LINE -0.050000 0.200000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 0.000000 -0.050000 P R 0.012000
LINE 0.000000 -0.050000 0.050000 -0.100000 P R 0.012000
ECHAR
CHAR m
LINE -0.100000 -0.100000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.000000 0.050000 P R 0.012000
LINE 0.000000 0.050000 0.000000 0.000000 P R 0.012000
LINE 0.000000 0.050000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR n
LINE -0.100000 0.100000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.000000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR o
LINE -0.100000 -0.050000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR p
LINE -0.100000 -0.150000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.100000 0.000000 P R 0.012000
LINE 0.100000 0.000000 0.050000 -0.050000 P R 0.012000
LINE 0.050000 -0.050000 -0.100000 -0.050000 P R 0.012000
ECHAR
CHAR q
LINE 0.100000 -0.150000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.100000 0.000000 P R 0.012000
LINE -0.100000 0.000000 -0.050000 -0.050000 P R 0.012000
LINE -0.050000 -0.050000 0.100000 -0.050000 P R 0.012000
ECHAR
CHAR r
LINE -0.100000 0.100000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 0.000000 0.000000 0.100000 P R 0.012000
LINE 0.000000 0.100000 0.050000 0.050000 P R 0.012000
ECHAR
CHAR s
LINE -0.100000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 -0.050000 0.050000 0.000000 P R 0.012000
LINE 0.050000 0.000000 -0.050000 0.000000 P R 0.012000
LINE -0.050000 0.000000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR t
LINE -0.050000 0.200000 -0.050000 -0.050000 P R 0.012000
LINE -0.050000 -0.050000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 -0.050000 P R 0.012000
LINE -0.100000 0.100000 0.050000 0.100000 P R 0.012000
ECHAR
CHAR u
LINE -0.100000 0.100000 -0.100000 -0.050000 P R 0.012000
LINE -0.100000 -0.050000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.100000 0.000000 P R 0.012000
LINE 0.100000 -0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR v
LINE -0.100000 0.100000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR w
LINE -0.100000 0.100000 -0.050000 -0.100000 P R 0.012000
LINE -0.050000 -0.100000 0.000000 0.000000 P R 0.012000
LINE 0.000000 0.000000 0.050000 -0.100000 P R 0.012000
LINE 0.050000 -0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR x
LINE -0.100000 0.100000 0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 0.100000 P R 0.012000
ECHAR
CHAR y
LINE -0.100000 0.100000 -0.100000 0.000000 P R 0.012000
LINE -0.100000 0.000000 -0.050000 -0.050000 P R 0.012000
LINE -0.050000 -0.050000 0.100000 -0.050000 P R 0.012000
LINE 0.100000 0.100000 0.100000 -0.100000 P R 0.012000
LINE 0.100000 -0.100000 0.050000 -0.150000 P R 0.012000
LINE 0.050000 -0.150000 -0.050000 -0.150000 P R 0.012000
ECHAR
CHAR z
LINE -0.100000 0.100000 0.100000 0.100000 P R 0.012000
LINE 0.100000 0.100000 -0.100000 -0.100000 P R 0.012000
LINE -0.100000 -0.100000 0.100000 -0.100000 P R 0.012000
ECHAR
CHAR {
LINE 0.050000 0.200000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 -0.050000 0.150000 P R 0.012000
LINE -0.050000 0.150000 -0.050000 0.100000 P R 0.012000
LINE -0.050000 0.100000 -0.100000 0.050000 P R 0.012000
LINE -0.100000 0.050000 -0.050000 0.000000 P R 0.012000
LINE -0.050000 0.000000 -0.050000 -0.050000 P R 0.012000
LINE -0.050000 -0.050000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 0.050000 -0.100000 P R 0.012000
ECHAR
CHAR |
LINE 0.000000 0.200000 0.000000 -0.100000 P R 0.012000
ECHAR
CHAR }
LINE -0.050000 0.200000 0.000000 0.200000 P R 0.012000
LINE 0.000000 0.200000 0.050000 0.150000 P R 0.012000
LINE 0.050000 0.150000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.050000 P R 0.012000
LINE 0.100000 0.050000 0.050000 0.000000 P R 0.012000
LINE 0.050000 0.000000 0.050000 -0.050000 P R 0.012000
LINE 0.050000 -0.050000 0.000000 -0.100000 P R 0.012000
LINE 0.000000 -0.100000 -0.050000 -0.100000 P R 0.012000
ECHAR
CHAR ~
LINE -0.100000 0.150000 -0.050000 0.200000 P R 0.012000
LINE -0.050000 0.200000 0.050000 0.100000 P R 0.012000
LINE 0.050000 0.100000 0.100000 0.150000 P R 0.012000
ECHAR)";

// just implementation here
void ODB_FONTS_ENTITY::GenerateFiles( ODB_TREE_WRITER& writer )
{
    auto fileproxy = writer.CreateFileProxy( "standard" );

    fileproxy.GetStream() << odb_fonts1 << odb_fonts2 << std::endl;
}
