/***************************************************************************
                          kmessviewdelegate.h -  description
                             -------------------
    begin                : Sat Feb 16 2008
    copyright            : (C) 2008 by Valerio Pilo
    email                : valerio@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSVIEWDELEGATE_H
#define KMESSVIEWDELEGATE_H

#include <QStyledItemDelegate>
#include <QPixmap>

// Forward declarations
class CurrentAccount;
class QFont;
class QLabel;
class QTextDocument;


/**
 * Displays a contact list item using its model
 *
 * This class is used by a Contact List view to display a single contact
 * or group. It receives the data to display from the Contact List model and paints
 * it directly.
 *
 * @author Valerio Pilo <valerio@kmess.org>
 * @ingroup Root
 */
class KMessViewDelegate : public QStyledItemDelegate
{
  public:

    // Constructor
                    KMessViewDelegate( QWidget *parent = 0 );
    // Destructor
                   ~KMessViewDelegate();


  public: // Public methods

    // Paint an item of the contact list
    void            paint( QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index ) const;
    // Return an hint about the size of an item
    QSize           sizeHint( const QStyleOptionViewItem &option, const QModelIndex &index ) const;


  private: // Private properties

    // Reference to the current account's properties
    CurrentAccount *currentAccount_;
    // Bold font
    QFont           fontBold_;
    // Cached emoticon replacement for the now listening icon
    QString         mediaEmoticonMusic_;
    // Cached emoticon replacement for the now playing icon
    QString         mediaEmoticonGaming_;
    // QTextDocument for rich text painting
    QTextDocument  *textDocument_;

    // cached icons.
    QPixmap         arrowUp_, arrowDown_, arrowLeft_, arrowRight_;
};



#endif
