// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2009 Konrad Twardowski

// An inactivity monitor

#pragma once

#include "datetime.h"
#include "../kshutdown.h"

class IdleMonitor final: public DateTimeTriggerBase {
public:
	explicit IdleMonitor();
	virtual ~IdleMonitor() = default;
	virtual bool canActivateAction() override;
	virtual QString getStringOption() override;
	virtual void setStringOption(const QString &option) override;
	virtual void initDateTimeWidget(QDateTimeEdit *dateTimeEdit) override;
	bool isSupported() const { return m_supported; }
	virtual void setState(const State state) override;
protected:
	virtual void updateStatus() override;
private:
	Q_DISABLE_COPY(IdleMonitor)
	bool m_supported;
	seconds getSessionIdleTime();
};
