# -*- perl -*-
#
# $Id:  $
#
# nomencl.perl
#   Georgy Salnikov <sge@nmr.nioch.nsc.ru> 27/12/20
#
# Extension to LaTeX2HTML V2020 to partly support the "nomencl" package
#
# $Log:  $
#
# Note:
# This module provides reading and translation of the nomenclature (.nls) file
# generated by makeindex from the .nlo file (the latter being created by LaTeX)
# makeindex <file>.nlo -s nomencl.ist -o <file>.nls
#
# The commands \makenomenclature and \nomenclature are taken into account by
# LaTeX and silently ignored by this module as the result only is interpreted.
#
# thenomenclature environment generated by makeindex contains the commands
# \nomgroup, \nomeqref, \nompageref which are also ignored.
#
# Package option [intoc] and the \nomname definition are taken into account
# by \printnomenclature to ensure generation of proper heading and segmenting.
#
# The rest of the nomencl package is not yet implemented.

package main;

# for debugging only
#print "\nUsing nomencl.perl\n";

# Just mark the existence of the option for the later checking
sub do_nomencl_intoc {
  $styles_loaded{'nomencl_intoc'} = 1;
}

# Explicitly cancel the default option
sub do_nomencl_notintoc {
  delete ($styles_loaded{'nomencl_intoc'})
    if (exists ($styles_loaded{'nomencl_intoc'}));
}

# .nls file is very similar to a \begin{description} environment
sub do_env_thenomenclature {
  local($_) = @_;

#  # The following 3 function calls would yield a compact list
#  $_ = &list_helper($_, 'DL');
#  $_ = &translate_environments($_);
#  $_ = &translate_commands($_);

  # The following generates a list similar to description environment
  # Evtl catch nested lists
  &protect_useritems($_);

  s/\n?$item_description_rx\s*($labels_rx8)?\s*/"\n<\/DD>\n<DT>" .
    (($9) ? "<A ID=\"$9\">$1<\/A>" : $1) . "<\/DT>\n<DD>"/egm;

  $_ = &translate_environments($_);
  $_ = &translate_commands($_);

  # just for safety in case the description is empty ...
  s/\n?\\item\b\s*([^$letters\\]|)\s*/\n<\/DD>\n<DT><\/DT>\n<DD>$1/gm;
  s/^\s+//m;

  # Wrap the whole description with the appropriate opening/closing tags
  $_ = '<DD>'.$_ unless ($_ =~ s/^\s*<\/D(T|D)>\n?//s);
  $_ =~ s/\n$//s;
  "<DL>\n$_\n</DD>\n</DL>";
}

# Generate nomenclature with heading and optional sectioning
sub do_cmd_printnomenclature {
  local($_) = @_;

  local($dum1, $dum2, $after);
  ($dum1,$dum2) = &get_next_optional_argument; # discard optional argument
  $after = $_;

  # Make the appropriate heading
  local($br_id, $title);
  if ((defined &do_cmd_nomname) || $new_command{'nomname'}) {
    $br_id = ++$global{'max_id'};
    $title = &translate_environments("$O$br_id$C\\nomname$O$br_id$C");
  } else { $title = $nom_title; }
  $nomfile = $CURRENT_FILE;  # sets  $nomfile  this globally

  # Ensure also segmenting if intoc requested
  $toc_sec_title = $TITLE = $title if ($styles_loaded{'nomencl_intoc'});

  # Load and interpret .nls file
  local($EXTERNAL_FILE) = '';
  unless (&process_ext_file('nls')) { # *** BINDS $_ as a side effect ***
    print "\nCannot open $FILE.nls: $!\n";
    &write_warnings("\nThe nomenclature file was not found.");
    $_ = "\n<H2>No Nomenclature!</H2>\n";
  }

  # Put the result in the right place
  local($closures,$reopens) = &preserve_open_tags();
  join('', "<BR>\n", $closures,
       &make_section_heading($title, $section_headings{'nomenclature'}),
       $_, $reopens, $after);
}

## Discard all arguments, the following white space and possible paragraphs.
## Simple ignoration leaves repeated unnecessary <P>'s.
## Changed to a special ignoration followed by regular expression.
## Left here in commented out form just for reference/debugging.
#sub do_cmd_nomenclature {
#  local($_) = @_;
#
#  local($dum1, $dum2);
#  ($dum1,$dum2) = &get_next_optional_argument;
#  $dum1 = &missing_braces unless (
#    (s/$next_pair_pr_rx/$option=$2;''/eo)
#    ||(s/$next_pair_rx/$option=$2;''/eo));
#  $dum2 = &missing_braces unless (
#    (s/$next_pair_pr_rx/$option=$2;''/eo)
#    ||(s/$next_pair_rx/$option=$2;''/eo));
#  s/^(\s*<P>)*\s*/\n/;
#
#  $_;
#}

&ignore_commands (<<_IGNORED_CMDS_);
makenomenclature
nomenclature # [] # {} # {} # s/^(\\s*<P>)*\\s*/\\n/;
nomgroup # {}
nomeqref # {}
nompageref # {}
nomrefeq
nomrefpage
nomrefeqpage
nomnorefeq
nomnorefpage
nomnorefeqpage
_IGNORED_CMDS_

&process_commands_wrap_deferred (<<_RAW_ARG_DEFERRED_CMDS_);
printnomenclature # []
_RAW_ARG_DEFERRED_CMDS_

1;	# Must be last line
