/* ----------------------------------------------------------------------
    This is the

    ██╗     ██╗ ██████╗  ██████╗  ██████╗ ██╗  ██╗████████╗███████╗
    ██║     ██║██╔════╝ ██╔════╝ ██╔════╝ ██║  ██║╚══██╔══╝██╔════╝
    ██║     ██║██║  ███╗██║  ███╗██║  ███╗███████║   ██║   ███████╗
    ██║     ██║██║   ██║██║   ██║██║   ██║██╔══██║   ██║   ╚════██║
    ███████╗██║╚██████╔╝╚██████╔╝╚██████╔╝██║  ██║   ██║   ███████║
    ╚══════╝╚═╝ ╚═════╝  ╚═════╝  ╚═════╝ ╚═╝  ╚═╝   ╚═╝   ╚══════╝®

    DEM simulation engine, released by
    DCS Computing Gmbh, Linz, Austria
    http://www.dcs-computing.com, office@dcs-computing.com

    LIGGGHTS® is part of CFDEM®project:
    http://www.liggghts.com | http://www.cfdem.com

    Core developer and main author:
    Christoph Kloss, christoph.kloss@dcs-computing.com

    LIGGGHTS® is open-source, distributed under the terms of the GNU Public
    License, version 2 or later. It is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. You should have
    received a copy of the GNU General Public License along with LIGGGHTS®.
    If not, see http://www.gnu.org/licenses . See also top-level README
    and LICENSE files.

    LIGGGHTS® and CFDEM® are registered trade marks of DCS Computing GmbH,
    the producer of the LIGGGHTS® software and the CFDEM®coupling software
    See http://www.cfdem.com/terms-trademark-policy for details.

-------------------------------------------------------------------------
    Contributing author and copyright for this file:
    (if not contributing author is listed, this file has been contributed
    by the core developer)
    Arno Mayrhofer (DCS Computing GmbH, Linz)

    Copyright 2017-     DCS Computing GmbH, Linz
------------------------------------------------------------------------- */

#ifdef COMPUTE_CLASS

ComputeStyle(erotate,ComputeERotate)

#else

#ifndef LMP_COMPUTE_EROTATE_H
#define LMP_COMPUTE_EROTATE_H

#include "compute.h"
#include "compute_erotate_sphere.h"
#include "compute_erotate_multisphere.h"

#ifdef SUPERQUADRIC_ACTIVE_FLAG
#include "compute_erotate_superquadric.h"
#endif

namespace LAMMPS_NS
{

class ComputeERotate : public Compute
{
public:
    ComputeERotate(class LAMMPS *, int &iarg, int, char **);
    ~ComputeERotate() {}
    void init();
    void post_create();
    double compute_scalar();

private:
    ComputeERotateSphere * csphere_;
    ComputeERotateMultisphere * cms_;
#ifdef SUPERQUADRIC_ACTIVE_FLAG
    ComputeERotateSuperquadric * csq_;
#endif
    char * id_group_;
};

}

#endif
#endif

