; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=5 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
target datalayout = "E-p:64:64:64-a0:0:8-f32:32:32-f64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-v64:64:64-v128:128:128"

define internal i32 @test(ptr %X, ptr %Y) {
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(argmem: read)
; CGSCC-LABEL: define {{[^@]+}}@test
; CGSCC-SAME: (i32 [[TMP0:%.*]], ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[Y:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:    [[X_PRIV:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 [[TMP0]], ptr [[X_PRIV]], align 4
; CGSCC-NEXT:    [[A:%.*]] = load i32, ptr [[X_PRIV]], align 4
; CGSCC-NEXT:    [[B:%.*]] = load i32, ptr [[Y]], align 4
; CGSCC-NEXT:    [[C:%.*]] = add i32 [[A]], [[B]]
; CGSCC-NEXT:    ret i32 [[C]]
;
  %A = load i32, ptr %X
  %B = load i32, ptr %Y
  %C = add i32 %A, %B
  ret i32 %C
}

define internal i32 @caller(ptr %B) {
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: (i32 [[TMP0:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[B_PRIV:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 [[TMP0]], ptr [[B_PRIV]], align 4
; CGSCC-NEXT:    [[C:%.*]] = call i32 @test(i32 noundef 1, ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B_PRIV]]) #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[C]]
;
  %A = alloca i32
  store i32 1, ptr %A
  %C = call i32 @test(ptr %A, ptr %B)
  ret i32 %C
}

define i32 @callercaller() {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@callercaller
; TUNIT-SAME: () #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:    [[B:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    ret i32 3
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@callercaller
; CGSCC-SAME: () #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:    [[X:%.*]] = call i32 @caller(i32 noundef 2) #[[ATTR4:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[X]]
;
  %B = alloca i32
  store i32 2, ptr %B
  %X = call i32 @caller(ptr %B)
  ret i32 %X
}

;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(none) }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(argmem: read) }
; CGSCC: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR2]] = { nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR3]] = { willreturn memory(read) }
; CGSCC: attributes #[[ATTR4]] = { nounwind willreturn }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
