; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -slp-threshold=-6 -passes=slp-vectorizer,instcombine -mattr=+sse2 -S | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: opt < %s -slp-threshold=-6 -passes=slp-vectorizer,instcombine -mattr=+avx  -S | FileCheck %s --check-prefixes=CHECK,AVX
; RUN: opt < %s -slp-threshold=-6 -passes=slp-vectorizer,instcombine -mattr=+avx2 -S | FileCheck %s --check-prefixes=CHECK,AVX

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; These tests ensure that we do not regress due to PR31243. Note that we set
; the SLP threshold to force vectorization even when not profitable.

; When computing minimum sizes, if we can prove the sign bit is zero, we can
; zero-extend the roots back to their original sizes.
;
define i8 @PR31243_zext(i8 %v0, i8 %v1, i8 %v2, i8 %v3, ptr %ptr) {
; CHECK-LABEL: @PR31243_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = insertelement <2 x i8> poison, i8 [[V0:%.*]], i64 0
; CHECK-NEXT:    [[TMP1:%.*]] = insertelement <2 x i8> [[TMP0]], i8 [[V1:%.*]], i64 1
; CHECK-NEXT:    [[TMP2:%.*]] = or <2 x i8> [[TMP1]], <i8 1, i8 1>
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x i8> [[TMP2]], i64 0
; CHECK-NEXT:    [[TMP4:%.*]] = zext i8 [[TMP3]] to i64
; CHECK-NEXT:    [[TMP_4:%.*]] = getelementptr inbounds i8, ptr [[PTR:%.*]], i64 [[TMP4]]
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <2 x i8> [[TMP2]], i64 1
; CHECK-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i64
; CHECK-NEXT:    [[TMP_5:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 [[TMP6]]
; CHECK-NEXT:    [[TMP_6:%.*]] = load i8, ptr [[TMP_4]], align 1
; CHECK-NEXT:    [[TMP_7:%.*]] = load i8, ptr [[TMP_5]], align 1
; CHECK-NEXT:    [[TMP_8:%.*]] = add i8 [[TMP_6]], [[TMP_7]]
; CHECK-NEXT:    ret i8 [[TMP_8]]
;
entry:
  %tmp_0 = zext i8 %v0 to i32
  %tmp_1 = zext i8 %v1 to i32
  %tmp_2 = or i32 %tmp_0, 1
  %tmp_3 = or i32 %tmp_1, 1
  %tmp_4 = getelementptr inbounds i8, ptr %ptr, i32 %tmp_2
  %tmp_5 = getelementptr inbounds i8, ptr %ptr, i32 %tmp_3
  %tmp_6 = load i8, ptr %tmp_4
  %tmp_7 = load i8, ptr %tmp_5
  %tmp_8 = add i8 %tmp_6, %tmp_7
  ret i8 %tmp_8
}

; When computing minimum sizes, if we cannot prove the sign bit is zero, we
; have to include one extra bit for signedness since we will sign-extend the
; roots.
;
; FIXME: This test is suboptimal since the compuation can be performed in i8.
;        In general, we need to add an extra bit to the maximum bit width only
;        if we can't prove that the upper bit of the original type is equal to
;        the upper bit of the proposed smaller type. If these two bits are the
;        same (either zero or one) we know that sign-extending from the smaller
;        type will result in the same value. Since we don't yet perform this
;        optimization, we make the proposed smaller type (i8) larger (i16) to
;        ensure correctness.
;
define i8 @PR31243_sext(i8 %v0, i8 %v1, i8 %v2, i8 %v3, ptr %ptr) {
; SSE-LABEL: @PR31243_sext(
; SSE-NEXT:  entry:
; SSE-NEXT:    [[TMP0:%.*]] = or i8 [[V0:%.*]], 1
; SSE-NEXT:    [[TMP1:%.*]] = or i8 [[V1:%.*]], 1
; SSE-NEXT:    [[TMP2:%.*]] = sext i8 [[TMP0]] to i64
; SSE-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i8, ptr [[PTR:%.*]], i64 [[TMP2]]
; SSE-NEXT:    [[TMP3:%.*]] = sext i8 [[TMP1]] to i64
; SSE-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 [[TMP3]]
; SSE-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
; SSE-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP5]], align 1
; SSE-NEXT:    [[TMP8:%.*]] = add i8 [[TMP6]], [[TMP7]]
; SSE-NEXT:    ret i8 [[TMP8]]
;
; AVX-LABEL: @PR31243_sext(
; AVX-NEXT:  entry:
; AVX-NEXT:    [[TMP0:%.*]] = insertelement <2 x i8> poison, i8 [[V0:%.*]], i64 0
; AVX-NEXT:    [[TMP1:%.*]] = insertelement <2 x i8> [[TMP0]], i8 [[V1:%.*]], i64 1
; AVX-NEXT:    [[TMP2:%.*]] = or <2 x i8> [[TMP1]], <i8 1, i8 1>
; AVX-NEXT:    [[TMP3:%.*]] = sext <2 x i8> [[TMP2]] to <2 x i16>
; AVX-NEXT:    [[TMP4:%.*]] = extractelement <2 x i16> [[TMP3]], i64 0
; AVX-NEXT:    [[TMP5:%.*]] = sext i16 [[TMP4]] to i64
; AVX-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i8, ptr [[PTR:%.*]], i64 [[TMP5]]
; AVX-NEXT:    [[TMP6:%.*]] = extractelement <2 x i16> [[TMP3]], i64 1
; AVX-NEXT:    [[TMP7:%.*]] = sext i16 [[TMP6]] to i64
; AVX-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 [[TMP7]]
; AVX-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
; AVX-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP5]], align 1
; AVX-NEXT:    [[TMP8:%.*]] = add i8 [[TMP6]], [[TMP7]]
; AVX-NEXT:    ret i8 [[TMP8]]
;
entry:
  %tmp0 = sext i8 %v0 to i32
  %tmp1 = sext i8 %v1 to i32
  %tmp2 = or i32 %tmp0, 1
  %tmp3 = or i32 %tmp1, 1
  %tmp4 = getelementptr inbounds i8, ptr %ptr, i32 %tmp2
  %tmp5 = getelementptr inbounds i8, ptr %ptr, i32 %tmp3
  %tmp6 = load i8, ptr %tmp4
  %tmp7 = load i8, ptr %tmp5
  %tmp8 = add i8 %tmp6, %tmp7
  ret i8 %tmp8
}
