; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; FIXME: This is technically incorrect because it might overwrite a poison
; value. Stop folding it once #52930 is resolved.
define void @store_of_undef(ptr %P) {
; CHECK-LABEL: @store_of_undef(
; CHECK-NEXT:    ret void
;
  store i32 undef, ptr %P
  ret void
}

define void @store_of_poison(ptr %P) {
; CHECK-LABEL: @store_of_poison(
; CHECK-NEXT:    ret void
;
  store i32 poison, ptr %P
  ret void
}

define void @store_into_undef(ptr %P) {
; CHECK-LABEL: @store_into_undef(
; CHECK-NEXT:    store i32 123, ptr undef, align 4
; CHECK-NEXT:    ret void
;
  store i32 123, ptr undef
  ret void
}

define void @store_into_null(ptr %P) {
; CHECK-LABEL: @store_into_null(
; CHECK-NEXT:    store i32 poison, ptr null, align 4294967296
; CHECK-NEXT:    ret void
;
  store i32 124, ptr null
  ret void
}

define void @test2(ptr %P) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret void
;
  %X = load i32, ptr %P
  %Y = add i32 %X, 0
  store i32 %Y, ptr %P
  ret void
}

define void @store_at_gep_off_null_inbounds(i64 %offset) {
; CHECK-LABEL: @store_at_gep_off_null_inbounds(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr inbounds i32, ptr null, i64 [[OFFSET:%.*]]
; CHECK-NEXT:    store i32 poison, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
  %ptr = getelementptr inbounds i32, ptr null, i64 %offset
  store i32 24, ptr %ptr
  ret void
}

define void @store_at_gep_off_null_not_inbounds(i64 %offset) {
; CHECK-LABEL: @store_at_gep_off_null_not_inbounds(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr i32, ptr null, i64 [[OFFSET:%.*]]
; CHECK-NEXT:    store i32 poison, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
  %ptr = getelementptr i32, ptr null, i64 %offset
  store i32 24, ptr %ptr
  ret void
}

define void @store_at_gep_off_no_null_opt(i64 %offset) #0 {
; CHECK-LABEL: @store_at_gep_off_no_null_opt(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr inbounds i32, ptr null, i64 [[OFFSET:%.*]]
; CHECK-NEXT:    store i32 24, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
  %ptr = getelementptr inbounds i32, ptr null, i64 %offset
  store i32 24, ptr %ptr
  ret void
}

attributes #0 = { null_pointer_is_valid }

;; Simple sinking tests

; "if then else"
define i32 @test3(i1 %C) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[COND:%.*]], label [[COND2:%.*]]
; CHECK:       Cond:
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       Cond2:
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ 47, [[COND2]] ], [ -987654321, [[COND]] ]
; CHECK-NEXT:    ret i32 [[STOREMERGE]]
;
  %A = alloca i32
  br i1 %C, label %Cond, label %Cond2

Cond:
  store i32 -987654321, ptr %A
  br label %Cont

Cond2:
  store i32 47, ptr %A
  br label %Cont

Cont:
  %V = load i32, ptr %A
  ret i32 %V
}

; "if then"
define i32 @test4(i1 %C) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[COND:%.*]], label [[CONT:%.*]]
; CHECK:       Cond:
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ -987654321, [[COND]] ], [ 47, [[TMP0:%.*]] ]
; CHECK-NEXT:    ret i32 [[STOREMERGE]]
;
  %A = alloca i32
  store i32 47, ptr %A
  br i1 %C, label %Cond, label %Cont

Cond:
  store i32 -987654321, ptr %A
  br label %Cont

Cont:
  %V = load i32, ptr %A
  ret i32 %V
}

; "if then"
define void @test5(i1 %C, ptr %P) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[COND:%.*]], label [[CONT:%.*]]
; CHECK:       Cond:
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ -987654321, [[COND]] ], [ 47, [[TMP0:%.*]] ]
; CHECK-NEXT:    store i32 [[STOREMERGE]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    ret void
;
  store i32 47, ptr %P, align 1
  br i1 %C, label %Cond, label %Cont

Cond:
  store i32 -987654321, ptr %P, align 1
  br label %Cont

Cont:
  ret void
}


; PR14753 - merging two stores should preserve the TBAA tag.
define void @test6(i32 %n, ptr %a, ptr %gi) nounwind uwtable ssp {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ 42, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; CHECK-NEXT:    store i32 [[STOREMERGE]], ptr [[GI:%.*]], align 4, !tbaa [[TBAA0:![0-9]+]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[STOREMERGE]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[STOREMERGE]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[A:%.*]], i64 [[IDXPROM]]
; CHECK-NEXT:    store float 0.000000e+00, ptr [[ARRAYIDX]], align 4, !tbaa [[TBAA4:![0-9]+]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[GI]], align 4, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[INC]] = add nsw i32 [[TMP0]], 1
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  store i32 42, ptr %gi, align 4, !tbaa !0
  br label %for.cond

for.cond:
  %storemerge = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %0 = load i32, ptr %gi, align 4, !tbaa !0
  %cmp = icmp slt i32 %0, %n
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = sext i32 %0 to i64
  %arrayidx = getelementptr inbounds float, ptr %a, i64 %idxprom
  store float 0.000000e+00, ptr %arrayidx, align 4, !tbaa !3
  %1 = load i32, ptr %gi, align 4, !tbaa !0
  %inc = add nsw i32 %1, 1
  store i32 %inc, ptr %gi, align 4, !tbaa !0
  br label %for.cond

for.end:
  ret void
}

define void @dse1(ptr %p) {
; CHECK-LABEL: @dse1(
; CHECK-NEXT:    store i32 0, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %p
  store i32 0, ptr %p
  ret void
}

; Slightly subtle: if we're mixing atomic and non-atomic access to the
; same location, then the contents of the location are undefined if there's
; an actual race.  As such, we're free to pick either store under the
; assumption that we're not racing with any other thread.
define void @dse2(ptr %p) {
; CHECK-LABEL: @dse2(
; CHECK-NEXT:    store i32 0, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store atomic i32 0, ptr %p unordered, align 4
  store i32 0, ptr %p
  ret void
}

define void @dse3(ptr %p) {
; CHECK-LABEL: @dse3(
; CHECK-NEXT:    store atomic i32 0, ptr [[P:%.*]] unordered, align 4
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %p
  store atomic i32 0, ptr %p unordered, align 4
  ret void
}

define void @dse4(ptr %p) {
; CHECK-LABEL: @dse4(
; CHECK-NEXT:    store atomic i32 0, ptr [[P:%.*]] unordered, align 4
; CHECK-NEXT:    ret void
;
  store atomic i32 0, ptr %p unordered, align 4
  store atomic i32 0, ptr %p unordered, align 4
  ret void
}

; Implementation limit - could remove unordered store here, but
; currently don't.
define void @dse5(ptr %p) {
; CHECK-LABEL: @dse5(
; CHECK-NEXT:    store atomic i32 0, ptr [[P:%.*]] unordered, align 4
; CHECK-NEXT:    store atomic i32 0, ptr [[P]] seq_cst, align 4
; CHECK-NEXT:    ret void
;
  store atomic i32 0, ptr %p unordered, align 4
  store atomic i32 0, ptr %p seq_cst, align 4
  ret void
}

define void @write_back1(ptr %p) {
; CHECK-LABEL: @write_back1(
; CHECK-NEXT:    ret void
;
  %v = load i32, ptr %p
  store i32 %v, ptr %p
  ret void
}

define void @write_back2(ptr %p) {
; CHECK-LABEL: @write_back2(
; CHECK-NEXT:    ret void
;
  %v = load atomic i32, ptr %p unordered, align 4
  store i32 %v, ptr %p
  ret void
}

define void @write_back3(ptr %p) {
; CHECK-LABEL: @write_back3(
; CHECK-NEXT:    ret void
;
  %v = load i32, ptr %p
  store atomic i32 %v, ptr %p unordered, align 4
  ret void
}

define void @write_back4(ptr %p) {
; CHECK-LABEL: @write_back4(
; CHECK-NEXT:    ret void
;
  %v = load atomic i32, ptr %p unordered, align 4
  store atomic i32 %v, ptr %p unordered, align 4
  ret void
}

; Can't remove store due to ordering side effect
define void @write_back5(ptr %p) {
; CHECK-LABEL: @write_back5(
; CHECK-NEXT:    [[V:%.*]] = load atomic i32, ptr [[P:%.*]] unordered, align 4
; CHECK-NEXT:    store atomic i32 [[V]], ptr [[P]] seq_cst, align 4
; CHECK-NEXT:    ret void
;
  %v = load atomic i32, ptr %p unordered, align 4
  store atomic i32 %v, ptr %p seq_cst, align 4
  ret void
}

define void @write_back6(ptr %p) {
; CHECK-LABEL: @write_back6(
; CHECK-NEXT:    [[V:%.*]] = load atomic i32, ptr [[P:%.*]] seq_cst, align 4
; CHECK-NEXT:    ret void
;
  %v = load atomic i32, ptr %p seq_cst, align 4
  store atomic i32 %v, ptr %p unordered, align 4
  ret void
}

define void @write_back7(ptr %p) {
; CHECK-LABEL: @write_back7(
; CHECK-NEXT:    [[V:%.*]] = load atomic volatile i32, ptr [[P:%.*]] seq_cst, align 4
; CHECK-NEXT:    ret void
;
  %v = load atomic volatile i32, ptr %p seq_cst, align 4
  store atomic i32 %v, ptr %p unordered, align 4
  ret void
}

@Unknown = external constant i32

define void @store_to_constant() {
; CHECK-LABEL: @store_to_constant(
; CHECK-NEXT:    ret void
;
  store i32 0, ptr @Unknown
  ret void
}

; Delete stores to readonly noalias pointers.
define void @store_to_readonly_noalias(ptr readonly noalias %0) {
; CHECK-LABEL: @store_to_readonly_noalias(
; CHECK-NEXT:    ret void
;
  store i32 3, ptr %0, align 4
  ret void
}

!0 = !{!4, !4, i64 0}
!1 = !{!"omnipotent char", !2}
!2 = !{!"Simple C/C++ TBAA"}
!3 = !{!"float", !1}
!4 = !{!"int", !1}
