------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;
with GNATCOLL.GMP.Integers.Root_Extraction;

use GNAT.IO;
use GNATCOLL.GMP.Integers;
use GNATCOLL.GMP.Integers.Root_Extraction;

procedure Test_Roots is

   A, B : Big_Integer;

   Root_Value   : constant := 99_999;
   Raised_Value : constant String := "99995000000000000000000000000000";
   Was_Exact    : Boolean;

begin
   Set (A, "144");
   Get_SQRT (A, Into => B);

   if B /= 12 then
      Put_Line ("test_roots failed: sqrt of 144 should = 12");
   end if;

   Set (A, To => Root_Value);
   Raise_To_N (A, 5);
   Get_Nth_Root (A, N => 5, Into => B, Exact => Was_Exact);

   if B /= Root_Value then
      Put_Line ("test_roots failed: 5th root of " & Raised_Value &
                " should = " & Root_Value'Img);
   end if;

   if not Was_Exact then
      Put_Line ("test_roots failed: 5th root of "
                & Raised_Value & " should be exact");
   end if;

   Put_Line ("test_roots passed");
end Test_Roots;
