import unittest
from support import GNATCOLL_TestCase, chdir, pathsep
import sys


def requires_python(func):
    def wrapped(*args):
        if file("../Makefile.conf").read().find("WITH_PYTHON=yes") > 0:
            return func(*args)
        if hasattr(unittest, "SkipTest"):
            raise unittest.SkipTest("No python support")
    wrapped.__name__ = func.__name__
    return wrapped


class Test(GNATCOLL_TestCase):
    @requires_python
    @chdir("completion")
    def test_completion(self):
        self.gprbuild()
        self.runexec("obj/testapi", "testapi.out")

    @requires_python
    @chdir("python")
    def test_python1(self):
        self.gprbuild()
        self.runexec(["obj/testsuite", "python", "scripts1.py"],
                     "scripts1.out")

    @requires_python
    @chdir("python")
    def test_python3(self):
        self.gprbuild()
        self.runexec(["obj/testsuite", "python", "scripts3.py"],
                     "scripts3.out")

    @requires_python
    @chdir("python_leaks")
    def test_python_leaks(self):
        self.gprbuild()
        self.runexec(["obj/leaks"], "test.out")

    @chdir("python")
    def test_shell(self):
        self.gprbuild()
        self.runexec(["obj/testsuite", "shell", "scripts2.gsh"],
                     "scripts2.out")

    @requires_python
    @chdir("K318_018")
    def test_K318_018(self):
        self.gprbuild()
        self.runexec("obj/testpython", "K318_018.out")

    @requires_python
    @chdir("M701-028-dict-iter")
    def test_M701_028(self):
        self.gprbuild("pytestcase.gpr")
        self.runexec("bin/pytestcase", "test.out")
