
#include "dpu_edhipc_decl.h"
#include "CGetParam.h"
#include <cstdlib>

char RetVal[100];


/*--------------------------------------------------------------------------

  GET_STRING

--------------------------------------------------------------------------*/
char *GetStringVal(string s, char *ValName, bool allowSpace)
{
  int i,j,k,l;
  bool start = false;

  // Default return value
  RetVal[0]=0;
  i = -1;

  // Find the field
  do {
     i = s.find(ValName,++i);
     if ( i >= 0 ) {
        j = s.rfind("\n", i);
        if (j >= 0)
           j++;
        else
           j = 0;
     }
  }
  //line starts with #, it's a comment
  while ((i >= 0) && (s.at(j) == '#'));

  if ( i >= 0 )
    {
      i=i+strlen(ValName);
      j = s.find("\n",i);
      if ( j > 0 )
	{
	   l=0;
	   for (k=i;k<j;k++)
	     {
               RetVal[l]=s[k];
               if (( RetVal[l] != ' ') && (RetVal[l] != '\t'))
                  start = true;

               if (start && ( RetVal[l] != ' ' || allowSpace) && (RetVal[l] != '\t')) l++;
	     }
           RetVal[l]=0;
	   // printf("substring %s %d %d <|%s|>\n",ValName,i,j,RetVal);
	}
     }
  return RetVal;
}

/*--------------------------------------------------------------------------

  GET_STRING

--------------------------------------------------------------------------*/
char *GetStringVal(string s,char *ValName)
{
  return GetStringVal(s, ValName, false);
}

/*--------------------------------------------------------------------------

  CGET_PARAM

--------------------------------------------------------------------------*/
CGetParam::CGetParam(char * FileName)
{
  int datFD;
  char *buf;
  int nRead;
  int i,j;

  nSiz=0;
  nRetVal = stat(FileName,&stbuf);
  if ( nRetVal != -1 )
    {
       nSiz = stbuf.st_size;
       if ( nSiz > 0 )
	 {
	    buf = new char[nSiz+1];

            datFD = open(FileName,O_RDONLY, 0660);
            if ( datFD != -1 )
            {
               // Read file into buf
	       nRead = 0;
                while ( nRead < nSiz )
	       {
	          nRead = nRead + read(datFD,buf+nRead,nSiz-nRead);
                  if ( nRead > 0 )
	          {

	            // More data to read
		    //printf("<|%s|>\n",buf);
                    //printf("Next line\n");

	          }
	       }
	       close(datFD);

               s = buf;

	    }
	 }
      }
}



/*--------------------------------------------------------------------------

  Destructor

--------------------------------------------------------------------------*/
CGetParam::~CGetParam()
{
}

/*--------------------------------------------------------------------------

  Get_Int

--------------------------------------------------------------------------*/
int CGetParam::GetInt(char *ValName)
{
  int retval=0;

  // Find the field

  return atoi(GetStringVal(s,ValName));
}

/*--------------------------------------------------------------------------

  Get_FLoat

--------------------------------------------------------------------------*/
float CGetParam::GetFloat(char *ValName)
{
  float retval=0.0;

  return atof(GetStringVal(s,ValName));
}

/*--------------------------------------------------------------------------

  Get_String

--------------------------------------------------------------------------*/
char *CGetParam::GetString(char *ValName)
{
  return GetStringVal(s,ValName);
}

/*--------------------------------------------------------------------------

  Get_String

--------------------------------------------------------------------------*/
char *CGetParam::GetString(char *ValName, bool allowSpace)
{
  return GetStringVal(s, ValName, allowSpace);
}









int CGetParam::do_antenna(m_ant_service_position  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_ttu_inactive  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_in_ftp  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_in_lock  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_in_new_ori  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_in_opz  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_in_orp   object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_turning_aborted  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_ori_chg   object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_ORP_ori  object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_ori_limits   object) {

  return 0;
}
int CGetParam::do_antenna(m_ant_temp   object) {

  return 0;
}
int CGetParam::do_antenna(M_ANTENNA_IDENT   object) {

  return 0;
}
int CGetParam::do_antenna(m_cs_active   object) {

  return 0;
}
int CGetParam::do_antenna(m_ins_attitude_data  object) {

  return 0;
}
int CGetParam::do_antenna(m_req_ant_ori_chg    object, int rt, int rp, int ra) {

  return 0;
}
int CGetParam::do_antenna(m_req_ant_orp_ori   object, int rt, int rp, int ra) {

  return 0;
}
int CGetParam::do_antenna(m_req_ant_position_status   object, int rt, int rp, int ra)
{
  m_ins_attitude_data  tmp_object;

  do_antenna(tmp_object);


  // Added
  T_MsgInfo msginfo;

  if( msginfo.MsgId == _edhIpcDecl::C_REQ_ANT_TEMP_ID )
    {
      return 1;
    }

  return 0;
}
int CGetParam::do_antenna(m_req_ant_temp   object, int rt, int rp, int ra) {

  return 0;
}
int CGetParam::do_antenna(m_req_ant_to_new_ori  object) {

  return 0;
}
int CGetParam::do_antenna(m_req_ant_to_orp   object) {

  return 0;
}
int CGetParam::do_antenna(M_REQ_ANTENNA_IDENT  object, int rt, int rp, int ra) {

  return 0;
}
