------------------------------------------------------------------------------
--                                                                          --
--                     Copyright (C) 2012-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Projects;         use GNATCOLL.Projects;
with GNATCOLL.VFS;              use GNATCOLL.VFS;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;
with GNAT.IO;                   use GNAT.IO;
with GNAT.Strings;              use GNAT.Strings;

procedure Test_C is
   procedure Display_Error (Msg : String);
   procedure Display_Error (Msg : String) is
   begin
      Put_Line ("Error while loading project: " & Msg);
   end Display_Error;

   Tree     : Project_Tree;
   Env      : Project_Environment_Access;
   Sources  : File_Array_Access;

begin
   Initialize (Env);
   Env.Register_Default_Language_Extension ("C", ".h", ".c");

   Tree.Load
      (Create ("root.gpr"), Env,
      Errors => Display_Error'Unrestricted_Access);

   Sources := Tree.Root_Project.Source_Files (Recursive => True);
   for S in Sources'Range loop
      Put_Line ("Source: " & Sources (S).Display_Base_Name);
   end loop;

   Tree.Unload;
end Test_C;
