-----------------------------------------------------------------------
--               GtkAda - Ada95 binding for Gtk+/Gnome               --
--                                                                   --
--   Copyright (C) 1998-2000 E. Briot, J. Brobecker and A. Charlet   --
--                Copyright (C) 2000-2013, AdaCore                   --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

pragma Style_Checks (Off);
pragma Warnings (Off, "*is already use-visible*");
with Glib.Type_Conversion_Hooks; use Glib.Type_Conversion_Hooks;

package body Gtk.Spinner is
   package Type_Conversion is new Glib.Type_Conversion_Hooks.Hook_Registrator
     (Get_Type'Access, Gtk_Spinner_Record);
   pragma Unreferenced (Type_Conversion);

   -------------
   -- Gtk_New --
   -------------

   procedure Gtk_New (Spinner : out Gtk_Spinner) is
   begin
      Spinner := new Gtk_Spinner_Record;
      Gtk.Spinner.Initialize (Spinner);
   end Gtk_New;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize (Spinner : access Gtk_Spinner_Record'Class) is
      function Internal return System.Address;
      pragma Import (C, Internal, "gtk_spinner_new");
   begin
      Set_Object (Spinner, Internal);
   end Initialize;

   -----------
   -- Start --
   -----------

   procedure Start (Spinner : access Gtk_Spinner_Record) is
      procedure Internal (Spinner : System.Address);
      pragma Import (C, Internal, "gtk_spinner_start");
   begin
      Internal (Get_Object (Spinner));
   end Start;

   ----------
   -- Stop --
   ----------

   procedure Stop (Spinner : access Gtk_Spinner_Record) is
      procedure Internal (Spinner : System.Address);
      pragma Import (C, Internal, "gtk_spinner_stop");
   begin
      Internal (Get_Object (Spinner));
   end Stop;

end Gtk.Spinner;
