#!/bin/sh
set -e

# called by uscan with '--upstream-version' <version> <file>
echo "version $2"
package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
version=$2
upstream_version="${version}"
tarball=$3

TAR=${package}_${version}.orig.tar.gz
DIR=minlog-${upstream_version}

unzip -q -d $DIR $tarball
GZIP=--best tar czf ../$TAR -X debian/orig-tar.excludes $DIR
rm -rf $tarball $DIR
