# -*- perl -*-
# generated by perlify.pl from libsbml/src/sbml/test/TestWriteSBML.cpp
# followed by little human processing to fix syntactic specialties
# perify.pl is unable to handle right now =;) xtof
use Test::More;
#BEGIN { plan tests => 428 };
BEGIN { plan tests => 425 }; # Until the libxml column number problem is fixed.

use LibSBML;
use strict;
#########################

# EXPAT = 1; LIBXML = 2;  XERCES = 3;
my $XML_PARSER = 2;

test_ReadSBML_SBML();
test_ReadSBML_Model();
test_ReadSBML_Model_L2();
test_ReadSBML_FunctionDefinition();
test_ReadSBML_UnitDefinition();
test_ReadSBML_UnitDefinition_L2();
test_ReadSBML_Unit();
test_ReadSBML_Unit_L2();
test_ReadSBML_Unit_defaults_L1_L2();
test_ReadSBML_Compartment();
test_ReadSBML_Compartment_L2();
test_ReadSBML_Compartment_defaults();
test_ReadSBML_Compartment_defaults_L2();
test_ReadSBML_Specie();
test_ReadSBML_Specie_defaults();
test_ReadSBML_Species();
test_ReadSBML_Species_L2_1();
test_ReadSBML_Species_L2_2();
test_ReadSBML_Species_L2_defaults();
test_ReadSBML_Parameter();
test_ReadSBML_Parameter_L2();
test_ReadSBML_Parameter_L2_defaults();
test_ReadSBML_Reaction();
test_ReadSBML_Reaction_defaults();
test_ReadSBML_Reaction_L2();
test_ReadSBML_Reaction_L2_defaults();
test_ReadSBML_SpecieReference_Reactant();
test_ReadSBML_SpecieReference_Product();
test_ReadSBML_SpecieReference_defaults();
test_ReadSBML_SpeciesReference_defaults();
test_ReadSBML_SpeciesReference_StoichiometryMath_1();
test_ReadSBML_SpeciesReference_StoichiometryMath_2();
test_ReadSBML_KineticLaw();
test_ReadSBML_KineticLaw_L2();
test_ReadSBML_KineticLaw_Parameter();
test_ReadSBML_AssignmentRule();
test_ReadSBML_RateRule();
test_ReadSBML_AlgebraicRule();
test_ReadSBML_AlgebraicRule_L2();
test_ReadSBML_CompartmentVolumeRule();
test_ReadSBML_ParameterRule();
test_ReadSBML_SpecieConcentrationRule();
test_ReadSBML_SpecieConcentrationRule_rate();
test_ReadSBML_SpeciesConcentrationRule();
test_ReadSBML_Event();
test_ReadSBML_Event_trigger();
test_ReadSBML_Event_delay();
test_ReadSBML_EventAssignment();
test_ReadSBML_metaid();
test_ReadSBML_metaid_Unit();
test_ReadSBML_metaid_Reaction();
test_ReadSBML_metaid_Event();
test_ReadSBML_metaid_ListOf();
test_ReadSBML_notes();
test_ReadSBML_notes_xmlns();
test_ReadSBML_notes_sbml();
test_ReadSBML_notes_sbml_L2();
test_ReadSBML_notes_ListOf();
test_ReadSBML_annotation();
test_ReadSBML_annotation_sbml();
test_ReadSBML_annotation_sbml_L2();
test_ReadSBML_line_col_numbers();

#---
sub readSBMLFromString {
 my $s = shift;
 my $rd = new LibSBML::SBMLReader;
 $rd->readSBMLFromString($s);
}

#---
sub SBML_HEADER_L2v1 {
 "<sbml xmlns='http://www.sbml.org/sbml/level2' level='2' version='1'> <model name='m'>\n";
}

#---
sub XML_HEADER {
 "<?xml version='1.0' encoding='UTF-8'?>\n";
}

#---
sub SBML_HEADER_L1v2 {
 "<sbml xmlns='http://www.sbml.org/sbml/level1' level='1' version='2'> <model name='m'>\n";
}

#---
sub SBML_HEADER_L2v2 {
 "<sbml xmlns='http://www.sbml.org/sbml/level2/version1' level='2' version='2'> <model name='m'>\n";
}

#---
sub SBML_FOOTER {
 "</model> </sbml>";
}

#---
sub SBML_HEADER_L1v1 {
 "<sbml xmlns='http://www.sbml.org/sbml/level1' level='1' version='1'> <model name='m'>\n";
}

#---
sub SBML_HEADER_L2v3 {
 "<sbml xmlns='http://www.sbml.org/sbml/level2/version3' level='2' version='3'> <model name='m'>\n";
}

#---
sub wrapSBML_L1v2 {
 XML_HEADER() . SBML_HEADER_L1v2() . $_[0] . SBML_FOOTER();
}

#---
sub wrapSBML_L2v2 {
 XML_HEADER() . SBML_HEADER_L2v2() . $_[0] . SBML_FOOTER();
}

#---
sub wrapSBML_L1v1 {
 XML_HEADER() . SBML_HEADER_L1v1() . $_[0] . SBML_FOOTER();
}

#---
sub wrapXML {
 XML_HEADER() . $_[0];
}

#---
sub wrapSBML_L2v3 {
 XML_HEADER() . SBML_HEADER_L2v3() . $_[0] . SBML_FOOTER();
}

#---
sub wrapSBML_L2v1 {
 XML_HEADER() . SBML_HEADER_L2v1() . $_[0] . SBML_FOOTER();
}

#---
sub test_ReadSBML_SBML {
 my $s = wrapXML("<sbml level='1' version='1'> </sbml>");
 my $D = readSBMLFromString($s);
 ok( $D->getLevel() == 1 );
 ok( $D->getVersion() == 1 );
}

#---
sub test_ReadSBML_Model {
 my $s = wrapXML("<sbml level='1' version='1'>" . 
                 "  <model name='testModel'></model>" . 
                 "</sbml>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getId() eq "testModel" );
}

#---
sub test_ReadSBML_Model_L2 {
 my $s = wrapXML("<sbml level='2' version='1'>" . 
                 "  <model id='testModel'> </model>" . 
                 "</sbml>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->isSetId() == 1 );
 ok( $M->isSetName() == 0 );
 ok( $M->getId() eq "testModel" );
}

#---
sub test_ReadSBML_FunctionDefinition {
 my $s = wrapSBML_L2v1("<listOfFunctionDefinitions>" . 
                       "  <functionDefinition id='pow3' name='cubed'>" . 
                       "    <math>" . 
                       "      <lambda>" . 
                       "        <bvar><ci> x </ci></bvar>" . 
                       "        <apply>" . 
                       "          <power/>" . 
                       "          <ci> x </ci>" . 
                       "          <cn> 3 </cn>" . 
                       "        </apply>" . 
                       "      </lambda>" . 
                       "    </math>" . 
                       "  </functionDefinition>" . 
                       "</listOfFunctionDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumFunctionDefinitions() == 1 );
 my $fd = $M->getFunctionDefinition(0);
# ok( $fd->getKind() == $LibSBML::FUNCTION_DEFINITION );
 ok( defined $fd );
 ok( $fd->isSetId() == 1 );
 ok( $fd->isSetName() == 1 );
 ok( $fd->getId() eq "pow3" );
 ok( $fd->getName() eq "cubed" );
 ok( $fd->isSetMath() == 1 );
 my $math = $fd->getMath();
 my $formula = $math->formulaToString();
 ok( defined $formula );
 ok( $formula eq "lambda(x, pow(x, 3))" );
}

#---
sub test_ReadSBML_UnitDefinition {
 my $s = wrapSBML_L1v2("<listOfUnitDefinitions>" . 
                       "  <unitDefinition name='mmls'/>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->getId() eq "mmls" );
}

#---
sub test_ReadSBML_UnitDefinition_L2 {
 my $s = wrapSBML_L2v1("<listOfUnitDefinitions>" . 
                       "  <unitDefinition id='mmls' name='mmol/ls'/>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->isSetId() == 1 );
 ok( $ud->isSetName() == 1 );
 ok( $ud->getId() eq "mmls" );
 ok( $ud->getName() eq "mmol/ls" );
}

#---
sub test_ReadSBML_Unit {
 my $s = wrapSBML_L1v2("<listOfUnitDefinitions>" . 
                       "  <unitDefinition name='substance'>" . 
                       "    <listOfUnits> <unit kind='mole' scale='-3'/> </listOfUnits>" . 
                       "  </unitDefinition>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->getId() eq "substance" );
 ok( $ud->getNumUnits() == 1 );
 my $u = $ud->getUnit(0);
 ok( $u->getKind() == $LibSBML::UNIT_KIND_MOLE );
 ok( $u->getExponent() == 1 );
 ok( $u->getScale() == -3 );
}

#---
sub test_ReadSBML_Unit_L2 {
 my $s = wrapSBML_L2v1("<listOfUnitDefinitions>" . 
                       "  <unitDefinition id='Fahrenheit'>" . 
                       "    <listOfUnits>" . 
                       "      <unit kind='Celsius' multiplier='1.8' offset='32'/>" . 
                       "    </listOfUnits>" . 
                       "  </unitDefinition>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->isSetId() == 1 );
 ok( $ud->getId() eq "Fahrenheit" );
 ok( $ud->getNumUnits() == 1 );
 my $u = $ud->getUnit(0);
 ok( $u->getKind() == $LibSBML::UNIT_KIND_CELSIUS );
 ok( $u->getExponent() == 1 );
 ok( $u->getScale() == 0 );
 ok( $u->getMultiplier() == 1.8 );
 ok( $u->getOffset() == 32 );
}

#---
sub test_ReadSBML_Unit_defaults_L1_L2 {
 my $s = wrapSBML_L1v2("<listOfUnitDefinitions>" . 
                       "  <unitDefinition name='bogomips'>" . 
                       "    <listOfUnits> <unit kind='second'/> </listOfUnits>" . 
                       "  </unitDefinition>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->getId() eq "bogomips" );
 ok( $ud->getNumUnits() == 1 );
 my $u = $ud->getUnit(0);
 ok( $u->getKind() == $LibSBML::UNIT_KIND_SECOND );
 ok( $u->getExponent() == 1 );
 ok( $u->getScale() == 0 );
 ok( $u->getMultiplier() == 1.0 );
 ok( $u->getOffset() == 0.0 );
}

#---
sub test_ReadSBML_Compartment {
 my $s = wrapSBML_L1v2("<listOfCompartments>" . 
                       "  <compartment name='mitochondria' volume='.0001' units='milliliters'" . 
                       "               outside='cell'/>" . 
                       "</listOfCompartments>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumCompartments() == 1 );
 my $c = $M->getCompartment(0);
 ok( $c->getId() eq "mitochondria" );
 ok( $c->getUnits() eq "milliliters" );
 ok( $c->getOutside() eq "cell" );
 ok( $c->getVolume() == .0001 );
 ok( $c->isSetVolume() == 1 );
 ok( $c->isSetSize() == 1 );
}

#---
sub test_ReadSBML_Compartment_L2 {
 my $s = wrapSBML_L2v1("<listOfCompartments>" . 
                       "  <compartment id='membrane' size='.3' spatialDimensions='2'" . 
                       "               units='area' outside='tissue' constant='false'/>" . 
                       "</listOfCompartments>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumCompartments() == 1 );
 my $c = $M->getCompartment(0);
 ok( $c->isSetId() == 1 );
 ok( $c->isSetName() == 0 );
 ok( $c->isSetVolume() == 1 );
 ok( $c->isSetSize() == 1 );
 ok( $c->isSetUnits() == 1 );
 ok( $c->isSetOutside() == 1 );
 ok( $c->getId() eq "membrane" );
 ok( $c->getUnits() eq "area" );
 ok( $c->getOutside() eq "tissue" );
 ok( $c->getSpatialDimensions() == 2 );
 ok( $c->getSize() == .3 );
}

#---
sub test_ReadSBML_Compartment_defaults {
 my $s = wrapSBML_L1v2("<listOfCompartments> <compartment name='cell'/> </listOfCompartments>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumCompartments() == 1 );
 my $c = $M->getCompartment(0);
 ok( $c->isSetId() == 1 );
 ok( $c->isSetVolume() == 1 );
 ok( $c->isSetSize() == 0 );
 ok( $c->isSetUnits() == 0 );
 ok( $c->isSetOutside() == 0 );
 ok( $c->getId() eq "cell" );
 ok( $c->getVolume() == 1.0 );
}

#---
sub test_ReadSBML_Compartment_defaults_L2 {
 my $s = wrapSBML_L2v1("<listOfCompartments> <compartment id='cell'/> </listOfCompartments>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumCompartments() == 1 );
 my $c = $M->getCompartment(0);
 ok( $c->isSetId() == 1 );
 ok( $c->isSetName() == 0 );
 ok( $c->isSetSize() == 0 );
 ok( $c->isSetUnits() == 0 );
 ok( $c->isSetOutside() == 0 );
 ok( $c->getId() eq "cell" );
 ok( $c->getSpatialDimensions() == 3 );
 ok( $c->getConstant() == 1 );
}

#---
sub test_ReadSBML_Specie {
 my $s = wrapSBML_L1v1("<listOfSpecie>" . 
                       "  <specie name='Glucose' compartment='cell' initialAmount='4.1'" . 
                       "          units='volume' boundaryCondition='false' charge='6'/>" . 
                       "</listOfSpecie>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->getId() eq "Glucose" );
 ok( $sp->getCompartment() eq "cell" );
 ok( $sp->getUnits() eq "volume" );
 ok( $sp->getInitialAmount() == 4.1 );
 ok( $sp->getBoundaryCondition() == 0 );
 ok( $sp->getCharge() == 6 );
 ok( $sp->isSetInitialAmount() == 1 );
 ok( $sp->isSetCharge() == 1 );
}

#---
sub test_ReadSBML_Specie_defaults {
 my $s = wrapSBML_L1v1("<listOfSpecie>" . 
                       "  <specie name='Glucose' compartment='cell' initialAmount='1.0'/>" . 
                       "</listOfSpecie>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->getId() eq "Glucose" );
 ok( $sp->getCompartment() eq "cell" );
 ok( $sp->getInitialAmount() == 1.0 );
 ok( $sp->getBoundaryCondition() == 0 );
 ok( $sp->isSetInitialAmount() == 1 );
 ok( $sp->isSetCharge() == 0 );
}

#---
sub test_ReadSBML_Species {
 my $s = wrapSBML_L1v2("<listOfSpecies>" . 
                       "  <species name='Glucose' compartment='cell' initialAmount='4.1'" . 
                       "           units='volume' boundaryCondition='false' charge='6'/>" . 
                       "</listOfSpecies>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->getId() eq "Glucose" );
 ok( $sp->getCompartment() eq "cell" );
 ok( $sp->getUnits() eq "volume" );
 ok( $sp->getInitialAmount() == 4.1 );
 ok( $sp->getBoundaryCondition() == 0 );
 ok( $sp->getCharge() == 6 );
 ok( $sp->isSetInitialAmount() == 1 );
 ok( $sp->isSetCharge() == 1 );
}

#---
sub test_ReadSBML_Species_L2_1 {
 my $s = wrapSBML_L2v1("<listOfSpecies>" . 
                       "  <species id='Glucose' compartment='cell' initialConcentration='4.1'" . 
                       "           substanceUnits='item' spatialSizeUnits='volume'" . 
                       "           boundaryCondition='true' charge='6' constant='true'/>" . 
                       "</listOfSpecies>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->isSetId() == 1 );
 ok( $sp->isSetName() == 0 );
 ok( $sp->isSetCompartment() == 1 );
 ok( $sp->isSetInitialAmount() == 0 );
 ok( $sp->isSetInitialConcentration() == 1 );
 ok( $sp->isSetSubstanceUnits() == 1 );
 ok( $sp->isSetSpatialSizeUnits() == 1 );
 ok( $sp->isSetCharge() == 1 );
 ok( $sp->getId() eq "Glucose" );
 ok( $sp->getCompartment() eq "cell" );
 ok( $sp->getSubstanceUnits() eq "item" );
 ok( $sp->getSpatialSizeUnits() eq "volume" );
 ok( $sp->getInitialConcentration() == 4.1 );
 ok( $sp->getHasOnlySubstanceUnits() == 0 );
 ok( $sp->getBoundaryCondition() == 1 );
 ok( $sp->getCharge() == 6 );
 ok( $sp->getConstant() == 1 );
}

#---
sub test_ReadSBML_Species_L2_2 {
 my $s = wrapSBML_L2v1("<listOfSpecies>" . 
                       "  <species id='s' compartment='c' hasOnlySubstanceUnits='true'/>" . 
                       "</listOfSpecies>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->isSetId() == 1 );
 ok( $sp->isSetName() == 0 );
 ok( $sp->isSetCompartment() == 1 );
 ok( $sp->isSetInitialAmount() == 0 );
 ok( $sp->isSetInitialConcentration() == 0 );
 ok( $sp->isSetSubstanceUnits() == 0 );
 ok( $sp->isSetSpatialSizeUnits() == 0 );
 ok( $sp->isSetCharge() == 0 );
 ok( $sp->getId() eq "s" );
 ok( $sp->getCompartment() eq "c" );
 ok( $sp->getHasOnlySubstanceUnits() == 1 );
 ok( $sp->getBoundaryCondition() == 0 );
 ok( $sp->getConstant() == 0 );
}

#---
sub test_ReadSBML_Species_L2_defaults {
 my $s = wrapSBML_L2v1("<listOfSpecies>" . 
                       "  <species id='Glucose_6_P' compartment='cell'/>" . 
                       "</listOfSpecies>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->isSetId() == 1 );
 ok( $sp->isSetName() == 0 );
 ok( $sp->isSetCompartment() == 1 );
 ok( $sp->isSetInitialAmount() == 0 );
 ok( $sp->isSetInitialConcentration() == 0 );
 ok( $sp->isSetSubstanceUnits() == 0 );
 ok( $sp->isSetSpatialSizeUnits() == 0 );
 ok( $sp->isSetCharge() == 0 );
 ok( $sp->getId() eq "Glucose_6_P" );
 ok( $sp->getCompartment() eq "cell" );
 ok( $sp->getHasOnlySubstanceUnits() == 0 );
 ok( $sp->getBoundaryCondition() == 0 );
 ok( $sp->getConstant() == 0 );
}

#---
sub test_ReadSBML_Parameter {
 my $s = wrapSBML_L1v2("<listOfParameters>" . 
                       "  <parameter name='Km1' value='2.3' units='second'/>" . 
                       "</listOfParameters>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumParameters() == 1 );
 my $p = $M->getParameter(0);
 ok( $p->getId() eq "Km1" );
 ok( $p->getUnits() eq "second" );
 ok( $p->getValue() == 2.3 );
 ok( $p->isSetValue() == 1 );
}

#---
sub test_ReadSBML_Parameter_L2 {
 my $s = wrapSBML_L2v1("<listOfParameters>" . 
                       "  <parameter id='T' value='4.6' units='Celsius' constant='false'/>" . 
                       "</listOfParameters>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumParameters() == 1 );
 my $p = $M->getParameter(0);
 ok( $p->isSetId() == 1 );
 ok( $p->isSetName() == 0 );
 ok( $p->isSetValue() == 1 );
 ok( $p->isSetUnits() == 1 );
 ok( $p->getId() eq "T" );
 ok( $p->getUnits() eq "Celsius" );
 ok( $p->getValue() == 4.6 );
 ok( $p->getConstant() == 0 );
}

#---
sub test_ReadSBML_Parameter_L2_defaults {
 my $s = wrapSBML_L2v1("<listOfParameters> <parameter id='x'/> </listOfParameters>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumParameters() == 1 );
 my $p = $M->getParameter(0);
 ok( $p->isSetId() == 1 );
 ok( $p->isSetName() == 0 );
 ok( $p->isSetValue() == 0 );
 ok( $p->isSetUnits() == 0 );
 ok( $p->getId() eq "x" );
 ok( $p->getConstant() == 1 );
}

#---
sub test_ReadSBML_Reaction {
 my $s = wrapSBML_L1v2("<listOfReactions>" . 
                       "  <reaction name='reaction_1' reversible='false'/>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->getId() eq "reaction_1" );
 ok( $r->getReversible() == 0 );
 ok( $r->getFast() == 0 );
}

#---
sub test_ReadSBML_Reaction_defaults {
 my $s = wrapSBML_L1v2("<listOfReactions>" . 
                       "  <reaction name='reaction_1'/>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->getId() eq "reaction_1" );
 ok( $r->getReversible() != 0 );
 ok( $r->getFast() == 0 );
}

#---
sub test_ReadSBML_Reaction_L2 {
 my $s = wrapSBML_L2v1("<listOfReactions>" . 
                       "  <reaction id='r1' reversible='false' fast='false'/>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->isSetId() == 1 );
 ok( $r->isSetName() == 0 );
 ok( $r->isSetFast() == 1 );
 ok( $r->getId() eq "r1" );
 ok( $r->getReversible() == 0 );
 ok( $r->getFast() == 0 );
}

#---
sub test_ReadSBML_Reaction_L2_defaults {
 my $s = wrapSBML_L2v1("<listOfReactions> <reaction id='r1'/> </listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->isSetId() == 1 );
 ok( $r->isSetName() == 0 );
 ok( $r->isSetFast() == 0 );
 ok( $r->getId() eq "r1" );
 ok( $r->getReversible() == 1 );
}

#---
sub test_ReadSBML_SpecieReference_Reactant {
 my $s = wrapSBML_L1v1("<listOfReactions>" . 
                       "  <reaction name='reaction_1' reversible='false'>" . 
                       "    <listOfReactants>" . 
                       "      <specieReference specie='X0' stoichiometry='1'/>" . 
                       "    </listOfReactants>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->getId() eq "reaction_1" );
 ok( $r->getReversible() == 0 );
 ok( $r->getNumReactants() == 1 );
 my $sr = $r->getReactant(0);
 ok( $sr->getSpecies() eq "X0" );
 ok( $sr->getStoichiometry() == 1 );
 ok( $sr->getDenominator() == 1 );
}

#---
sub test_ReadSBML_SpecieReference_Product {
 my $s = wrapSBML_L1v1("<listOfReactions>" . 
                       "  <reaction name='reaction_1' reversible='false'>" . 
                       "    <listOfProducts>" . 
                       "      <specieReference specie='S1' stoichiometry='1'/>" . 
                       "    </listOfProducts>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->getId() eq "reaction_1" );
 ok( $r->getReversible() == 0 );
 ok( $r->getNumProducts() == 1 );
 my $sr = $r->getProduct(0);
 ok( $sr->getSpecies() eq "S1" );
 ok( $sr->getStoichiometry() == 1 );
 ok( $sr->getDenominator() == 1 );
}

#---
sub test_ReadSBML_SpecieReference_defaults {
 my $s = wrapSBML_L1v1("<listOfReactions>" . 
                       "  <reaction name='reaction_1' reversible='false'>" . 
                       "    <listOfReactants>" . 
                       "      <specieReference specie='X0'/>" . 
                       "    </listOfReactants>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->getId() eq "reaction_1" );
 ok( $r->getReversible() == 0 );
 ok( $r->getNumReactants() == 1 );
 my $sr = $r->getReactant(0);
 ok( $sr->getSpecies() eq "X0" );
 ok( $sr->getStoichiometry() == 1 );
 ok( $sr->getDenominator() == 1 );
}

#---
sub test_ReadSBML_SpeciesReference_defaults {
 my $s = wrapSBML_L1v2("<listOfReactions>" . 
                       "  <reaction name='reaction_1' reversible='false'>" . 
                       "    <listOfReactants>" . 
                       "      <speciesReference species='X0'/>" . 
                       "    </listOfReactants>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
 ok( $r->getId() eq "reaction_1" );
 ok( $r->getReversible() == 0 );
 ok( $r->getNumReactants() == 1 );
 my $sr = $r->getReactant(0);
 ok( $sr->getSpecies() eq "X0" );
 ok( $sr->getStoichiometry() == 1 );
 ok( $sr->getDenominator() == 1 );
}

#---
sub test_ReadSBML_SpeciesReference_StoichiometryMath_1 {
 my $s = wrapSBML_L2v1("<listOfReactions>" . 
                       "  <reaction name='r1'>" . 
                       "    <listOfReactants>" . 
                       "      <speciesReference species='X0'>" . 
                       "        <stoichiometryMath>" . 
                       "          <math> <ci> x </ci> </math>" . 
                       "        </stoichiometryMath>" . 
                       "      </speciesReference>" . 
                       "    </listOfReactants>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
# ok( $r->getKind() == $LibSBML::SBML_REACTION );
 ok( defined $r );
 ok( $r->getNumReactants() == 1 );
 my $sr = $r->getReactant(0);
# ok( $sr->getKind() == $LibSBML::SBML_SPECIES_REFERENCE );
 ok( defined $sr );
 ok( $sr->isSetStoichiometryMath() == 1 );
 my $math = $sr->getStoichiometryMath();
 my $formula = $math->getMath()->formulaToString();
 ok( defined $formula );
 ok( $formula eq "x" );
}

#---
sub test_ReadSBML_SpeciesReference_StoichiometryMath_2 {
 my $s = wrapSBML_L2v1("<listOfReactions>" . 
                       "  <reaction name='r1'>" . 
                       "    <listOfReactants>" . 
                       "      <speciesReference species='X0'>" . 
                       "        <stoichiometryMath>" . 
                       "          <math> <cn type='rational'> 3 <sep/> 2 </cn> </math>" . 
                       "        </stoichiometryMath>" . 
                       "      </speciesReference>" . 
                       "    </listOfReactants>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
# ok( $r->getKind() == $LibSBML::SBML_REACTION );
 ok( defined $r );
 ok( $r->getNumReactants() == 1 );
 my $sr = $r->getReactant(0);
# ok( $sr->getKind() == $LibSBML::SBML_SPECIES_REFERENCE );
 ok( defined $sr );
 ok( $sr->isSetStoichiometryMath() == 0 );
 ok( $sr->getStoichiometry() == 3 );
 ok( $sr->getDenominator() == 2 );
}

#---
sub test_ReadSBML_KineticLaw {
 my $s = wrapSBML_L1v2("<listOfReactions>" . 
                       "  <reaction name='J1'>" . 
                       "    <kineticLaw formula='k1*X0'/>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r  = $M->getReaction(0);
 my $kl = $r->getKineticLaw();
 ok( $kl->getFormula() eq "k1*X0" );
}

#---
sub test_ReadSBML_KineticLaw_L2 {
 my $s = wrapSBML_L2v1("<listOfReactions>" . 
                       "  <reaction id='J1'>" . 
                       "    <kineticLaw>" . 
                       "      <math>" . 
                       "        <apply>" . 
                       "          <times/>" . 
                       "          <ci> k  </ci>" . 
                       "          <ci> S2 </ci>" . 
                       "          <ci> X0 </ci>" . 
                       "        </apply>" . 
                       "      </math>" . 
                       "    </kineticLaw>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r = $M->getReaction(0);
# ok( $r->getKind() == $LibSBML::SBML_REACTION );
 ok( defined $r );
 my $kl = $r->getKineticLaw();
# ok( $kl->getKind() == $LibSBML::SBML_KINETIC_LAW );
 ok( defined $kl);
 ok( $kl->isSetMath() == 1 );
 my $math = $kl->getMath();
 my $formula = $kl->getFormula();
 ok( defined $formula );
 ok( $formula eq "k * S2 * X0" );
}

#---
sub test_ReadSBML_KineticLaw_Parameter {
 my $s = wrapSBML_L1v2("<listOfReactions>" . 
                       "  <reaction name='J1'>" . 
                       "    <kineticLaw formula='k1*X0'>" . 
                       "      <listOfParameters>" . 
                       "        <parameter name='k1' value='0'/>" . 
                       "      </listOfParameters>" . 
                       "    </kineticLaw>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumReactions() == 1 );
 my $r  = $M->getReaction(0);
 my $kl = $r->getKineticLaw();
 ok( $kl->getFormula() eq "k1*X0" );
 ok( $kl->getNumParameters() == 1 );
 my $p = $kl->getParameter(0);
 ok( $p->getId() eq "k1" );
 ok( $p->getValue() == 0 );
}

#---
sub test_ReadSBML_AssignmentRule {
 my $s = wrapSBML_L2v1("<listOfRules>" . 
                       "  <assignmentRule variable='k'>" . 
                       "    <math>" . 
                       "      <apply>" . 
                       "        <divide/>" . 
                       "        <ci> k3 </ci>" . 
                       "        <ci> k2 </ci>" . 
                       "      </apply>" . 
                       "    </math>" . 
                       "  </assignmentRule>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $ar = $M->getRule(0);
# ok( $ar->getKind() ==  $LibSBML::SBML_ASSIGNMENT_RULE );
 ok( defined $ar );
 ok( $ar->isSetMath() == 1 );
 my $math = $ar->getMath();
 my $formula = $ar->getFormula();
 ok( defined $formula );
 ok( $formula eq "k3 / k2" );
}

#---
sub test_ReadSBML_RateRule {
 my $s = wrapSBML_L2v1("<listOfRules>" . 
                       "  <rateRule variable='x'>" . 
                       "    <math>" . 
                       "      <apply>" . 
                       "        <times/>" . 
                       "        <apply>" . 
                       "          <minus/>" . 
                       "          <cn> 1 </cn>" . 
                       "          <ci> x </ci>" . 
                       "        </apply>" . 
                       "        <apply>" . 
                       "          <ln/>" . 
                       "          <ci> x </ci>" . 
                       "        </apply>" . 
                       "      </apply>" . 
                       "    </math>" . 
                       "  </rateRule>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $rr = $M->getRule(0);
# ok( $rr->getKind() == $LibSBML::SBML_RATE_RULE );
 ok( defined $rr );
 ok( $rr->isSetMath() == 1 );
 my $math = $rr->getMath();
 my $formula = $rr->getFormula();
 ok( defined $formula );
 ok( $formula eq "(1 - x) * log(x)" );
}

#---
sub test_ReadSBML_AlgebraicRule {
 my $s = wrapSBML_L1v2("<listOfRules>" . 
                       "  <algebraicRule formula='x + 1'/>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $ar = $M->getRule(0);
 ok( $ar->getFormula() eq "x + 1" );
}

#---
sub test_ReadSBML_AlgebraicRule_L2 {
 my $s = wrapSBML_L2v1("<listOfRules>" . 
                       "  <algebraicRule>" . 
                       "    <math>" . 
                       "      <apply>" . 
                       "        <minus/>" . 
                       "        <apply>" . 
                       "          <plus/>" . 
                       "            <ci> S1 </ci>" . 
                       "            <ci> S2 </ci>" . 
                       "        </apply>" . 
                       "        <ci> T </ci>" . 
                       "      </apply>" . 
                       "    </math>" . 
                       "  </algebraicRule>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $ar = $M->getRule(0);
# ok( $ar->getKind() == $LibSBML::SBML_ASSIGNMENT_RULE );
 ok( defined $ar );
 ok( $ar->isSetMath() == 1 );
 my $math = $ar->getMath();
 my $formula = $ar->getFormula();
 ok( defined $formula );
 ok( $formula eq "S1 + S2 - T" );
}

#---
sub test_ReadSBML_CompartmentVolumeRule {
 my $s = wrapSBML_L1v2("<listOfRules>" . 
                       "  <compartmentVolumeRule compartment='A' formula='0.10 * t'/>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $cvr = $M->getRule(0);
 ok( $cvr->isCompartmentVolume() == 1 );
 ok( $cvr->getVariable() eq "A" );
 ok( $cvr->getFormula() eq "0.10 * t" );
 ok( $cvr->getType() == $LibSBML::RULE_TYPE_SCALAR );
}

#---
sub test_ReadSBML_ParameterRule {
 my $s = wrapSBML_L1v2("<listOfRules>" . 
                       "  <parameterRule name='k' formula='k3/k2'/>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $pr = $M->getRule(0);
 ok( $pr->isParameter() == 1 );
 ok( $pr->getVariable() eq "k" );
 ok( $pr->getFormula() eq "k3/k2" );
 ok( $pr->getType() == $LibSBML::RULE_TYPE_SCALAR );
}

#---
sub test_ReadSBML_SpecieConcentrationRule {
 my $s = wrapSBML_L1v1("<listOfRules>" . 
                       "  <specieConcentrationRule specie='s2' formula='k * t/(1 + k)'/>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $scr = $M->getRule(0);
 ok( $scr->isSpeciesConcentration() == 1 );
 ok( $scr->getVariable() eq "s2" );
 ok( $scr->getFormula() eq "k * t/(1 + k)" );
 ok( $scr->getType() == $LibSBML::RULE_TYPE_SCALAR );
}

#---
sub test_ReadSBML_SpecieConcentrationRule_rate {
 my $s = wrapSBML_L1v1("<listOfRules>" . 
                       "  <specieConcentrationRule specie='s2' formula='k * t/(1 + k)' " . 
                       "                           type='rate'/>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $scr = $M->getRule(0);
 ok( $scr->isSpeciesConcentration() == 1 );
 ok( $scr->getVariable() eq "s2" );
 ok( $scr->getFormula() eq "k * t/(1 + k)" );
 ok( $scr->getType() == $LibSBML::RULE_TYPE_RATE );
}

#---
sub test_ReadSBML_SpeciesConcentrationRule {
 my $s = wrapSBML_L1v2("<listOfRules>" . 
                       "  <speciesConcentrationRule species='s2' formula='k * t/(1 + k)'/>" . 
                       "</listOfRules>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumRules() == 1 );
 my $scr = $M->getRule(0);
 ok( $scr->isSpeciesConcentration() == 1 );
 ok( $scr->getVariable() eq "s2" );
 ok( $scr->getFormula() eq "k * t/(1 + k)" );
 ok( $scr->getType() == $LibSBML::RULE_TYPE_SCALAR );
}

#---
sub test_ReadSBML_Event {
 my $s = wrapSBML_L2v2("<listOfEvents>" . 
                       "  <event id='e1' name='MyEvent' timeUnits='time'/>" . 
                       "</listOfEvents>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumEvents() == 1 );
 my $e = $M->getEvent(0);
# ok( $e->getKind() == $LibSBML::SBML_EVENT );
 ok( defined $e );
 ok( $e->isSetId() == 1 );
 ok( $e->isSetName() == 1 );
 ok( $e->isSetTimeUnits() == 1 );
 ok( $e->isSetTrigger() == 0 );
 ok( $e->isSetDelay() == 0 );
 ok( $e->getId() eq "e1" );
 ok( $e->getName() eq "MyEvent" );
 ok( $e->getTimeUnits() eq "time" );
}

#---
sub test_ReadSBML_Event_trigger {
 my $s = wrapSBML_L2v1("<listOfEvents>" . 
                       "  <event>" . 
                       "    <trigger>" . 
                       "      <math>" . 
                       "        <apply>" . 
                       "          <leq/>" . 
                       "          <ci> P1 </ci>" . 
                       "          <ci> t  </ci>" . 
                       "        </apply>" . 
                       "      </math>" . 
                       "   </trigger>" . 
                       "  </event>" . 
                       "</listOfEvents>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumEvents() == 1 );
 my $e = $M->getEvent(0);
# ok( $e->getKind() == $LibSBML::SBML_EVENT );
 ok( defined $e );
 ok( $e->isSetDelay() == 0 );
 ok( $e->isSetTrigger() == 1 );
 my $trigger = $e->getTrigger();
 my $formula = $trigger->getMath()->formulaToString();
 ok( defined $formula );
 ok( $formula eq "leq(P1, t)" );
}

#---
sub test_ReadSBML_Event_delay {
 my $s = wrapSBML_L2v1("<listOfEvents>" . 
                       "  <event> <delay> <math> <cn> 5 </cn> </math> </delay> </event>" . 
                       "</listOfEvents>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumEvents() == 1 );
 my $e = $M->getEvent(0);
# ok( $e->$LibSBML::SBML_EVENT );
 ok( defined $e );
 ok( $e->isSetDelay() == 1 );
 ok( $e->isSetTrigger() == 0 );
 my $delay = $e->getDelay();
 my $formula = $delay->getMath()->formulaToString();
 ok( defined $formula );
 ok( $formula eq "5" );
}

#---
sub test_ReadSBML_EventAssignment {
 my $s = wrapSBML_L2v1("<listOfEvents>" . 
                       "  <event>" . 
                       "    <listOfEventAssignments>" . 
                       "      <eventAssignment variable='k2'>" . 
                       "        <math> <cn> 0 </cn> </math>" . 
                       "      </eventAssignment>" . 
                       "    </listOfEventAssignments>" . 
                       "  </event>" . 
                       "</listOfEvents>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumEvents() == 1 );
 my $e = $M->getEvent(0);
# ok( $e->getKind() == $LibSBML::SBML_EVENT );
 ok( defined $e );
 ok( $e->getNumEventAssignments() == 1 );
 my $ea = $e->getEventAssignment(0);
# ok( $e->getKind() == $LibSBML::SBML_EVENT_ASSIGNMENT );
 ok( defined $e );
 ok( $ea->isSetVariable() == 1 );
 ok( $ea->getVariable() eq "k2" );
 ok( $ea->isSetMath() == 1 );
 my $math = $ea->getMath();
 my $formula = $math->formulaToString();
 ok( defined $formula );
 ok( $formula eq "0" );
}

#---
sub test_ReadSBML_metaid {
 my $s = wrapSBML_L2v1("<listOfFunctionDefinitions>" . 
                       "  <functionDefinition metaid='fd'/>" . 
                       "</listOfFunctionDefinitions>" . 
                       "<listOfUnitDefinitions>" . 
                       "  <unitDefinition metaid='ud'/>" . 
                       "</listOfUnitDefinitions>" . 
                       "<listOfCompartments>" . 
                       "  <compartment metaid='c'/>" . 
                       "</listOfCompartments>" . 
                       "<listOfSpecies>" . 
                       "  <species metaid='s'/>" . 
                       "</listOfSpecies>" . 
                       "<listOfParameters>" . 
                       "  <parameter metaid='p'/>" . 
                       "</listOfParameters>" . 
                       "<listOfRules>" . 
                       "  <rateRule metaid='rr'/>" . 
                       "</listOfRules>" . 
                       "<listOfReactions>" . 
                       "  <reaction metaid='rx'/>" . 
                       "</listOfReactions>" . 
                       "<listOfEvents>" . 
                       " <event metaid='e'/>" . 
                       "</listOfEvents>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
# ok( $M->getKind() == $LibSBML::SBML_MODEL );
 ok( defined $M );
 my $sb = $M->getFunctionDefinition(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "fd" );
 $sb = $M->getUnitDefinition(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "ud" );
 $sb = $M->getCompartment(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "c" );
 $sb = $M->getSpecies(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "s" );
 $sb = $M->getParameter(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "p" );
 $sb = $M->getRule(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "rr" );
 $sb = $M->getReaction(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "rx" );
 $sb = $M->getEvent(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "e" );
}

#---
sub test_ReadSBML_metaid_Unit {
 my $s = wrapSBML_L2v1("<listOfUnitDefinitions>" . 
                       "  <unitDefinition metaid='ud'>" . 
                       "    <listOfUnits metaid='lou'>" . 
                       "      <unit metaid='u'/>" . 
                       "    </listOfUnits>" . 
                       "  </unitDefinition>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
# ok( $M->getKind() == $LibSBML::SBML_MODEL );
 ok(defined $M );
 my $ud = $M->getUnitDefinition(0);
 my $sb = $ud;
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "ud" );
 $sb = $ud->getListOfUnits();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lou" );
 $sb = $ud->getUnit(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "u" );
}

#---
sub test_ReadSBML_metaid_Reaction {
 my $s = wrapSBML_L2v1("<listOfReactions>" . 
                       "  <reaction metaid='r'>" . 
                       "    <listOfReactants metaid='lor'>" . 
                       "      <speciesReference metaid='sr1'/>" . 
                       "    </listOfReactants>" . 
                       "    <listOfProducts metaid='lop'>" . 
                       "      <speciesReference metaid='sr2'/>" . 
                       "    </listOfProducts>" . 
                       "    <listOfModifiers metaid='lom'>" . 
                       "      <modifierSpeciesReference metaid='msr'/>" . 
                       "    </listOfModifiers>" . 
                       "    <kineticLaw metaid='kl'/>" . 
                       "  </reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
# ok( $M->getKind() == $LibSBML::SBML_MODEL );
 ok( defined $M );
 my $r  = $M->getReaction(0);
 my $sb = $r;
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "r" );
 $sb = $r->getListOfReactants();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lor" );
 $sb = $r->getReactant(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "sr1" );
 $sb = $r->getListOfProducts();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lop" );
 $sb = $r->getProduct(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "sr2" );
 $sb = $r->getListOfModifiers();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lom" );
 $sb = $r->getModifier(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "msr" );
 $sb = $r->getKineticLaw();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "kl" );
}

#---
sub test_ReadSBML_metaid_Event {
 my $s = wrapSBML_L2v1("<listOfEvents>" . 
                       "  <event metaid='e'>" . 
                       "    <listOfEventAssignments metaid='loea'>" . 
                       "      <eventAssignment metaid='ea'/>" . 
                       "    </listOfEventAssignments>" . 
                       "  </event>" . 
                       "</listOfEvents>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
# ok( $M->getKind() == $LibSBML::SBML_MODEL );
 ok( defined $M );
 my $e  = $M->getEvent(0);
 my $sb = $e;
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "e" );
 $sb = $e->getListOfEventAssignments();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "loea" );
 $sb = $e->getEventAssignment(0);
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "ea" );
}

#---
sub test_ReadSBML_metaid_ListOf {
 my $s = wrapSBML_L2v1("<listOfFunctionDefinitions metaid='lofd'/>" . 
                       "<listOfUnitDefinitions     metaid='loud'/>" . 
                       "<listOfCompartments        metaid='loc'/>" . 
                       "<listOfSpecies             metaid='los'/>" . 
                       "<listOfParameters          metaid='lop'/>" . 
                       "<listOfRules               metaid='lor'/>" . 
                       "<listOfReactions           metaid='lorx'/>" . 
                       "<listOfEvents              metaid='loe'/>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( defined $M );
 my $sb = $M->getListOfFunctionDefinitions();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lofd" );
 $sb = $M->getListOfUnitDefinitions();
 ok( $sb->isSetMetaId() == 1 );
# ok( $sb->getMetaId() eq "loud" );
 ok( defined $sb );
 $sb = $M->getListOfCompartments();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "loc" );
 $sb = $M->getListOfSpecies();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "los" );
 $sb = $M->getListOfParameters();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lop" );
 $sb = $M->getListOfRules();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lor" );
 $sb = $M->getListOfReactions();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "lorx" );
 $sb = $M->getListOfEvents();
 ok( $sb->isSetMetaId() == 1 );
 ok( $sb->getMetaId() eq "loe" );
}

#---
sub test_ReadSBML_notes {
 my $s = wrapSBML_L2v3("<listOfReactions>" . 
                       "<reaction name='J1'>" . 
                       "  <kineticLaw formula='k1*X0'>" . 
                       "    <notes>This is a test note.</notes>" . 
                       "    <listOfParameters>" . 
                       "      <parameter name='k1' value='0'/>" . 
                       "    </listOfParameters>" . 
                       "  </kineticLaw>" . 
                       "</reaction>" . 
                       "</listOfReactions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 my $r  = $M->getReaction(0);
 my $kl = $r->getKineticLaw();
 ok( $kl->getNotes() ne '' );
 my $notes = $kl->getNotes()->getChild(0)->getCharacters();
 ok( $notes eq "This is a test note." );
}

#---
sub test_ReadSBML_notes_xmlns {
 my $s = wrapSBML_L2v3("<notes>" . 
                       "  <body xmlns=\"http://www.w3.org/1999/xhtml\">Some text.</body>" . 
                       "</notes>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNotes() ne '' );
 my $ns = $M->getNotes()->getChild(0)->getNamespaces();
 ok( $ns->getLength() == 1 );
 ok( $ns->getURI(0) eq "http://www.w3.org/1999/xhtml" );
 my $notes = $M->getNotes()->getChild(0)->getChild(0)->getCharacters();
 ok( $notes eq "Some text." );
}

#---
sub test_ReadSBML_notes_sbml {
 my $s = wrapXML("<sbml level='1' version='1'>" . 
                 "  <notes>Notes are not allowed as part of the SBML element.</notes>" . 
                 "</sbml>");
 my $D = readSBMLFromString($s);
 ok( $D->getNotes() ne '' );
 my $notes = $D->getNotes()->getChild(0)->getCharacters();
 ok( $notes eq "Notes are not allowed as part of the SBML element." );
 ok( $D->getNumErrors() > 0 );
}

#---
sub test_ReadSBML_notes_sbml_L2 {
 my $s = wrapXML("<sbml xmlns=\"http://www.sbml.org/sbml/level2\" level=\"2\" version=\"1\"> " . 
                 "  <notes>" . 
                 "    <html xmlns=\"http://www.w3.org/1999/xhtml\">" . 
                 "		 </html>" . 
                 "	  </notes>" . 
                 "	  <model>" . 
                 "   </model>" . 
                 " </sbml>");
 my $D = readSBMLFromString($s);
 ok( $D->getNotes() ne '' );
 ok( $D->getNumErrors() == 0 );
}

#---
sub test_ReadSBML_notes_ListOf {
 my $s = wrapSBML_L2v1("<listOfFunctionDefinitions>" . 
                       "  <notes>My Functions</notes>" . 
                       "  <functionDefinition/>" . 
                       "</listOfFunctionDefinitions>" . 
                       "<listOfUnitDefinitions>" . 
                       "  <notes>My Units</notes>" . 
                       "  <unitDefinition/>" . 
                       "</listOfUnitDefinitions>" . 
                       "<listOfCompartments>" . 
                       "  <notes>My Compartments</notes>" . 
                       "  <compartment/>" . 
                       "</listOfCompartments>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
# ok( $M->getKind() == $LibSBML::SBML_MODEL );
 ok( defined $M );
 my $sb = $M->getListOfFunctionDefinitions();
 ok( $sb->isSetNotes() == 1 );
 my $notes = $sb->getNotes()->getChild(0)->getCharacters();
 ok( $notes eq "My Functions" );
 $sb = $M->getListOfUnitDefinitions();
 ok( $sb->isSetNotes() == 1 );
 $notes = $sb->getNotes()->getChild(0)->getCharacters();
 ok( $notes eq "My Units" );
 $sb = $M->getListOfCompartments();
 ok( $sb->isSetNotes() == 1 );
 $notes = $sb->getNotes()->getChild(0)->getCharacters();
 ok( $notes eq "My Compartments" );
}

#---
sub test_ReadSBML_annotation {
 my $s = wrapSBML_L2v3("<annotation xmlns:mysim=\"http://www.mysim.org/ns\">" . 
                       "  <mysim:nodecolors mysim:bgcolor=\"green\" mysim:fgcolor=\"white\">" . 
                       "  </mysim:nodecolors>" . 
                       "  <mysim:timestamp>2000-12-18 18:31 PST</mysim:timestamp>" . 
                       "</annotation>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getAnnotation() ne '' );
 my $ann = $M->getAnnotation();
 ok( $ann->getNumChildren() == 2 );
}

#---
sub test_ReadSBML_annotation_sbml {
  my $s = wrapXML("<sbml level=\"1\" version=\"1\">" .
		  "  <annotation xmlns:jd = \"http://www.sys-bio.org/sbml\">" .
		  "    <jd:header>" .
		  "      <VersionHeader SBMLVersion = \"1.0\"/>" .
		  "    </jd:header>" .
		  "    <jd:display>" .
		  "      <SBMLGraphicsHeader BackGroundColor = \"15728639\"/>" .
		  "    </jd:display>" .
		  "  </annotation>" .
		  "</sbml>");

 my $D = readSBMLFromString($s);
 ok( $D->getNumErrors() > 0 );
}

#---
sub test_ReadSBML_annotation_sbml_L2 {
 my $s = wrapXML("<sbml xmlns=\"http://www.sbml.org/sbml/level2\" level=\"2\" version=\"1\"> " . 
                 "  <annotation>" . 
                 "    <rdf xmlns=\"http://www.w3.org/1999/anything\">" . 
                 "		 </rdf>" . 
                 "	  </annotation>" . 
                 "	  <model>" . 
                 "   </model>" . 
                 " </sbml>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $D->getNumErrors() == 0 );
}

#---
sub test_ReadSBML_line_col_numbers {
 my $s =
    "<?xml version='1.0' encoding='UTF-8'?>\n" .
    "<sbml xmlns='http://www.sbml.org/sbml/level2' level='2' version='1'>\n" .
    "  <model id='testModel' name='testModel'>\n" .
    "    <listOfReactions> <reaction/> </listOfReactions>\n" .
    "  </model>\n" .
    "</sbml>\n";

 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
  ok( defined $M );
 my $sb = $M;

 SKIP: {  # USE_EXPAT
   skip "line-column number test for expat", 2 if $XML_PARSER != 1; 
   ok( $sb->getLine() == 3 );
   ok( $sb->getColumn() == 2 );
 }
  
 SKIP: {  # USE_LIBXML
   skip "line-column number test for libxml", 2 if $XML_PARSER != 2;
   ok( $sb->getLine() == 3 );
#   ok( $sb->getColumn() == 2 );
 }
  
 SKIP: {  # USE_XERCES
   skip "line-column number test for xerces", 2 if $XML_PARSER != 3;
   ok( $sb->getLine() == 3 );
   ok( $sb->getColumn() == 42 );
 }

 $sb = $M->getListOfReactions();
  
 SKIP: {  # USE_EXPAT
   skip "line-column number test for expat", 2 if $XML_PARSER != 1; 
   ok( $sb->getLine() == 4 );
   ok( $sb->getColumn() == 4 );
 }
  
 SKIP: {  # USE_LIBXML
   skip "line-column number test for libxml", 2 if $XML_PARSER != 2;
   ok( $sb->getLine() == 4 );
#   ok( $sb->getColumn() == 4 );
 }

 SKIP: {  # USE_XERCES
   skip "line-column number test for xerces", 2 if $XML_PARSER != 3;
   ok( $sb->getLine() == 4 );
   ok( $sb->getColumn() == 22 );
 }
  
 $sb = $M->getReaction(0);
  
 SKIP: {  # USE_EXPAT
   skip "line-column number test for expat", 2 if $XML_PARSER != 1; 
   ok( $sb->getLine() == 4 );
   ok( $sb->getColumn() == 22 );
 }
  
 SKIP: { # USE_LIBXML
   skip "line-column number test for libxml", 2 if $XML_PARSER != 2;
   ok( $sb->getLine() == 4 );
#   ok( $sb->getColumn() == 22 );
 }

 SKIP: { # USE_XERCES
   skip "line-column number test for xerces", 2 if $XML_PARSER != 3; 
   ok( $sb->getLine() == 4 );
   ok( $sb->getColumn() == 34 );
 }
}
