C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

 	PROGRAM AXIS01
C
C	THIS PROGRAM DEMONSTRATES AXIS PLOTTING
C
C	OPEN MAGICS
C
	CALL POPEN
	CALL PARSE_COMMAND_LINE ('axis01')

	CALL PSETC ('PAGE_ID_LINE_USER_TEXT','TESTS/AXIS01')
	CALL PSETC ('SUBPAGE_FRAME','OFF')
	CALL PSETC ('SUBPAGE_MAP_PROJECTION','NONE')
C
C	SET PAGE LAYOUT VALUES
C
	CALL PSETR ('SUBPAGE_X_POSITION',4.0)
	CALL PSETR ('SUBPAGE_Y_POSITION',5.0)
	CALL PSETR ('SUBPAGE_X_LENGTH',21.0)
	CALL PSETR ('SUBPAGE_Y_LENGTH',13.0)
C
C	PLOT DEFAULT REGULAR AND LOGARITHMIC AXIS
C
	CALL AXIS01_ONE
	CALL PNEW ('PAGE')
C
C	PLOT USER LABELS AND TICKS
C

	CALL AXIS01_TWO
	CALL PNEW ('PAGE')
C
C	PLOT MULTIPLE AXES AND LAT/LONG LABELLING
C
	CALL AXIS01_THREE
	CALL PNEW ('PAGE')
C
C	PLOT GRID AND AXIS LINE
C
	CALL AXIS01_FOUR
	CALL PNEW ('PAGE')
C
C	PLOT SIMPLE DATE/TIME AXIS
C
	CALL AXIS01_FIVE
	CALL PNEW ('PAGE')
C
C	XXX - NOT FOR DOCUMENTATION - START XXX
C	PLOT LONGER DATE/TIME AXIS
C
	CALL AXIS01_SIX
    
      CALL PNEW ('PAGE')
      CALL AXIS01_SEVEN
C	XXX - NOT FOR DOCUMENTATION - END XXX
C
C	CLOSE MAGICS
C
	CALL PCLOSE
C
	END
	SUBROUTINE AXIS01_ONE
C
C	DRAW REGULAR AXIS WITH MOSTLY DEFAULT VALUES
C
	CALL PSETR ('AXIS_MIN_VALUE',1.0)
	CALL PSETR ('AXIS_MAX_VALUE',9.0)
	CALL PSETC ('AXIS_TITLE_TEXT','Simple REGULAR Axis')
	CALL PAXIS
C
C	DRAW LOGARITHMIC AXIS WITH MOSTLY DEFAULT VALUES
C
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_TYPE','LOGARITHMIC')
	CALL PSETR ('AXIS_MIN_VALUE',0.1)
	CALL PSETR ('AXIS_MAX_VALUE',500.0)
	CALL PSETC ('AXIS_TITLE_TEXT','Simple LOGARITHMIC Axis')
	CALL PAXIS
C
C	RESET SOME PARAMETERS
C
	CALL PRESET ('AXIS_TYPE')
	CALL PSETC ('AXIS_TYPE','REGULAR')
	CALL PRESET ('AXIS_TITLE_TEXT')
C
	RETURN
	END
	SUBROUTINE AXIS01_TWO
C
	CHARACTER*9 MONTHS
	DIMENSION MONTHS(3)
	DATA MONTHS/'APRIL','MAY','JUNE'/
C
C	USER LABELS AND TIP TITLE TEXT
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETR ('AXIS_MIN_VALUE',1.0)
	CALL PSETR ('AXIS_MAX_VALUE',4.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PSETC ('AXIS_TICK_LABEL_TYPE','LABEL_LIST')
	CALL PSET1C ('AXIS_TICK_LABEL_LIST',MONTHS,3)
	CALL PSETC ('AXIS_TICK_LABEL_POSITION','INTER_TICK')
	CALL PSETC ('AXIS_TIP_TITLE','ON')
	CALL PSETC ('AXIS_TIP_TITLE_TEXT','1987')
	CALL PAXIS
C
C	ADJUST TICK MARKS AND MINOR TICKS MARKS
C
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETR ('AXIS_MIN_VALUE',3.5)
	CALL PSETR ('AXIS_MAX_VALUE',8.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',0.25)
	CALL PSETC ('AXIS_TICK_LABEL_TYPE','NUMBER')
	CALL PSETC ('AXIS_TICK_LABEL_POSITION','ON_TICK')
	CALL PSETC ('AXIS_TICK_LABEL_FORMAT','(F3.1)')
	CALL PSETI ('AXIS_TICK_LABEL_FREQUENCY',2)
	CALL PSETC ('AXIS_MINOR_TICK','ON')
	CALL PSETI ('AXIS_MINOR_TICK_COUNT',5)
	CALL PSETC ('AXIS_TIP_TITLE','OFF')
	CALL PSETC ('AXIS_TITLE_TEXT','Forecast Days')
	CALL PAXIS
C
C	RESET SOME PARAMETERS
C
	CALL PRESET ('AXIS_TICK_LABEL_FORMAT')
	CALL PRESET ('AXIS_TICK_LABEL_FREQUENCY')
	CALL PRESET ('AXIS_MINOR_TICK')
	CALL PRESET ('AXIS_MINOR_TICK_COUNT')
C
	RETURN
	END
	SUBROUTINE AXIS01_THREE
C
C	PLOT HORIZONTAL LATITUDE AXIS.
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETR ('AXIS_MIN_VALUE',56.0)
	CALL PSETR ('AXIS_MAX_VALUE',38.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',2.0)
	CALL PSETC ('AXIS_MINOR_TICK','ON')
	CALL PSETI ('AXIS_MINOR_TICK_COUNT',1)
	CALL PSETC ('AXIS_TICK_LABEL_TYPE','LATITUDE')
	CALL PSETC ('AXIS_TITLE','OFF')
	CALL PSETC ('AXIS_TIP_TITLE','ON')
	CALL PSETC ('AXIS_TIP_TITLE_TEXT','Lat')
	CALL PAXIS
C
C	PLOT HORIZONTAL LONGITUDE AXIS.
C
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETR ('AXIS_MIN_VALUE',-42.0)
	CALL PSETR ('AXIS_MAX_VALUE',-28.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PSETC ('AXIS_MINOR_TICK','OFF')
	CALL PSETC ('AXIS_TICK_LABEL_TYPE','LONGITUDE')
	CALL PSETC ('AXIS_TIP_TITLE_TEXT','Lon')
	CALL PAXIS
C
C
C
C	RESET SOME PARAMETERS
C
	CALL PRESET ('AXIS_TICK_LABEL_LAST')
	CALL PRESET ('AXIS_TIP_TITLE')
C
	RETURN
	END
	SUBROUTINE AXIS01_FOUR
C
	DIMENSION ZPOS(5),YSTNS(5)
	CHARACTER*10 YSTNS
	DATA ZPOS/3.0,6.5,9.0,14.0,17.7/
	DATA YSTNS/'KEFLAVIK','SHIPI','SHIPJ','SHIPK','LAJES'/
C
C	PLOT USER DEFINED TICK POSITIONS AND GRID
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETC ('AXIS_TYPE','POSITION_LIST')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',20.0)
	CALL PSET1R ('AXIS_TICK_POSITION_LIST',ZPOS,5)
	CALL PSET1C ('AXIS_TICK_LABEL_LIST',YSTNS,5)
	CALL PSETC ('AXIS_TICK_LABEL_TYPE','label_list')
	CALL PSETC ('AXIS_GRID','ON')
	CALL PSETC ('AXIS_TITLE','OFF')
	CALL PAXIS
C
C	PLOT LOGARITHMIC GRID
C
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','RIGHT')
	CALL PSETC ('AXIS_TYPE','LOGARITHMIC')
	CALL PSETC ('AXIS_TICK_LABEL_TYPE','number')
	CALL PSETR ('AXIS_MIN_VALUE',1000.0)
	CALL PSETR ('AXIS_MAX_VALUE',100.0)
	CALL PSETC ('AXIS_TICK','OFF')
	CALL PSETC ('AXIS_LINE','OFF')
	CALL PSETC ('AXIS_TITLE','ON')
	CALL PSETC ('AXIS_TITLE_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_TITLE_TEXT','hPa')
	CALL PAXIS
C
	CALL PRESET ('AXIS_LINE')
	CALL PRESET ('AXIS_TICK')
	CALL PRESET ('AXIS_GRID')
	RETURN
	END
	SUBROUTINE AXIS01_FIVE
C
C	SIMPLE PROGRAM TO PLOT A DATE/TIME AXIS
C

	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')        
C
C	SET THE DATE/TIME AXIS SYSTEM
C
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PSETC('AXIS_DATE_MIN_VALUE','1998-04-21')     
	CALL PSETC('AXIS_DATE_MAX_VALUE','1998-05-10')     
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC ('AXIS_TITLE_TEXT','DATE/TIME Axes')
	CALL PAXIS 
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC('AXIS_DATE_TYPE','MONTHS')         
	CALL PSETC('AXIS_DATE_MIN_VALUE','1998-04-21')     
	CALL PSETC('AXIS_DATE_MAX_VALUE','2001-06-10')     
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TITLE','OFF')                     
	CALL PAXIS 
	RETURN     
	END
C
C
C	XXX - NOT FOR DOCUMENTATION - START XXX

	SUBROUTINE AXIS01_SIX
C	SIMPLE PROGRAM TO PLOT A DATE/TIME AXIS
C

	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')        
C
C	SET THE DATE/TIME AXIS SYSTEM
C
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PSETC('AXIS_DATE_MIN_VALUE','1998-04-21 18:00')     
	CALL PSETC('AXIS_DATE_MAX_VALUE','1998-05-10 00:00')     
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TITLE','ON')
	CALL PSETC ('AXIS_TITLE_TEXT','DATE/TIME Axes')
	CALL PAXIS 
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC('AXIS_DATE_TYPE','MONTHS')         
	CALL PSETC('AXIS_DATE_MIN_VALUE','1998-04-21')     
	CALL PSETC('AXIS_DATE_MAX_VALUE','2001-06-10')     
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TITLE','OFF')                     
	CALL PAXIS 
	RETURN     
	END	
      SUBROUTINE AXIS01_SEVEN
C
C	SIMPLE PROGRAM TO PLOT A DATE/TIME AXIS
C

		CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
		CALL PSETC ('AXIS_POSITION','BOTTOM')        
C
C	SET THE DATE/TIME AXIS SYSTEM
C
		call psetr("subpage_x_min_latitude", -20.)
		call psetr("subpage_x_max_latitude", 20.)
		call psetr("subpage_x_min_longitude", -60.)
		call psetr("subpage_x_max_longitude", 70.)
		CALL PSETC ('AXIS_TYPE','geoline')
        CALL PRESET('AXIS_TICK_INTERVAL')  
		CALL PSETC('AXIS_TITLE','ON')                     
		CALL PSETC ('AXIS_TITLE_TEXT',
     + 'example of <font colour="red">geoline</font>')
		CALL PAXIS 
		CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
		CALL PSETC ('AXIS_POSITION','LEFT')
		CALL PSETC ('AXIS_TYPE','DATE')
		CALL PSETC('AXIS_DATE_TYPE','MONTHS')         
		CALL PSETC('AXIS_DATE_MIN_VALUE','1998-04-21')     
		CALL PSETC('AXIS_DATE_MAX_VALUE','2001-06-10')     
		CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
		CALL PSETC('AXIS_TITLE','OFF')                     
		CALL PAXIS 
	RETURN     
	END
C	XXX - NOT FOR DOCUMENTATION - END XXX



C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END
