
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file SVGDriverAttributes.h
    \\brief Definition of SVGDriver Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "SVGDriverAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

SVGDriverAttributes::SVGDriverAttributes():
	logoLocation_(ParameterManager::getString("output_svg_logo_location")),
	desc_(ParameterManager::getString("output_svg_desc")),
	meta_(ParameterManager::getString("output_svg_meta")),
	external_(ParameterManager::getBool("output_svg_use_external_files")),
	fixSize_(ParameterManager::getBool("output_svg_fix_size"))
	
	
{
}


SVGDriverAttributes::~SVGDriverAttributes()
{

}


void SVGDriverAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "output_svg";
	prefix[i++] = "output";
	
	setAttribute(prefix, "output_svg_logo_location", logoLocation_, params);
	setAttribute(prefix, "output_svg_desc", desc_, params);
	setAttribute(prefix, "output_svg_meta", meta_, params);
	setAttribute(prefix, "output_svg_use_external_files", external_, params);
	setAttribute(prefix, "output_svg_fix_size", fixSize_, params);
	
	
}

void SVGDriverAttributes::copy(const SVGDriverAttributes& other)
{
	logoLocation_ = other.logoLocation_;
	desc_ = other.desc_;
	meta_ = other.meta_;
	external_ = other.external_;
	fixSize_ = other.fixSize_;
	
}


bool SVGDriverAttributes::accept(const string& node)
{

	if ( magCompare(node, "svg")  )
		return true;
	
	return false;
}

void SVGDriverAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "svg")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void SVGDriverAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " logoLocation = " <<  logoLocation_;
	out << " desc = " <<  desc_;
	out << " meta = " <<  meta_;
	out << " external = " <<  external_;
	out << " fixSize = " <<  fixSize_;
	
	out << "]" << "\n";
}

void SVGDriverAttributes::toxml(ostream& out)  const
{
	out <<  "\"svg\"";
	out << ", \"output_svg_logo_location\":";
	niceprint(out,logoLocation_);
	out << ", \"output_svg_desc\":";
	niceprint(out,desc_);
	out << ", \"output_svg_meta\":";
	niceprint(out,meta_);
	out << ", \"output_svg_use_external_files\":";
	niceprint(out,external_);
	out << ", \"output_svg_fix_size\":";
	niceprint(out,fixSize_);
	
}

static MagicsParameter<string> output_svg_logo_location("output_svg_logo_location", "inline");
static MagicsParameter<string> output_svg_desc("output_svg_desc", "");
static MagicsParameter<string> output_svg_meta("output_svg_meta", "");
static MagicsParameter<string> output_svg_use_external_files("output_svg_use_external_files", "off");
static MagicsParameter<string> output_svg_fix_size("output_svg_fix_size", "off");
