/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Msltoe_Julia_Bulb_Mod3
 * @reference
 * http://www.fractalforums.com/theory/choosing-the-squaring-formula-by-location/msg14320/#msg14320

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "MsltoeSym3Mod3Iteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MsltoeSym3Mod3Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 c = aux->const_c;
	aux->DE = aux->DE * 2.0f * aux->r;
	REAL4 z1 = z;
	REAL psi = mad(2.0f, M_PI_F, atan2(z.z, z.y));
	REAL psi2 = 0;
	while (psi > M_PI_8)
	{
		psi -= M_PI_4;
		psi2 -= M_PI_4; // M_PI_4 = pi/4
	}
	REAL cs = native_cos(psi2);
	REAL sn = native_sin(psi2);
	z1.y = mad(z.y, cs, -z.z * sn);
	z1.z = mad(z.y, sn, z.z * cs);
	z.y = z1.y;
	z.z = z1.z;
	REAL4 zs = z * z;
	REAL zs2 = zs.x + zs.y;
	// if (zs2 < 1e-21f)
	//	zs2 = 1e-21f;
	REAL zs3 = mad(
		zs.z, fractal->transformCommon.scale0 * fractal->transformCommon.scale0 * zs.y, (zs2 + zs.z));
	REAL zsd = (1.0f - native_divide(zs.z, zs3));

	z1.x = (zs.x - zs.y) * zsd;
	z1.y = (2.0f * z.x * z.y) * zsd * fractal->transformCommon.scale; // scaling y;
	z1.z = 2.0f * z.z * native_sqrt(zs2);
	z.x = z1.x;
	z.y = mad(z1.y, cs, z1.z * sn);
	z.z = mad(-z1.y, sn, z1.z * cs);
	z += fractal->transformCommon.additionConstant000;
	if (fractal->transformCommon.addCpixelEnabledFalse) // symmetrical addCpixel
	{
		REAL4 tempFAB = c;
		if (fractal->transformCommon.functionEnabledx) tempFAB.x = fabs(tempFAB.x);
		if (fractal->transformCommon.functionEnabledy) tempFAB.y = fabs(tempFAB.y);
		if (fractal->transformCommon.functionEnabledz) tempFAB.z = fabs(tempFAB.z);

		tempFAB *= fractal->transformCommon.constantMultiplier000;
		z.x += sign(z.x) * tempFAB.x;
		z.y += sign(z.y) * tempFAB.y;
		z.z += sign(z.z) * tempFAB.z;
	}
	REAL lengthTempZ = -length(z); // spherical offset
	// if (lengthTempZ > -1e-21f)
	//	lengthTempZ = -1e-21f;   //  z is neg.)
	z *= 1.0f + native_divide(fractal->transformCommon.offset, lengthTempZ);
	z *= fractal->transformCommon.scale1;
	aux->DE *= fabs(fractal->transformCommon.scale1);

	if (fractal->transformCommon.functionEnabledFalse // quaternion fold
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA)
	{
		aux->r = length(z);
		aux->DE = aux->DE * 2.0f * aux->r;
		z = (REAL4){z.x * z.x - z.y * z.y - z.z * z.z, z.x * z.y, z.x * z.z, z.w};
		if (fractal->analyticDE.enabledFalse)
		{
			REAL4 temp = z;
			REAL tempL = length(temp);
			z *= (REAL4){1.0f, 2.0f, 2.0f, 1.0f};
			// if (tempL < 1e-21f)
			//	tempL = 1e-21f;
			REAL avgScale = native_divide(length(z), tempL);
			aux->DE *= avgScale;
		}
		else
		{
			z *= (REAL4){1.0f, 2.0f, 2.0f, 1.0f};
		}
	}
	return z;
}