# LIBWLOCATE_FOUND - system has the LIBWLOCATE library
# LIBWLOCATE_INCLUDE_DIR - the LIBWLOCATE include directory
# LIBWLOCATE_LIBRARIES - The libraries needed to use LIBWLOCATE

if(LIBWLOCATE_INCLUDE_DIR AND LIBWLOCATE_LIBRARIES)
  set(LIBWLOCATE_FOUND TRUE)
else(LIBWLOCATE_INCLUDE_DIR AND LIBWLOCATE_LIBRARIES)

  find_path(LIBWLOCATE_INCLUDE_DIR NAMES libwlocate.h PATH_SUFFIXES libwlocate)
  find_library(LIBWLOCATE_LIBRARIES NAMES wlocate)

  include(FindPackageHandleStandardArgs)
  find_package_handle_standard_args(libwlocate DEFAULT_MSG LIBWLOCATE_INCLUDE_DIR LIBWLOCATE_LIBRARIES)

  mark_as_advanced(LIBWLOCATE_INCLUDE_DIR LIBWLOCATE_LIBRARIES)
endif(LIBWLOCATE_INCLUDE_DIR AND LIBWLOCATE_LIBRARIES)
