// SPDX-License-Identifier: LGPL-2.1-or-later
//
// SPDX-FileCopyrightText: 2010 Gaurav Gupta <1989.gaurav@googlemail.com>
// SPDX-FileCopyrightText: 2013 Sanjiban Bairagya <sanjiban22393@gmail.com>
//

#include "KmlAltitudeTagHandler.h"

#include "MarbleDebug.h"

#include "KmlElementDictionary.h"

#include "GeoDataCamera.h"
#include "GeoDataCoordinates.h"
#include "GeoDataGroundOverlay.h"
#include "GeoDataLocation.h"
#include "GeoDataLookAt.h"
#include "GeoParser.h"

namespace Marble
{
namespace kml
{
KML_DEFINE_TAG_HANDLER(altitude)
GeoNode *KmlaltitudeTagHandler::parse(GeoParser &parser) const
{
    Q_ASSERT(parser.isStartElement() && parser.isValidElement(QLatin1StringView(kmlTag_altitude)));

    GeoStackItem parentItem = parser.parentElement();

    qreal const altitude = parser.readElementText().trimmed().toDouble();
    if (parentItem.is<GeoDataLookAt>()) {
        parentItem.nodeAs<GeoDataLookAt>()->setAltitude(altitude);
    } else if (parentItem.is<GeoDataCamera>()) {
        parentItem.nodeAs<GeoDataCamera>()->setAltitude(altitude);
    } else if (parentItem.is<GeoDataGroundOverlay>()) {
        parentItem.nodeAs<GeoDataGroundOverlay>()->setAltitude(altitude);
    } else if (parentItem.is<GeoDataLocation>()) {
        parentItem.nodeAs<GeoDataLocation>()->setAltitude(altitude);
    }

    return nullptr;
}
}
}
