/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FileObject_H
#define FileObject_H

#include "IconObject.h"

#include <string>
using std::string;


class FileObject : public IconObject {
public:
	FileObject(Folder* parent,
		const IconClass& kind, const string& name,
		IconInfo* info);

	virtual ~FileObject(); 

private:
	FileObject(const FileObject&);
	FileObject& operator=(const FileObject&);

	virtual void doubleClick();
	virtual set<string> can();

	virtual void createFiles();
	virtual Request request() const;
	virtual void request(const Request&);
};

inline void destroy(FileObject**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FileObject);
//#endif

#endif
